/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.esri;

import java.nio.file.Paths;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTest.class})
public class TestShapefileFormatPlugin
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("shapefiles/", new String[0]));
    }

    @Test
    public void testRowCount() throws Exception {
        this.testBuilder().sqlQuery("SELECT count(*) FROM dfs.`shapefiles/CA-cities.shp`").ordered().baselineColumns(new String[]{"EXPR$0"}).baselineValues(new Object[]{5727L}).go();
    }

    @Test
    public void testShpQuery() throws Exception {
        String sql = "SELECT gid, srid, shapeType, name, st_astext(geom) as wkt FROM dfs.`shapefiles/CA-cities.shp` where gid = 100";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("gid", TypeProtos.MinorType.INT).addNullable("srid", TypeProtos.MinorType.INT).addNullable("shapeType", TypeProtos.MinorType.VARCHAR).addNullable("name", TypeProtos.MinorType.VARCHAR).addNullable("wkt", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{100, 4326, "Point", "Jenny Lind", "POINT (-120.8699371 38.0949216)"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testRegularQuery() throws Exception {
        String sql = "SELECT gid, srid, shapeType, name FROM dfs.`shapefiles/CA-cities.shp` where gid = 100";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("gid", TypeProtos.MinorType.INT).addNullable("srid", TypeProtos.MinorType.INT).addNullable("shapeType", TypeProtos.MinorType.VARCHAR).addNullable("name", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{100, 4326, "Point", "Jenny Lind"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT count(*) FROM dfs.`shapefiles/CA-cities.shp`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)5727L, (long)cnt);
    }
}

