/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.esri;

import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.ReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.esri.ShpBatchReader;
import org.apache.drill.exec.store.esri.ShpFormatConfig;
import org.apache.hadoop.conf.Configuration;

public class ShpFormatPlugin
extends EasyFormatPlugin<ShpFormatConfig> {
    public static final String PLUGIN_NAME = "shp";

    public ShpFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig, ShpFormatConfig formatConfig) {
        super(name, ShpFormatPlugin.easyConfig(fsConf, formatConfig), context, storageConfig, (FormatPluginConfig)formatConfig);
    }

    protected void configureScan(FileScanLifecycleBuilder builder, EasySubScan scan) {
        builder.nullType(Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
        builder.readerFactory((ReaderFactory)new ShpReaderFactory());
    }

    private static EasyFormatPlugin.EasyFormatConfig easyConfig(Configuration fsConf, ShpFormatConfig pluginConfig) {
        return EasyFormatPlugin.EasyFormatConfig.builder().readable(true).writable(false).blockSplittable(false).compressible(false).supportsProjectPushdown(true).extensions(pluginConfig.getExtensions()).fsConf(fsConf).defaultName(PLUGIN_NAME).scanVersion(EasyFormatPlugin.ScanFrameworkVersion.EVF_V2).supportsLimitPushdown(true).build();
    }

    public static class ShpReaderFactory
    extends FileReaderFactory {
        public ManagedReader newReader(FileSchemaNegotiator negotiator) {
            return new ShpBatchReader(negotiator);
        }
    }
}

