/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.exec.store.druid.common.DruidCompareOp;
import org.apache.drill.exec.store.druid.common.DruidFilterBase;

@JsonDeserialize(as=DruidBoundFilter.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "dimension", "lower", "upper", "lowerStrict", "upperStrict", "ordering"})
public class DruidBoundFilter
extends DruidFilterBase {
    private final String type = DruidCompareOp.TYPE_BOUND.getCompareOp();
    private final String dimension;
    private final String lower;
    private final String upper;
    private final Boolean lowerStrict;
    private final Boolean upperStrict;
    private final String ordering;

    @JsonCreator
    public DruidBoundFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="lower") String lower, @JsonProperty(value="upper") String upper, @JsonProperty(value="lowerStrict") Boolean lowerStrict, @JsonProperty(value="upperStrict") Boolean upperStrict) {
        this.dimension = dimension;
        this.lower = lower;
        this.upper = upper;
        this.lowerStrict = lowerStrict;
        this.upperStrict = upperStrict;
        this.ordering = this.getCompareOrdering();
    }

    public String getType() {
        return this.type;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getLower() {
        return this.lower;
    }

    public String getUpper() {
        return this.upper;
    }

    public Boolean getLowerStrict() {
        return this.lowerStrict;
    }

    public Boolean getUpperStrict() {
        return this.upperStrict;
    }

    public String getOrdering() {
        return this.ordering;
    }

    @JsonIgnore
    private String getCompareOrdering() {
        if (StringUtils.isNotEmpty((CharSequence)this.lower) && StringUtils.isNumeric((CharSequence)this.lower) || StringUtils.isNotEmpty((CharSequence)this.upper) && StringUtils.isNumeric((CharSequence)this.upper)) {
            return "numeric";
        }
        return "lexicographic";
    }
}

