/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.rest;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.drill.exec.store.druid.druid.DruidScanResponse;
import org.apache.drill.exec.store.druid.rest.DruidQueryClient;
import org.apache.drill.exec.store.druid.rest.RestClient;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class DruidQueryClientTest {
    @Mock
    private RestClient restClient;
    @Mock
    private Response httpResponse;
    @Mock
    private ResponseBody httpResponseBody;
    private DruidQueryClient druidQueryClient;
    private static final String BROKER_URI = "some broker uri";
    private static final String QUERY = "{\"queryType\":\"scan\",\"dataSource\":\"wikipedia\",\"descending\":false,\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"user\",\"value\":\"Dansker\"},{\"type\":\"search\",\"dimension\":\"comment\",\"query\":{\"type\":\"contains\",\"value\":\"Bitte\",\"caseSensitive\":false}}]},\"granularity\":\"all\",\"intervals\":[\"2016-06-27T00:00:00.000Z/2016-06-27T22:00:00.000Z\"],\"columns\":[],\"offset\":0,\"limit\":4096}";
    private static final Header ENCODING_HEADER = new BasicHeader("Content-Encoding", StandardCharsets.UTF_8.name());

    @Before
    public void setup() throws IOException {
        this.restClient = (RestClient)Mockito.mock(RestClient.class);
        this.httpResponse = (Response)Mockito.mock(Response.class);
        this.httpResponseBody = (ResponseBody)Mockito.mock(ResponseBody.class);
        Mockito.when((Object)this.httpResponse.isSuccessful()).thenReturn((Object)true);
        Mockito.when((Object)this.httpResponse.body()).thenReturn((Object)this.httpResponseBody);
        Mockito.when((Object)this.restClient.post("some broker uri/druid/v2", QUERY)).thenReturn((Object)this.httpResponse);
        this.druidQueryClient = new DruidQueryClient(BROKER_URI, this.restClient);
    }

    @Test(expected=Exception.class)
    public void executeQueryCalledDruidReturnsNon200ShouldThrowError() throws Exception {
        Mockito.when((Object)this.httpResponse.isSuccessful()).thenReturn((Object)false);
        this.druidQueryClient.executeQuery(QUERY);
    }

    @Test
    public void executeQueryCalledNoResponsesFoundReturnsEmptyEventList() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("[]".getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)this.httpResponseBody.byteStream()).thenReturn((Object)inputStream);
        DruidScanResponse response = this.druidQueryClient.executeQuery(QUERY);
        Assertions.assertThat((List)response.getEvents()).isEmpty();
    }

    @Test
    public void executeQueryCalledSuccessfullyParseQueryResults() throws Exception {
        String result = "[{\"segmentId\":\"wikipedia_2016-06-27T14:00:00.000Z_2016-06-27T15:00:00.000Z_2021-12-11T11:12:16.106Z\",\"columns\":[\"__time\",\"channel\",\"cityName\",\"comment\",\"countryIsoCode\",\"countryName\",\"diffUrl\",\"flags\",\"isAnonymous\",\"isMinor\",\"isNew\",\"isRobot\",\"isUnpatrolled\",\"metroCode\",\"namespace\",\"page\",\"regionIsoCode\",\"regionName\",\"user\",\"sum_deleted\",\"sum_deltaBucket\",\"sum_added\",\"sum_commentLength\",\"count\",\"sum_delta\"],\"events\":[{\"__time\":1467036000000,\"channel\":\"#de.wikipedia\",\"cityName\":null,\"comment\":\"Bitte [[WP:Literatur]] beachten.\",\"countryIsoCode\":null,\"countryName\":null,\"diffUrl\":\"https://de.wikipedia.org/w/index.php?diff=155672392&oldid=155667393\",\"flags\":null,\"isAnonymous\":\"false\",\"isMinor\":\"false\",\"isNew\":\"false\",\"isRobot\":\"false\",\"isUnpatrolled\":\"false\",\"metroCode\":null,\"namespace\":\"Main\",\"page\":\"Walfang\",\"regionIsoCode\":null,\"regionName\":null,\"user\":\"Dansker\",\"sum_deleted\":133,\"sum_deltaBucket\":-200,\"sum_added\":0,\"sum_commentLength\":32,\"count\":1,\"sum_delta\":-133}]}]";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)this.httpResponseBody.byteStream()).thenReturn((Object)inputStream);
        DruidScanResponse response = this.druidQueryClient.executeQuery(QUERY);
        Assertions.assertThat((List)response.getEvents()).isNotEmpty();
        Assertions.assertThat((int)response.getEvents().size()).isEqualTo(1);
        Assertions.assertThat((String)((ObjectNode)response.getEvents().get(0)).get("user").textValue()).isEqualTo((Object)"Dansker");
        Assertions.assertThat((int)((ObjectNode)response.getEvents().get(0)).get("sum_deleted").intValue()).isEqualTo(133);
    }
}

