/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.drill.exec.store.druid.DruidStoragePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TestDataGenerator.class);
    private static final OkHttpClient httpClient = new OkHttpClient();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String RESPONSE_SUCCESS = "SUCCESS";

    public static void startImport(DruidStoragePluginConfig druidStoragePluginConfig) throws Exception {
        if (TestDataGenerator.isDruidRunning(druidStoragePluginConfig)) {
            logger.debug("Starting Test Data Import");
            String taskId = TestDataGenerator.startImportTask(druidStoragePluginConfig);
            TestDataGenerator.waitForIndexingTaskToFinish(taskId, druidStoragePluginConfig);
            logger.debug("Finished Test Data Import");
        } else {
            logger.error("DRUID does not seem to be running...");
        }
    }

    private static boolean isDruidRunning(DruidStoragePluginConfig druidStoragePluginConfig) {
        boolean bl;
        block8: {
            String healthCheckUrl = druidStoragePluginConfig.getCoordinatorAddress() + "/status/health";
            Request get = new Request.Builder().url(healthCheckUrl).build();
            Response resp = httpClient.newCall(get).execute();
            try {
                boolean bl2 = bl = resp.isSuccessful() && resp.body().string().equalsIgnoreCase("true");
                if (resp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("Error getting druid status", (Throwable)ex);
                    return false;
                }
            }
            resp.close();
        }
        return bl;
    }

    private static String taskUrl(DruidStoragePluginConfig druidStoragePluginConfig) {
        return druidStoragePluginConfig.getCoordinatorAddress() + "/druid/indexer/v1/task";
    }

    private static String startImportTask(DruidStoragePluginConfig druidStoragePluginConfig) throws URISyntaxException, IOException {
        String string;
        block8: {
            String url = TestDataGenerator.taskUrl(druidStoragePluginConfig);
            RequestBody postBody = RequestBody.create((byte[])Files.readAllBytes(Paths.get(Resources.getResource((String)"wikipedia-index.json").toURI())));
            Request post = new Request.Builder().url(url).addHeader("Content-Type", "application/json").post(postBody).build();
            Response resp = httpClient.newCall(post).execute();
            try {
                String respBodyStr = resp.body().string();
                TaskStartResponse taskStartResponse = (TaskStartResponse)mapper.readValue(respBodyStr, TaskStartResponse.class);
                logger.debug("Started Indexing Task - {}", (Object)taskStartResponse.getTaskId());
                string = taskStartResponse.getTaskId();
                if (resp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("Error starting Indexing Task");
                    throw ex;
                }
            }
            resp.close();
        }
        return string;
    }

    private static void waitForIndexingTaskToFinish(String taskId, DruidStoragePluginConfig druidStoragePluginConfig) throws Exception {
        int sleepMinutes = 1;
        logger.info("Waiting {} minute(s) for Indexing Task - {} to finish", (Object)sleepMinutes, (Object)taskId);
        Thread.sleep(TimeUnit.MINUTES.toMillis(sleepMinutes));
        String url = TestDataGenerator.taskUrl(druidStoragePluginConfig) + "/" + taskId + "/status";
        Request get = new Request.Builder().url(url).addHeader("Content-Type", "application/json").build();
        try (Response resp = httpClient.newCall(get).execute();){
            InputStream jsonStream = resp.body().byteStream();
            TaskStatusResponse taskStatusResponse = (TaskStatusResponse)mapper.readValue(jsonStream, TaskStatusResponse.class);
            if (!taskStatusResponse.taskStatus.status.equalsIgnoreCase(RESPONSE_SUCCESS)) {
                throw new Exception(String.format("Task %s finished with status %s", taskId, taskStatusResponse.taskStatus.status));
            }
        }
        logger.debug("Task {} finished successfully", (Object)taskId);
    }

    private static class TaskStatusResponse {
        @JsonProperty(value="task")
        String taskId;
        @JsonProperty(value="status")
        TaskStatus taskStatus;

        public TaskStatusResponse(@JsonProperty(value="task") String taskId, @JsonProperty(value="status") TaskStatus taskStatus) {
            this.taskId = taskId;
            this.taskStatus = taskStatus;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TaskStatus {
        @JsonProperty
        String id;
        @JsonProperty
        String statusCode;
        @JsonProperty
        String status;
        @JsonProperty
        int duration;
        @JsonProperty
        String dataSource;

        @JsonCreator
        public TaskStatus(@JsonProperty(value="id") String id, @JsonProperty(value="statusCode") String statusCode, @JsonProperty(value="status") String status, @JsonProperty(value="duration") int duration, @JsonProperty(value="dataSource") String dataSource) {
            this.id = id;
            this.statusCode = statusCode;
            this.status = status;
            this.duration = duration;
            this.dataSource = dataSource;
        }
    }

    private static class TaskStartResponse {
        @JsonProperty(value="task")
        private final String taskId;

        @JsonCreator
        public TaskStartResponse(@JsonProperty(value="task") String taskId) {
            this.taskId = taskId;
        }

        public String getTaskId() {
            return this.taskId;
        }
    }
}

