/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import java.io.File;
import org.apache.drill.categories.DruidStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.druid.DruidFilterBuilderTest;
import org.apache.drill.exec.store.druid.DruidScanSpecBuilderTest;
import org.apache.drill.exec.store.druid.DruidStoragePluginConfig;
import org.apache.drill.exec.store.druid.DruidStoragePluginConfigTest;
import org.apache.drill.exec.store.druid.TestDataGenerator;
import org.apache.drill.exec.store.druid.TestDruidQueries;
import org.apache.drill.exec.store.druid.rest.DruidQueryClientTest;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestDruidQueries.class, DruidScanSpecBuilderTest.class, DruidStoragePluginConfigTest.class, DruidQueryClientTest.class, DruidFilterBuilderTest.class, DruidScanSpecBuilderTest.class})
@Category(value={SlowTest.class, DruidStorageTest.class})
public class DruidTestSuite {
    private static final Logger logger = LoggerFactory.getLogger(DruidTestSuite.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static DruidStoragePluginConfig druidStoragePluginConfig = null;

    @BeforeClass
    public static void initDruid() {
        try {
            JsonNode storagePluginJson = mapper.readTree(new File(Resources.getResource((String)"bootstrap-storage-plugins.json").toURI()));
            druidStoragePluginConfig = (DruidStoragePluginConfig)mapper.treeToValue((TreeNode)storagePluginJson.get("storage").get("druid"), DruidStoragePluginConfig.class);
            druidStoragePluginConfig.setEnabled(Boolean.valueOf(true));
            TestDataGenerator.startImport(druidStoragePluginConfig);
        }
        catch (Exception e) {
            logger.error("Error importing data into DRUID", (Throwable)e);
        }
    }

    public static DruidStoragePluginConfig getDruidStoragePluginConfig() {
        return druidStoragePluginConfig;
    }
}

