/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.druid.DruidTestConstants;
import org.apache.drill.exec.store.druid.DruidTestSuite;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidTestBase
extends ClusterTest
implements DruidTestConstants {
    private static final Logger logger = LoggerFactory.getLogger(DruidTestBase.class);
    private static StoragePluginRegistry pluginRegistry;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DruidTestBase.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        pluginRegistry = cluster.drillbit().getContext().getStorage();
        DruidTestSuite.initDruid();
        DruidTestBase.initDruidStoragePlugin();
    }

    private static void initDruidStoragePlugin() throws Exception {
        pluginRegistry.put("druid", (StoragePluginConfig)DruidTestSuite.getDruidStoragePluginConfig());
    }

    @AfterClass
    public static void tearDownDruidTestBase() throws StoragePluginRegistry.PluginException {
        if (pluginRegistry != null) {
            pluginRegistry.remove("druid");
        } else {
            logger.warn("Plugin Registry was null");
        }
    }
}

