/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.drill.exec.store.druid.DruidStoragePluginConfig;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DruidStoragePluginConfigTest {
    @Test
    public void testDruidStoragePluginConfigSuccessfullyParsed() throws URISyntaxException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode storagePluginJson = mapper.readTree(new File(Resources.getResource((String)"bootstrap-storage-plugins.json").toURI()));
        DruidStoragePluginConfig druidStoragePluginConfig = (DruidStoragePluginConfig)mapper.treeToValue((TreeNode)storagePluginJson.get("storage").get("druid"), DruidStoragePluginConfig.class);
        Assertions.assertThat((Object)druidStoragePluginConfig).isNotNull();
        Assertions.assertThat((String)druidStoragePluginConfig.getBrokerAddress()).isEqualTo((Object)"http://localhost:8082");
        Assertions.assertThat((String)druidStoragePluginConfig.getCoordinatorAddress()).isEqualTo((Object)"http://localhost:8081");
        Assertions.assertThat((int)druidStoragePluginConfig.getAverageRowSizeBytes()).isEqualTo(200);
        Assertions.assertThat((boolean)druidStoragePluginConfig.isEnabled()).isFalse();
    }

    @Test
    public void testDefaultRowSizeUsedWhenNotProvidedInConfig() throws JsonProcessingException {
        String druidConfigStr = "{\n  \"storage\":{\n    \"druid\" : {\n      \"type\" : \"druid\",\n      \"brokerAddress\" : \"http://localhost:8082\",\n      \"coordinatorAddress\": \"http://localhost:8081\",\n      \"enabled\" : false\n    }\n  }\n}\n";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode storagePluginJson = mapper.readTree(druidConfigStr);
        DruidStoragePluginConfig druidStoragePluginConfig = (DruidStoragePluginConfig)mapper.treeToValue((TreeNode)storagePluginJson.get("storage").get("druid"), DruidStoragePluginConfig.class);
        Assertions.assertThat((int)druidStoragePluginConfig.getAverageRowSizeBytes()).isEqualTo(100);
    }
}

