/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.exec.store.druid.DruidScanSpecBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class DruidScanSpecBuilderTest {
    private static final String SOME_DATASOURCE_NAME = "some datasource";
    private static final long SOME_DATASOURCE_SIZE = 500L;
    private static final String SOME_DATASOURCE_MIN_TIME = "some min time";
    private static final String SOME_DATASOURCE_MAX_TIME = "some max time";
    private static final String SOME_FIELD = "some field";
    private static final String SOME_VALUE = "some value";
    private DruidScanSpecBuilder druidScanSpecBuilder;

    @Before
    public void setup() {
        this.druidScanSpecBuilder = new DruidScanSpecBuilder();
    }

    @Test
    public void buildCalledWithEqualFxShouldBuildSelectorFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "equal", schemaPath, (Object)SOME_VALUE);
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"selector\",\"dimension\":\"some field\",\"value\":\"some value\"}");
    }

    @Test
    public void buildCalledWithEqualFxIntervalFieldShouldBuildIntervalFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)"eventInterval");
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "equal", schemaPath, (Object)SOME_VALUE);
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"eventInterval\":\"some value\"}");
    }

    @Test
    public void buildCalledWithNotEqualFxShouldBuildSelectorFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "not_equal", schemaPath, (Object)SOME_VALUE);
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"some field\",\"value\":\"some value\"}}");
    }

    @Test
    public void buildCalledWithGreaterThanOrEqualToFxShouldBuildBoundFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "greater_than_or_equal_to", schemaPath, (Object)SOME_VALUE);
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"bound\",\"dimension\":\"some field\",\"lower\":\"some value\",\"ordering\":\"lexicographic\"}");
    }

    @Test
    public void buildCalledWithGreaterThanFxShouldBuildBoundFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "greater_than", schemaPath, (Object)SOME_VALUE);
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"bound\",\"dimension\":\"some field\",\"lower\":\"some value\",\"lowerStrict\":true,\"ordering\":\"lexicographic\"}");
    }

    @Test
    public void buildCalledWithGreaterThanFxAndNumericValueShouldBuildBoundFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "greater_than", schemaPath, (Object)"1");
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"bound\",\"dimension\":\"some field\",\"lower\":\"1\",\"lowerStrict\":true,\"ordering\":\"numeric\"}");
    }

    @Test
    public void buildCalledWithLessThanOrEqualToFxShouldBuildBoundFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "less_than_or_equal_to", schemaPath, (Object)SOME_VALUE);
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"bound\",\"dimension\":\"some field\",\"upper\":\"some value\",\"ordering\":\"lexicographic\"}");
    }

    @Test
    public void buildCalledWithLessThanFxShouldBuildBoundFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "less_than", schemaPath, (Object)SOME_VALUE);
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"bound\",\"dimension\":\"some field\",\"upper\":\"some value\",\"upperStrict\":true,\"ordering\":\"lexicographic\"}");
    }

    @Test
    public void buildCalledWithLessThanFxAndNumericValueShouldBuildBoundFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "less_than", schemaPath, (Object)"1");
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"bound\",\"dimension\":\"some field\",\"upper\":\"1\",\"upperStrict\":true,\"ordering\":\"numeric\"}");
    }

    @Test
    public void buildCalledWithIsNullFxShouldBuildSelectorFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "isnull", schemaPath, null);
        Assertions.assertThat((Object)druidScanSpec).isNotNull();
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"selector\",\"dimension\":\"some field\",\"value\":null}");
    }

    @Test
    public void buildCalledWithIsNotNullFxShouldBuildSelectorFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "isnotnull", schemaPath, null);
        Assertions.assertThat((Object)druidScanSpec).isNotNull();
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"some field\",\"value\":null}}");
    }

    @Test
    public void buildCalledWithLikeFxButIfValueIsPrefixedWithRegexKeywordHintShouldBuildRegexFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "like", schemaPath, (Object)"$regex$_some_regular_expression");
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"regex\",\"dimension\":\"some field\",\"pattern\":\"some_regular_expression\"}");
    }

    @Test
    public void buildCalledWithLikeFxShouldBuildSearchFilter() {
        SchemaPath schemaPath = SchemaPath.getSimplePath((String)SOME_FIELD);
        DruidScanSpec druidScanSpec = this.druidScanSpecBuilder.build(SOME_DATASOURCE_NAME, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME, "like", schemaPath, (Object)"some search string");
        Assertions.assertThat((String)druidScanSpec.getFilter().toJson()).isEqualTo((Object)"{\"type\":\"search\",\"dimension\":\"some field\",\"query\":{\"type\":\"contains\",\"value\":\"some search string\",\"caseSensitive\":false}}");
    }
}

