/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.exec.store.druid.DruidFilterBuilder;
import org.apache.drill.exec.store.druid.DruidGroupScan;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.exec.store.druid.common.DruidFilter;
import org.apache.drill.exec.store.druid.common.DruidSelectorFilter;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public class DruidFilterBuilderTest {
    private static final String SOME_DATASOURCE_NAME = "some data source";
    private static final long SOME_DATASOURCE_SIZE = 500L;
    private static final String SOME_DATASOURCE_MIN_TIME = "some min time";
    private static final String SOME_DATASOURCE_MAX_TIME = "some max time";
    @Mock
    private LogicalExpression logicalExpression;
    private DruidFilterBuilder druidFilterBuilder;
    private DruidScanSpec druidScanSpecLeft;
    private DruidScanSpec druidScanSpecRight;

    @Before
    public void setup() {
        this.logicalExpression = (LogicalExpression)Mockito.mock(LogicalExpression.class);
        DruidSelectorFilter someDruidSelectorFilter = new DruidSelectorFilter("some dimension", "some value");
        DruidSelectorFilter someOtherDruidSelectorFilter = new DruidSelectorFilter("some other dimension", "some other value");
        this.druidScanSpecLeft = new DruidScanSpec(SOME_DATASOURCE_NAME, (DruidFilter)someDruidSelectorFilter, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME);
        this.druidScanSpecRight = new DruidScanSpec(SOME_DATASOURCE_NAME, (DruidFilter)someOtherDruidSelectorFilter, 500L, SOME_DATASOURCE_MIN_TIME, SOME_DATASOURCE_MAX_TIME);
        try {
            Mockito.when((Object)this.logicalExpression.accept((ExprVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.druidScanSpecRight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DruidGroupScan druidGroupScan = new DruidGroupScan("some username", null, this.druidScanSpecLeft, null, 5);
        this.druidFilterBuilder = new DruidFilterBuilder(druidGroupScan, this.logicalExpression);
    }

    @Test
    public void parseTreeWithAndOfTwoSelectorFilters() {
        DruidScanSpec parsedSpec = this.druidFilterBuilder.parseTree();
        String expectedFilterJson = "{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"some dimension\",\"value\":\"some value\"},{\"type\":\"selector\",\"dimension\":\"some other dimension\",\"value\":\"some other value\"}]}";
        String actual = parsedSpec.getFilter().toJson();
        Assertions.assertThat((String)actual).isEqualTo((Object)expectedFilterJson);
    }

    @Test
    public void visitBooleanOperatorWithAndOperator() {
        LogicalExpression logicalExpression2 = (LogicalExpression)Mockito.mock(LogicalExpression.class);
        try {
            Mockito.when((Object)this.logicalExpression.accept((ExprVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.druidScanSpecLeft);
            Mockito.when((Object)logicalExpression2.accept((ExprVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.druidScanSpecRight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BooleanOperator booleanOperator = new BooleanOperator("booleanAnd", Stream.of(this.logicalExpression, logicalExpression2).collect(Collectors.toList()), null);
        DruidScanSpec druidScanSpec = this.druidFilterBuilder.visitBooleanOperator(booleanOperator, null);
        String expectedFilterJson = "{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"some dimension\",\"value\":\"some value\"},{\"type\":\"selector\",\"dimension\":\"some other dimension\",\"value\":\"some other value\"}]}";
        String actual = druidScanSpec.getFilter().toJson();
        Assertions.assertThat((String)actual).isEqualTo((Object)expectedFilterJson);
    }

    @Test
    public void visitBooleanOperatorWithOrOperator() {
        LogicalExpression logicalExpression2 = (LogicalExpression)Mockito.mock(LogicalExpression.class);
        try {
            Mockito.when((Object)this.logicalExpression.accept((ExprVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.druidScanSpecLeft);
            Mockito.when((Object)logicalExpression2.accept((ExprVisitor)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.druidScanSpecRight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BooleanOperator booleanOperator = new BooleanOperator("booleanOr", Stream.of(this.logicalExpression, logicalExpression2).collect(Collectors.toList()), null);
        DruidScanSpec druidScanSpec = this.druidFilterBuilder.visitBooleanOperator(booleanOperator, null);
        String expectedFilterJson = "{\"type\":\"or\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"some dimension\",\"value\":\"some value\"},{\"type\":\"selector\",\"dimension\":\"some other dimension\",\"value\":\"some other value\"}]}";
        String actual = druidScanSpec.getFilter().toJson();
        Assertions.assertThat((String)actual).isEqualTo((Object)expectedFilterJson);
    }
}

