/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.ArrayList;
import okhttp3.Response;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.druid.druid.DruidScanResponse;
import org.apache.drill.exec.store.druid.rest.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidQueryClient {
    private static final Logger logger = LoggerFactory.getLogger(DruidQueryClient.class);
    private static final String QUERY_BASE_URI = "/druid/v2";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final RestClient restClient;
    private final String queryUrl;

    public DruidQueryClient(String brokerURI, RestClient restClient) {
        this.queryUrl = brokerURI + QUERY_BASE_URI;
        this.restClient = restClient;
        logger.debug("Initialized DruidQueryClient with druidURL - {}", (Object)this.queryUrl);
    }

    public DruidScanResponse executeQuery(String query) throws Exception {
        logger.debug("Executing Query - {}", (Object)query);
        try (Response response = this.restClient.post(this.queryUrl, query);){
            if (!response.isSuccessful()) {
                throw UserException.dataReadError().message("Error executing druid query. HTTP request failed", new Object[0]).addContext("Response code", (long)response.code()).addContext("Response message", response.message()).build(logger);
            }
            InputStream responseStream = response.body().byteStream();
            ArrayNode responses = (ArrayNode)mapper.readValue(responseStream, ArrayNode.class);
            DruidScanResponse druidScanResponse = this.parseResponse(responses);
            return druidScanResponse;
        }
    }

    private DruidScanResponse parseResponse(ArrayNode responses) {
        String segmentId = "empty";
        ArrayList<ObjectNode> events = new ArrayList<ObjectNode>();
        ArrayList<String> columns = new ArrayList<String>();
        if (responses.size() > 0) {
            int i;
            ObjectNode firstNode = (ObjectNode)responses.get(0);
            segmentId = firstNode.get("segmentId").textValue();
            ArrayNode columnsNode = (ArrayNode)firstNode.get("columns");
            ArrayNode eventsNode = (ArrayNode)firstNode.get("events");
            for (i = 0; i < columnsNode.size(); ++i) {
                String column = columnsNode.get(i).textValue();
                columns.add(column);
            }
            for (i = 0; i < eventsNode.size(); ++i) {
                ObjectNode eventNode = (ObjectNode)eventsNode.get(i);
                events.add(eventNode);
            }
        }
        return new DruidScanResponse(segmentId, columns, events);
    }
}

