/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import okhttp3.Response;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.druid.druid.SimpleDatasourceInfo;
import org.apache.drill.exec.store.druid.rest.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidAdminClient {
    private static final Logger logger = LoggerFactory.getLogger(DruidAdminClient.class);
    private static final String DATASOURCES_BASE_URI = "/druid/coordinator/v1/datasources?simple";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final String coordinatorAddress;
    private final RestClient restClient;

    public DruidAdminClient(String coordinatorAddress, RestClient restClient) {
        this.coordinatorAddress = coordinatorAddress;
        this.restClient = restClient;
    }

    public List<SimpleDatasourceInfo> getDataSources() throws IOException {
        String url = this.coordinatorAddress + DATASOURCES_BASE_URI;
        try (Response response = this.restClient.get(url);){
            if (!response.isSuccessful()) {
                throw UserException.dataReadError().message("Error getting druid datasources. HTTP request failed", new Object[0]).addContext("Response code", (long)response.code()).addContext("Response message", response.message()).build(logger);
            }
            InputStream responseStream = response.body().byteStream();
            List list = (List)mapper.readValue(responseStream, (TypeReference)new TypeReference<List<SimpleDatasourceInfo>>(){});
            return list;
        }
    }
}

