/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import org.apache.drill.categories.DruidStorageTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.druid.DruidTestBase;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore(value="These tests require a running druid instance. You may start druid by using the docker-compose provide in resources/druid and enable these tests")
@Category(value={SlowTest.class, DruidStorageTest.class})
public class TestDruidQueries
extends DruidTestBase {
    @Test
    public void testEqualsFilter() throws Exception {
        this.testBuilder().sqlQuery(String.format("select * from druid.`%s` as ds where ds.user = 'Dansker'", "wikipedia")).unOrdered().expectsNumRecords(2).go();
    }

    @Test
    public void testTwoANDdEqualsFilter() throws Exception {
        this.testBuilder().sqlQuery(String.format("select * from druid.`%s` as ds where ds.user = 'Dansker' AND ds.comment like 'Bitte'", "wikipedia")).unOrdered().expectsNumRecords(1).go();
    }

    @Test
    public void testTwoOrdEqualsFilter() throws Exception {
        this.testBuilder().sqlQuery(String.format("select * from druid.`%s` as ds where ds.user = 'Dansker' OR ds.page = '1904'", "wikipedia")).unOrdered().expectsNumRecords(3).go();
    }

    @Test
    public void testSingleColumnProject() throws Exception {
        String query = String.format("SELECT ds.`comment` FROM druid.`%s` as ds", "wikipedia");
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"comment"}).expectsNumRecords(24433).go();
    }

    @Test
    public void testCountAllRowsQuery() throws Exception {
        String query = String.format("SELECT count(*) as mycount FROM druid.`%s` as ds", "wikipedia");
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"mycount"}).baselineValues(new Object[]{24433L}).go();
    }
}

