/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta;

import java.math.BigDecimal;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.delta.format.DeltaFormatPluginConfig;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeltaQueriesTest
extends ClusterTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DeltaQueriesTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        StoragePluginRegistry pluginRegistry = cluster.drillbit().getContext().getStorage();
        FileSystemConfig pluginConfig = (FileSystemConfig)pluginRegistry.getPlugin("dfs").getConfig();
        HashMap<String, DeltaFormatPluginConfig> formats = new HashMap<String, DeltaFormatPluginConfig>(pluginConfig.getFormats());
        formats.put("delta", new DeltaFormatPluginConfig(null, null));
        FileSystemConfig newPluginConfig = new FileSystemConfig(pluginConfig.getConnection(), pluginConfig.getConfig(), pluginConfig.getWorkspaces(), formats, PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER);
        newPluginConfig.setEnabled(Boolean.valueOf(pluginConfig.isEnabled()));
        pluginRegistry.put("dfs", (StoragePluginConfig)newPluginConfig);
        dirTestWatcher.copyResourceToRoot(Paths.get("data-reader-primitives", new String[0]));
        dirTestWatcher.copyResourceToRoot(Paths.get("data-reader-partition-values", new String[0]));
        dirTestWatcher.copyResourceToRoot(Paths.get("data-reader-nested-struct", new String[0]));
    }

    @Test
    public void testSerDe() throws Exception {
        client.alterSession("planner.slice_target", (Object)1);
        String plan = this.queryBuilder().sql("select * from table(dfs.`data-reader-partition-values` (type => 'delta'))").explainJson();
        long count = this.queryBuilder().physical(plan).run().recordCount();
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testAllPrimitives() throws Exception {
        this.testBuilder().sqlQuery("select * from dfs.`data-reader-primitives`").ordered().baselineColumns(new String[]{"as_int", "as_long", "as_byte", "as_short", "as_boolean", "as_float", "as_double", "as_string", "as_binary", "as_big_decimal"}).baselineValues(new Object[]{null, null, null, null, null, null, null, null, null, null}).baselineValues(new Object[]{0, 0L, 0, 0, true, Float.valueOf(0.0f), 0.0, "0", new byte[]{0, 0}, BigDecimal.valueOf(0L)}).baselineValues(new Object[]{1, 1L, 1, 1, false, Float.valueOf(1.0f), 1.0, "1", new byte[]{1, 1}, BigDecimal.valueOf(1L)}).baselineValues(new Object[]{2, 2L, 2, 2, true, Float.valueOf(2.0f), 2.0, "2", new byte[]{2, 2}, BigDecimal.valueOf(2L)}).baselineValues(new Object[]{3, 3L, 3, 3, false, Float.valueOf(3.0f), 3.0, "3", new byte[]{3, 3}, BigDecimal.valueOf(3L)}).baselineValues(new Object[]{4, 4L, 4, 4, true, Float.valueOf(4.0f), 4.0, "4", new byte[]{4, 4}, BigDecimal.valueOf(4L)}).baselineValues(new Object[]{5, 5L, 5, 5, false, Float.valueOf(5.0f), 5.0, "5", new byte[]{5, 5}, BigDecimal.valueOf(5L)}).baselineValues(new Object[]{6, 6L, 6, 6, true, Float.valueOf(6.0f), 6.0, "6", new byte[]{6, 6}, BigDecimal.valueOf(6L)}).baselineValues(new Object[]{7, 7L, 7, 7, false, Float.valueOf(7.0f), 7.0, "7", new byte[]{7, 7}, BigDecimal.valueOf(7L)}).baselineValues(new Object[]{8, 8L, 8, 8, true, Float.valueOf(8.0f), 8.0, "8", new byte[]{8, 8}, BigDecimal.valueOf(8L)}).baselineValues(new Object[]{9, 9L, 9, 9, false, Float.valueOf(9.0f), 9.0, "9", new byte[]{9, 9}, BigDecimal.valueOf(9L)}).go();
    }

    @Test
    public void testProjectingColumns() throws Exception {
        String query = "select as_int, as_string from dfs.`data-reader-primitives`";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"columns=\\[`as_int`, `as_string`\\]"}).match();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"as_int", "as_string"}).baselineValues(new Object[]{null, null}).baselineValues(new Object[]{0, "0"}).baselineValues(new Object[]{1, "1"}).baselineValues(new Object[]{2, "2"}).baselineValues(new Object[]{3, "3"}).baselineValues(new Object[]{4, "4"}).baselineValues(new Object[]{5, "5"}).baselineValues(new Object[]{6, "6"}).baselineValues(new Object[]{7, "7"}).baselineValues(new Object[]{8, "8"}).baselineValues(new Object[]{9, "9"}).go();
    }

    @Test
    public void testProjectNestedColumn() throws Exception {
        String query = "select t.a.ac.acb as acb, b from dfs.`data-reader-nested-struct` t";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"columns=\\[`a`.`ac`.`acb`, `b`\\]"}).match();
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"acb", "b"}).baselineValues(new Object[]{0L, 0}).baselineValues(new Object[]{1L, 1}).baselineValues(new Object[]{2L, 2}).baselineValues(new Object[]{3L, 3}).baselineValues(new Object[]{4L, 4}).baselineValues(new Object[]{5L, 5}).baselineValues(new Object[]{6L, 6}).baselineValues(new Object[]{7L, 7}).baselineValues(new Object[]{8L, 8}).baselineValues(new Object[]{9L, 9}).go();
    }

    @Test
    public void testPartitionPruning() throws Exception {
        String query = "select as_int, as_string from dfs.`data-reader-partition-values` where as_long = 1";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"numFiles\\=1"}).match();
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"as_int", "as_string"}).baselineValues(new Object[]{"1", "1"}).go();
    }

    @Test
    public void testEmptyResults() throws Exception {
        String query = "select as_int, as_string from dfs.`data-reader-partition-values` where as_long = 101";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"numFiles\\=1"}).match();
        this.testBuilder().sqlQuery(query).ordered().expectsEmptyResultSet().go();
    }

    @Test
    public void testLimit() throws Exception {
        String query = "select as_int, as_string from dfs.`data-reader-partition-values` limit 1";
        this.queryBuilder().sql(query).planMatcher().include(new String[]{"Limit\\(fetch\\=\\[1\\]\\)"}).include(new String[]{"limit\\=1"}).match();
        long count = this.queryBuilder().sql(query).run().recordCount();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testSnapshotVersion() throws Exception {
        String query = "select as_int, as_string from table(dfs.`data-reader-partition-values`(type => 'delta', version => 0))  where as_long = 1";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"as_int", "as_string"}).baselineValues(new Object[]{"1", "1"}).go();
    }
}

