/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestMetricsReporter;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.KafkaExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import io.confluent.rest.metrics.MetricsResourceMethodApplicationListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

@Tag(value="IntegrationTest")
public class MetricsResourceMethodApplicationListenerIntegrationTest {
    TestRestConfig config;
    ApplicationWithFilter app;
    private Server server;
    volatile Throwable handledException = null;
    private AtomicInteger counter;

    @BeforeEach
    public void setUp(TestInfo info) throws Exception {
        TestMetricsReporter.reset();
        Properties props = new Properties();
        props.setProperty("debug", "false");
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        if (info.getDisplayName().contains("testMetricLatencySloSlaEnabled")) {
            props.put("metrics.latency.slo.sla.enable", "true");
            props.put("metrics.latency.slo.ms", "0");
            props.put("metrics.latency.sla.ms", "10000");
        }
        if (info.getDisplayName().contains("WithGlobalStatsRequestTagsEnabled")) {
            props.put("metrics.global.stats.request.tags.enable", "true");
        }
        this.config = TestRestConfig.maprCompatible(props);
        this.app = new ApplicationWithFilter(this.config);
        this.server = this.app.createServer();
        this.server.start();
        this.counter = new AtomicInteger();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testListenerHandlesDispatchErrorsGracefully() {
        Throwable cause;
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/private/endpoint").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assertions.assertEquals((int)500, (int)response.getStatus());
        Assertions.assertNotNull((Object)this.handledException);
        for (cause = this.handledException; !(cause instanceof ProcessingException) && cause != cause.getCause(); cause = cause.getCause()) {
        }
        Assertions.assertTrue((boolean)(cause instanceof ProcessingException));
        Assertions.assertEquals((Object)"Resource Java method invocation error.", (Object)cause.getMessage());
    }

    @Test
    public void testSuccessMetrics() {
        int totalRequests = 10;
        IntStream.range(0, totalRequests).forEach(i -> this.makeSuccessfulCall());
        int totalRequestsCheckpoint = 0;
        int helloRequestsCheckpoint = 0;
        int helloTag1RequestsCheckpoint = 0;
        int helloTag2RequestsCheckpoint = 0;
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().group().equals("jersey-metrics")) continue;
            switch (metric.metricName().name()) {
                case "request-count": 
                case "request-total": {
                    this.assertMetric(metric, totalRequests);
                    ++totalRequestsCheckpoint;
                    break;
                }
                case "hello.request-count": 
                case "hello.request-total": {
                    if (metric.metricName().tags().containsValue("value1")) {
                        this.assertMetric(metric, (totalRequests + 1) / 3);
                        ++helloTag1RequestsCheckpoint;
                        break;
                    }
                    if (metric.metricName().tags().containsValue("value2")) {
                        this.assertMetric(metric, totalRequests / 3);
                        ++helloTag2RequestsCheckpoint;
                        break;
                    }
                    if (!metric.metricName().tags().isEmpty()) break;
                    this.assertMetric(metric, (totalRequests + 2) / 3);
                    ++helloRequestsCheckpoint;
                }
            }
        }
        Assertions.assertEquals((int)2, (int)totalRequestsCheckpoint);
        Assertions.assertEquals((int)2, (int)helloTag1RequestsCheckpoint);
        Assertions.assertEquals((int)2, (int)helloTag2RequestsCheckpoint);
        Assertions.assertEquals((int)2, (int)helloRequestsCheckpoint);
    }

    @Test
    public void test4xxMetrics() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/private/fake").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assertions.assertEquals((int)404, (int)response.getStatus());
        ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/private/fake").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        int rateCheckpoint4xx = 0;
        int windowCheckpoint4xx = 0;
        int rateCheckpoint429 = 0;
        int windowCheckpoint429 = 0;
        int rateCheckpointNot4xx = 0;
        int windowCheckpointNot4xx = 0;
        int anyErrorRateCheckpoint = 0;
        int anyErrorWindowCheckpoint = 0;
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            Object metricValue;
            if (metric.metricName().name().equals("request-error-rate") && metric.metricName().group().equals("jersey-metrics")) {
                Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("rate"));
                metricValue = metric.metricValue();
                Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Error rate metrics should be measurable");
                double errorRateValue = (Double)metricValue;
                if (metric.metricName().tags().getOrDefault("http_status_code", "").equals("4xx")) {
                    ++rateCheckpoint4xx;
                    Assertions.assertTrue((errorRateValue > 0.0 ? 1 : 0) != 0, (String)("Actual: " + errorRateValue));
                } else if (metric.metricName().tags().getOrDefault("http_status_code", "").equals("429")) {
                    ++rateCheckpoint429;
                    Assertions.assertTrue((errorRateValue == 0.0 || Double.isNaN(errorRateValue) ? 1 : 0) != 0, (String)String.format("Actual: %f (%s)", errorRateValue, metric.metricName()));
                } else if (!metric.metricName().tags().isEmpty()) {
                    ++rateCheckpointNot4xx;
                    Assertions.assertTrue((errorRateValue == 0.0 || Double.isNaN(errorRateValue) ? 1 : 0) != 0, (String)String.format("Actual: %f (%s)", errorRateValue, metric.metricName()));
                } else {
                    ++anyErrorRateCheckpoint;
                }
            }
            if (!metric.metricName().name().equals("request-error-count") || !metric.metricName().group().equals("jersey-metrics")) continue;
            Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("sampledstat"));
            metricValue = metric.metricValue();
            Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Error count metrics should be measurable");
            double errorCountValue = (Double)metricValue;
            if (metric.metricName().tags().getOrDefault("http_status_code", "").equals("4xx")) {
                ++windowCheckpoint4xx;
                Assertions.assertTrue((errorCountValue == 2.0 ? 1 : 0) != 0, (String)("Actual: " + errorCountValue));
                continue;
            }
            if (metric.metricName().tags().getOrDefault("http_status_code", "").equals("429")) {
                ++windowCheckpoint429;
                continue;
            }
            if (!metric.metricName().tags().isEmpty()) {
                ++windowCheckpointNot4xx;
                Assertions.assertTrue((errorCountValue == 0.0 || Double.isNaN(errorCountValue) ? 1 : 0) != 0, (String)String.format("Actual: %f (%s)", errorCountValue, metric.metricName()));
                continue;
            }
            ++anyErrorWindowCheckpoint;
            Assertions.assertTrue((errorCountValue == 2.0 ? 1 : 0) != 0, (String)("Count for all errors actual: " + errorCountValue));
        }
        int non4xxCount = MetricsResourceMethodApplicationListener.HTTP_STATUS_CODE_TEXT.length - 2;
        Assertions.assertEquals((int)1, (int)anyErrorRateCheckpoint);
        Assertions.assertEquals((int)1, (int)anyErrorWindowCheckpoint);
        Assertions.assertEquals((int)1, (int)rateCheckpoint4xx);
        Assertions.assertEquals((int)1, (int)windowCheckpoint429);
        Assertions.assertEquals((int)1, (int)rateCheckpoint429);
        Assertions.assertEquals((int)1, (int)windowCheckpoint4xx);
        Assertions.assertEquals((int)non4xxCount, (int)rateCheckpointNot4xx);
        Assertions.assertEquals((int)non4xxCount, (int)windowCheckpointNot4xx);
    }

    @Test
    public void test429Metrics() throws InterruptedException {
        this.make429Call();
        this.make429Call();
        int windowCheckpoint429 = 0;
        int rateCheckpoint429 = 0;
        Thread.sleep(500L);
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            Object metricValue;
            if (metric.metricName().name().equals("request-error-rate") && metric.metricName().group().equals("jersey-metrics") && metric.metricName().tags().getOrDefault("http_status_code", "").equals("429")) {
                Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("rate"));
                metricValue = metric.metricValue();
                Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Error rate metrics should be measurable");
                double errorRateValue = (Double)metricValue;
                ++rateCheckpoint429;
                Assertions.assertTrue((errorRateValue > 0.0 ? 1 : 0) != 0, (String)("Actual: " + errorRateValue));
            }
            if (!metric.metricName().name().equals("request-error-count") || !metric.metricName().group().equals("jersey-metrics") || !metric.metricName().tags().getOrDefault("http_status_code", "").equals("429")) continue;
            Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("sampledstat"));
            metricValue = metric.metricValue();
            Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Error count metrics should be measurable");
            double errorCountValue = (Double)metricValue;
            ++windowCheckpoint429;
            Assertions.assertEquals((double)2.0, (double)errorCountValue, (String)("Actual: " + errorCountValue));
        }
        Assertions.assertEquals((int)1, (int)rateCheckpoint429);
        Assertions.assertEquals((int)1, (int)windowCheckpoint429);
    }

    @DisplayName(value="WithGlobalStatsRequestTagsEnabled")
    @Test
    public void test429Metrics_WithGlobalStatsRequestTagsEnabled() throws InterruptedException {
        int totalRequests = 10;
        IntStream.range(0, totalRequests).forEach(i -> this.make429Call());
        int rateCheckpoint429 = 0;
        int windowCheckpoint429 = 0;
        int windowTag1Checkpoint429 = 0;
        int windowTag2Checkpoint429 = 0;
        Thread.sleep(500L);
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            Object metricValue;
            if (metric.metricName().name().equals("request-error-rate") && metric.metricName().group().equals("jersey-metrics") && metric.metricName().tags().getOrDefault("http_status_code", "").equals("429")) {
                Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("rate"));
                metricValue = metric.metricValue();
                Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Error rate metrics should be measurable");
                double errorRateValue = (Double)metricValue;
                ++rateCheckpoint429;
                Assertions.assertTrue((errorRateValue > 0.0 ? 1 : 0) != 0, (String)("Actual: " + errorRateValue));
            }
            if (!metric.metricName().name().equals("request-error-count") || !metric.metricName().group().equals("jersey-metrics") || !metric.metricName().tags().getOrDefault("http_status_code", "").equals("429")) continue;
            Assertions.assertTrue((boolean)metric.measurable().toString().toLowerCase().startsWith("sampledstat"));
            metricValue = metric.metricValue();
            Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Error count metrics should be measurable");
            Map tags = metric.metricName().tags();
            if (tags.containsValue("value1")) {
                this.assertMetric(metric, (totalRequests + 1) / 3);
                ++windowTag1Checkpoint429;
                continue;
            }
            if (tags.containsValue("value2")) {
                this.assertMetric(metric, totalRequests / 3);
                ++windowTag2Checkpoint429;
                continue;
            }
            this.assertMetric(metric, (totalRequests + 2) / 3);
            ++windowCheckpoint429;
        }
        Assertions.assertEquals((int)3, (int)rateCheckpoint429);
        Assertions.assertEquals((int)3, (int)(windowCheckpoint429 + windowTag1Checkpoint429 + windowTag2Checkpoint429));
    }

    @Test
    public void testException5xxMetrics() {
        int totalRequests = 10;
        IntStream.range(0, totalRequests).forEach(i -> this.makeFailedCall());
        int totalCheckpoint = 0;
        int totalCheckpoint5xx = 0;
        int totalCheckpointNon5xx = 0;
        int caughtCheckpoint5xx = 0;
        int caughtCheckpointNon5xx = 0;
        int caughtTag1Checkpoint5xx = 0;
        int caughtTag1CheckpointNon5xx = 0;
        int caughtTag2Checkpoint5xx = 0;
        int caughtTag2CheckpointNon5xx = 0;
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().group().equals("jersey-metrics")) continue;
            Map tags = metric.metricName().tags();
            switch (metric.metricName().name()) {
                case "request-error-count": 
                case "request-error-total": {
                    if (this.is5xxError(tags)) {
                        this.assertMetric(metric, totalRequests);
                        ++totalCheckpoint5xx;
                        break;
                    }
                    if (tags.containsKey("http_status_code")) {
                        this.assertMetric(metric, 0);
                        ++totalCheckpointNon5xx;
                        break;
                    }
                    if (!tags.isEmpty()) break;
                    this.assertMetric(metric, totalRequests);
                    ++totalCheckpoint;
                    break;
                }
                case "caught.request-error-count": 
                case "caught.request-error-total": {
                    if (tags.containsValue("value1")) {
                        if (this.is5xxError(tags)) {
                            this.assertMetric(metric, (totalRequests + 1) / 3);
                            ++caughtTag1Checkpoint5xx;
                            break;
                        }
                        if (!tags.containsKey("http_status_code")) break;
                        this.assertMetric(metric, 0);
                        ++caughtTag1CheckpointNon5xx;
                        break;
                    }
                    if (tags.containsValue("value2")) {
                        if (this.is5xxError(tags)) {
                            this.assertMetric(metric, totalRequests / 3);
                            ++caughtTag2Checkpoint5xx;
                            break;
                        }
                        if (!tags.containsKey("http_status_code")) break;
                        this.assertMetric(metric, 0);
                        ++caughtTag2CheckpointNon5xx;
                        break;
                    }
                    if (this.is5xxError(tags)) {
                        this.assertMetric(metric, (totalRequests + 2) / 3);
                        ++caughtCheckpoint5xx;
                        break;
                    }
                    if (!tags.containsKey("http_status_code")) break;
                    this.assertMetric(metric, 0);
                    ++caughtCheckpointNon5xx;
                }
            }
        }
        int non5xxCount = MetricsResourceMethodApplicationListener.HTTP_STATUS_CODE_TEXT.length - 2;
        Assertions.assertEquals((int)2, (int)totalCheckpoint);
        Assertions.assertEquals((int)2, (int)totalCheckpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2), (int)totalCheckpointNon5xx);
        Assertions.assertEquals((int)2, (int)caughtCheckpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2), (int)caughtCheckpointNon5xx);
        Assertions.assertEquals((int)2, (int)caughtTag1Checkpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2), (int)caughtTag1CheckpointNon5xx);
        Assertions.assertEquals((int)2, (int)caughtTag2Checkpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2), (int)caughtTag2CheckpointNon5xx);
    }

    @DisplayName(value="WithGlobalStatsRequestTagsEnabled")
    @Test
    public void testException5xxMetrics_WithGlobalStatsRequestTagsEnabled() {
        int totalRequests = 10;
        IntStream.range(0, totalRequests).forEach(i -> this.makeFailedCall());
        int totalCheckpoint = 0;
        int totalCheckpoint5xx = 0;
        int totalCheckpointNon5xx = 0;
        int caughtCheckpoint5xx = 0;
        int caughtCheckpointNon5xx = 0;
        int caughtTag1Checkpoint5xx = 0;
        int caughtTag1CheckpointNon5xx = 0;
        int caughtTag2Checkpoint5xx = 0;
        int caughtTag2CheckpointNon5xx = 0;
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().group().equals("jersey-metrics")) continue;
            Map tags = metric.metricName().tags();
            switch (metric.metricName().name()) {
                case "request-error-count": 
                case "request-error-total": {
                    if (this.is5xxError(tags)) {
                        if (tags.containsValue("value1")) {
                            this.assertMetric(metric, (totalRequests + 1) / 3);
                        } else if (tags.containsValue("value2")) {
                            this.assertMetric(metric, totalRequests / 3);
                        } else {
                            this.assertMetric(metric, (totalRequests + 2) / 3);
                        }
                        ++totalCheckpoint5xx;
                        break;
                    }
                    if (tags.containsKey("http_status_code")) {
                        this.assertMetric(metric, 0);
                        ++totalCheckpointNon5xx;
                        break;
                    }
                    if (tags.containsValue("value1")) {
                        this.assertMetric(metric, (totalRequests + 1) / 3);
                    } else if (tags.containsValue("value2")) {
                        this.assertMetric(metric, totalRequests / 3);
                    } else {
                        this.assertMetric(metric, (totalRequests + 2) / 3);
                    }
                    ++totalCheckpoint;
                    break;
                }
                case "caught.request-error-count": 
                case "caught.request-error-total": {
                    if (tags.containsValue("value1")) {
                        if (this.is5xxError(tags)) {
                            this.assertMetric(metric, (totalRequests + 1) / 3);
                            ++caughtTag1Checkpoint5xx;
                            break;
                        }
                        if (!tags.containsKey("http_status_code")) break;
                        this.assertMetric(metric, 0);
                        ++caughtTag1CheckpointNon5xx;
                        break;
                    }
                    if (tags.containsValue("value2")) {
                        if (this.is5xxError(tags)) {
                            this.assertMetric(metric, totalRequests / 3);
                            ++caughtTag2Checkpoint5xx;
                            break;
                        }
                        if (!tags.containsKey("http_status_code")) break;
                        this.assertMetric(metric, 0);
                        ++caughtTag2CheckpointNon5xx;
                        break;
                    }
                    if (this.is5xxError(tags)) {
                        this.assertMetric(metric, (totalRequests + 2) / 3);
                        ++caughtCheckpoint5xx;
                        break;
                    }
                    if (!tags.containsKey("http_status_code")) break;
                    this.assertMetric(metric, 0);
                    ++caughtCheckpointNon5xx;
                }
            }
        }
        int non5xxCount = MetricsResourceMethodApplicationListener.HTTP_STATUS_CODE_TEXT.length - 2;
        int tagVariants = 3;
        Assertions.assertEquals((int)(2 * tagVariants), (int)totalCheckpoint);
        Assertions.assertEquals((int)(2 * tagVariants), (int)totalCheckpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2 * tagVariants), (int)totalCheckpointNon5xx);
        Assertions.assertEquals((int)2, (int)caughtCheckpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2), (int)caughtCheckpointNon5xx);
        Assertions.assertEquals((int)2, (int)caughtTag1Checkpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2), (int)caughtTag1CheckpointNon5xx);
        Assertions.assertEquals((int)2, (int)caughtTag2Checkpoint5xx);
        Assertions.assertEquals((int)((non5xxCount + 1) * 2), (int)caughtTag2CheckpointNon5xx);
    }

    @Test
    public void testMetricReporterConfiguration() {
        Properties props = new Properties();
        props.put("metric.reporters.prop1", "val1");
        props.put("metric.reporters.prop2", "val2");
        props.put("metric.reporters.prop3", "override");
        props.put("prop3", "original");
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        props.put("not.prefixed.config", "val3");
        ApplicationWithFilter app = new ApplicationWithFilter(TestRestConfig.maprCompatible(props));
        TestMetricsReporter reporter = (TestMetricsReporter)app.getMetrics().reporters().get(0);
        Assertions.assertTrue((boolean)reporter.getConfigs().containsKey("not.prefixed.config"));
        Assertions.assertTrue((boolean)reporter.getConfigs().containsKey("prop1"));
        Assertions.assertTrue((boolean)reporter.getConfigs().containsKey("prop2"));
        Assertions.assertEquals(reporter.getConfigs().get("prop3"), (Object)"override");
    }

    @Test
    public void testMetricLatencySloSlaEnabled() {
        this.makeSuccessfulCall();
        Map<String, String> allMetrics = TestMetricsReporter.getMetricTimeseries().stream().collect(Collectors.toMap(x -> x.metricName().name(), x -> x.metricValue().toString(), (a, b) -> a));
        Assertions.assertTrue((boolean)allMetrics.containsKey("response-below-latency-slo-total"));
        Assertions.assertTrue((boolean)allMetrics.containsKey("response-above-latency-slo-total"));
        Assertions.assertTrue((boolean)allMetrics.containsKey("response-below-latency-sla-total"));
        Assertions.assertTrue((boolean)allMetrics.containsKey("response-above-latency-sla-total"));
        Assertions.assertEquals((int)1, (int)(Double.valueOf(allMetrics.get("response-below-latency-slo-total")).intValue() + Double.valueOf(allMetrics.get("response-above-latency-slo-total")).intValue()));
        Assertions.assertEquals((int)1, (int)(Double.valueOf(allMetrics.get("response-below-latency-sla-total")).intValue() + Double.valueOf(allMetrics.get("response-above-latency-sla-total")).intValue()));
        Assertions.assertEquals((int)0, (int)Double.valueOf(allMetrics.get("response-below-latency-slo-total")).intValue());
        Assertions.assertEquals((int)1, (int)Double.valueOf(allMetrics.get("response-above-latency-slo-total")).intValue());
        Assertions.assertEquals((int)1, (int)Double.valueOf(allMetrics.get("response-below-latency-sla-total")).intValue());
        Assertions.assertEquals((int)0, (int)Double.valueOf(allMetrics.get("response-above-latency-sla-total")).intValue());
    }

    @Test
    public void testGlobalLatencyMetricsForErrorsBeforeResourceMatching() {
        long start = System.currentTimeMillis();
        this.makeFilterErrorCall();
        long elapsed = System.currentTimeMillis() - start + 100L;
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().group().equals("jersey-metrics")) continue;
            switch (metric.metricName().name()) {
                case "request-latency-avg": 
                case "request-latency-max": 
                case "request-latency-95": 
                case "request-latency-99": {
                    Assertions.assertTrue((Double.valueOf(metric.metricValue().toString()) < (double)elapsed ? 1 : 0) != 0);
                }
            }
        }
    }

    private void makeSuccessfulCall() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/public/hello").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
    }

    private void make429Call() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/public/fourTwoNine").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assertions.assertEquals((int)429, (int)response.getStatus());
    }

    private void makeFailedCall() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/public/caught").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assertions.assertEquals((int)500, (int)response.getStatus());
    }

    private void makeFilterErrorCall() {
        Response response = ClientBuilder.newClient((Configuration)this.app.resourceConfig.getConfiguration()).target(this.server.getURI()).path("/public/filterError").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        Assertions.assertEquals((int)500, (int)response.getStatus());
    }

    private boolean is5xxError(Map<String, String> tags) {
        return tags.getOrDefault("http_status_code", "").equals("5xx");
    }

    private void assertMetric(KafkaMetric metric, int expectedValue) {
        Object metricValue = metric.metricValue();
        Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Metrics should be measurable");
        double countValue = (Double)metricValue;
        Assertions.assertEquals((double)expectedValue, (double)countValue, (String)("Actual: " + countValue));
    }

    private static class StatusCodeException
    extends RuntimeException {
        private final Response.Status status;
        private final int code;

        StatusCodeException(Response.Status status, Throwable cause) {
            super(cause);
            this.status = Objects.requireNonNull(status);
            this.code = status.getStatusCode();
        }

        public Response.Status getStatus() {
            return this.status;
        }

        public int getCode() {
            return this.code;
        }
    }

    private final class MyExceptionMapper
    extends KafkaExceptionMapper {
        public MyExceptionMapper(RestConfig restConfig) {
            super(restConfig);
        }

        public Response toResponse(Throwable exception) {
            if (exception instanceof StatusCodeException) {
                return Response.status((Response.Status)Response.Status.TOO_MANY_REQUESTS).entity((Object)new ErrorMessage(429, exception.getMessage())).build();
            }
            return super.toResponse(exception);
        }
    }

    @PreMatching
    private class PreMatchingErrorFilter
    implements ContainerRequestFilter {
        private PreMatchingErrorFilter() {
        }

        public void filter(ContainerRequestContext context) {
            String path = context.getUriInfo().getPath();
            if (path.equals("public/filterError")) {
                throw new RuntimeException("Error before resource matching");
            }
        }
    }

    private class Filter
    implements ContainerRequestFilter {
        private final String[] tags = new String[]{"", "value1", "value2"};

        private Filter() {
        }

        public void filter(ContainerRequestContext context) {
            HashMap<String, String> maps = new HashMap<String, String>();
            String value = this.tags[MetricsResourceMethodApplicationListenerIntegrationTest.this.counter.getAndIncrement() % this.tags.length];
            if (value != null && value.length() > 0) {
                maps.put("tag", value);
            }
            context.setProperty("_request_tags", maps);
        }
    }

    @Produces(value={"application/json"})
    @Path(value="/public/")
    public static class PublicResource {
        @GET
        @Path(value="/caught")
        @PerformanceMetric(value="caught")
        public Void caught() {
            throw new RuntimeException("cyrus");
        }

        @GET
        @Path(value="/hello")
        @PerformanceMetric(value="hello")
        public String hello() {
            return "hello";
        }

        @GET
        @Path(value="/fourTwoNine")
        @PerformanceMetric(value="fourTwoNine")
        public String fourTwoNine() {
            throw new StatusCodeException(Response.Status.TOO_MANY_REQUESTS, (Throwable)new RuntimeException("kaboom"));
        }

        @GET
        @Path(value="/filterError")
        @PerformanceMetric(value="filterError")
        public String filterError() {
            return "should never get here";
        }
    }

    @Produces(value={"application/json"})
    @Path(value="/private")
    private static class PrivateResource {
        private PrivateResource() {
        }

        @GET
        @Path(value="/endpoint")
        public Void notAccessible() {
            return null;
        }
    }

    private class ApplicationWithFilter
    extends Application<TestRestConfig> {
        Configurable resourceConfig;

        ApplicationWithFilter(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(PrivateResource.class);
            config.register((Object)new PublicResource());
            config.register((Object)new Filter());
            config.register((Object)new PreMatchingErrorFilter());
            config.register((Object)new MyExceptionMapper(appConfig));
            config.property("jersey.config.server.response.setStatusOverSendError", (Object)true);
        }

        protected void registerExceptionMappers(Configurable<?> config, TestRestConfig restConfig) {
            config.register(JsonParseExceptionMapper.class);
            config.register(JsonMappingExceptionMapper.class);
            config.register(ConstraintViolationExceptionMapper.class);
            config.register((Object)new WebApplicationExceptionMapper((RestConfig)restConfig));
            config.register((Object)new MyExceptionMapper(restConfig));
        }

        protected void configurePostResourceHandling(ServletContextHandler context) {
            context.setErrorHandler(new ErrorHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    MetricsResourceMethodApplicationListenerIntegrationTest.this.handledException = (Throwable)request.getAttribute("javax.servlet.error.exception");
                    super.handle(target, baseRequest, request, response);
                }
            });
        }
    }
}

