/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.metrics.Jetty429MetricsDosFilterListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.eclipse.jetty.servlets.DoSFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class Jetty429MetricsDosFilterListenerTest {
    private static final String TEST_JMX_PREFIX = "test-kafka-rest";
    private final Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
    private final Sensor fourTwoNineSensor = (Sensor)Mockito.mock(Sensor.class);
    private final DoSFilter mockDoSFiler = (DoSFilter)Mockito.mock(DoSFilter.class);
    private Jetty429MetricsDosFilterListener jetty429MetricsDosFilterListener;
    private final Map<String, String> allTags = new HashMap<String, String>(){
        {
            this.put("http_status_code", "429");
        }
    };

    Jetty429MetricsDosFilterListenerTest() {
    }

    @ParameterizedTest
    @ValueSource(longs={-1L, 0L, 1L})
    public void test_onRequestOverLimit_nullMetrics(long delayMs) {
        Mockito.when((Object)this.mockDoSFiler.getDelayMs()).thenReturn((Object)delayMs);
        this.jetty429MetricsDosFilterListener = new Jetty429MetricsDosFilterListener(null, (Map)ImmutableMap.of(), TEST_JMX_PREFIX);
        DoSFilter.Action action = this.jetty429MetricsDosFilterListener.onRequestOverLimit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), (DoSFilter.OverLimit)Mockito.mock(DoSFilter.OverLimit.class), this.mockDoSFiler);
        ((Sensor)Mockito.verify((Object)this.fourTwoNineSensor, (VerificationMode)Mockito.never())).add((MetricName)ArgumentMatchers.any(MetricName.class), (MeasurableStat)ArgumentMatchers.any());
        Assertions.assertEquals((Object)DoSFilter.Action.fromDelay((long)delayMs), (Object)action);
        ((Sensor)Mockito.verify((Object)this.fourTwoNineSensor, (VerificationMode)Mockito.never())).record();
    }

    @ParameterizedTest
    @ValueSource(longs={0L, 1L})
    public void test_onRequestOverLimit_metricsNotNull_requestNotRejected(long delayMs) {
        this.setMockedMetricsObjectResponses(this.allTags);
        Mockito.when((Object)this.mockDoSFiler.getDelayMs()).thenReturn((Object)delayMs);
        this.jetty429MetricsDosFilterListener = new Jetty429MetricsDosFilterListener(this.metrics, this.allTags, TEST_JMX_PREFIX);
        DoSFilter.Action action = this.jetty429MetricsDosFilterListener.onRequestOverLimit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), (DoSFilter.OverLimit)Mockito.mock(DoSFilter.OverLimit.class), this.mockDoSFiler);
        Assertions.assertNotEquals((Object)DoSFilter.Action.REJECT, (Object)action);
        Assertions.assertEquals((Object)DoSFilter.Action.fromDelay((long)delayMs), (Object)action);
        this.verifyFourTwoNineSensor(this.fourTwoNineSensor, this.allTags, 0);
    }

    @Test
    public void test_onRequestOverLimit_metricsNotNull_requestRejected() {
        this.setMockedMetricsObjectResponses(this.allTags);
        Mockito.when((Object)this.mockDoSFiler.getDelayMs()).thenReturn((Object)-1L);
        this.jetty429MetricsDosFilterListener = new Jetty429MetricsDosFilterListener(this.metrics, (Map)ImmutableMap.of(), TEST_JMX_PREFIX);
        DoSFilter.Action action = this.jetty429MetricsDosFilterListener.onRequestOverLimit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), (DoSFilter.OverLimit)Mockito.mock(DoSFilter.OverLimit.class), this.mockDoSFiler);
        ((Sensor)Mockito.verify((Object)this.fourTwoNineSensor, (VerificationMode)Mockito.times((int)3))).add((MetricName)ArgumentMatchers.any(MetricName.class), (MeasurableStat)ArgumentMatchers.any(MeasurableStat.class));
        Assertions.assertEquals((Object)DoSFilter.Action.REJECT, (Object)action);
        this.verifyFourTwoNineSensor(this.fourTwoNineSensor, this.allTags, 1);
    }

    private void setMockedMetricsObjectResponses(Map<String, String> allTags) {
        MetricName rateName = new MetricName("request-error-rate", "jetty-metrics", "The average number of requests per second that resulted in 429 HTTP error responses in Jetty layer", allTags);
        Mockito.when((Object)this.metrics.metricInstance(new MetricNameTemplate("request-error-rate", "jetty-metrics", "The average number of requests per second that resulted in 429 HTTP error responses in Jetty layer", allTags.keySet()), allTags)).thenReturn((Object)rateName);
        MetricName countName = new MetricName("request-error-count", "jetty-metrics", "A windowed count of requests that resulted in 429 HTTP error responses in Jetty layer", allTags);
        Mockito.when((Object)this.metrics.metricInstance(new MetricNameTemplate("request-error-count", "jetty-metrics", "A windowed count of requests that resulted in 429 HTTP error responses in Jetty layer", allTags.keySet()), allTags)).thenReturn((Object)countName);
        MetricName cumulativeCountName = new MetricName("request-error-total", "jetty-metrics", "A cumulative count of requests that resulted in 429 HTTP error responses in Jetty layer", allTags);
        Mockito.when((Object)this.metrics.metricInstance(new MetricNameTemplate("request-error-total", "jetty-metrics", "A cumulative count of requests that resulted in 429 HTTP error responses in Jetty layer", allTags.keySet()), allTags)).thenReturn((Object)cumulativeCountName);
        Mockito.when((Object)this.metrics.sensor(ArgumentMatchers.anyString(), (MetricConfig)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (Sensor.RecordingLevel)ArgumentMatchers.any(Sensor.RecordingLevel.class), (Sensor[])ArgumentMatchers.any())).thenReturn((Object)this.fourTwoNineSensor);
    }

    private void verifyFourTwoNineSensor(Sensor fourTwoNineSensor, Map<String, String> allTags, int timesRecorded) {
        MetricName rateName = new MetricName("request-error-rate", "jetty-metrics", "The average number of requests per second that resulted in 429 HTTP error responses in Jetty layer", allTags);
        MetricName countName = new MetricName("request-error-count", "jetty-metrics", "A windowed count of requests that resulted in 429 HTTP error responses in Jetty layer", allTags);
        MetricName cumulativeCountName = new MetricName("request-error-total", "jetty-metrics", "A cumulative count of requests that resulted in 429 HTTP error responses in Jetty layer", allTags);
        ((Sensor)Mockito.verify((Object)fourTwoNineSensor)).add((MetricName)ArgumentMatchers.eq((Object)rateName), (MeasurableStat)ArgumentMatchers.any(Rate.class));
        ((Sensor)Mockito.verify((Object)fourTwoNineSensor)).add((MetricName)ArgumentMatchers.eq((Object)countName), (MeasurableStat)ArgumentMatchers.any(SampledStat.class));
        ((Sensor)Mockito.verify((Object)fourTwoNineSensor)).add((MetricName)ArgumentMatchers.eq((Object)cumulativeCountName), (MeasurableStat)ArgumentMatchers.any(CumulativeSum.class));
        ((Sensor)Mockito.verify((Object)fourTwoNineSensor, (VerificationMode)Mockito.times((int)timesRecorded))).record();
    }
}

