/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.mapr.test;

import io.confluent.rest.exceptions.RestException;
import io.confluent.rest.mapr.test.ThrowingAction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;

public class TestUtils {
    public static void assertThatThrown(ThrowingAction action, Matcher<Throwable> matcher) {
        try {
            action.run();
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw (AssertionError)((Object)e);
            }
            Assert.assertThat((Object)e, (Matcher)JUnitMatchers.isThrowable(matcher));
            return;
        }
        TestUtils.failAsMatcher(matcher);
    }

    private static void failAsMatcher(Matcher<Throwable> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        Assert.fail((String)("Expected thrown exception: " + description.toString()));
    }

    public static void assertThatThrownException(ThrowingAction action, Matcher<Exception> matcher) {
        TestUtils.assertThatThrown(action, TestUtils.typedAs(Exception.class, matcher));
    }

    public static void assertThatThrownRestException(ThrowingAction action, Matcher<RestException> matcher) {
        TestUtils.assertThatThrown(action, TestUtils.typedAs(RestException.class, matcher));
    }

    private static <S, T> Matcher<T> typedAs(Class<S> type, Matcher<S> matcher) {
        return CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(type), matcher);
    }

    public static Matcher<RestException> hasSameRestAttributesAs(RestException expected) {
        return CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(expected.getClass()), TestUtils.hasErrorCode((Matcher<Integer>)CoreMatchers.equalTo((Object)expected.getErrorCode())), TestUtils.hasStatus((Matcher<Integer>)CoreMatchers.equalTo((Object)expected.getStatus())));
    }

    public static Matcher<RestException> hasErrorCode(Matcher<Integer> matcher) {
        return new FeatureMatcher<RestException, Integer>(matcher, "rest exception with error code", "error code"){

            protected Integer featureValueOf(RestException from) {
                return from.getErrorCode();
            }
        };
    }

    public static Matcher<RestException> hasStatus(Matcher<Integer> matcher) {
        return new FeatureMatcher<RestException, Integer>(matcher, "rest exception with status", "status"){

            protected Integer featureValueOf(RestException from) {
                return from.getStatus();
            }
        };
    }
}

