/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.mapr.test;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.hadoop.security.User;

public class MaprTestLoginModule
implements LoginModule {
    private static final String SHARED_USERNAME = "javax.security.auth.login.name";
    private static final String SHARED_PASSWORD = "javax.security.auth.login.password";
    private static final String INITIAL_USER = System.getProperty("user.name");
    private static Multimap<String, Restriction> restrictions = Multimaps.newListMultimap(new ConcurrentHashMap(), CopyOnWriteArrayList::new);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, String> sharedState;
    private String name;
    private String password;
    private User principal;

    public static void restrict(String user, Restriction restriction) {
        restrictions.put((Object)user, (Object)restriction);
    }

    public static void reset() {
        restrictions.clear();
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
    }

    @Override
    public boolean login() throws LoginException {
        this.requestCredentials();
        this.sharedState.put(SHARED_USERNAME, this.name);
        this.sharedState.put(SHARED_PASSWORD, this.password);
        for (Restriction restriction : restrictions.get((Object)this.name)) {
            if (restriction.login(this.password)) continue;
            return false;
        }
        return true;
    }

    private void requestCredentials() throws LoginException {
        if (this.callbackHandler == null) {
            this.name = INITIAL_USER;
            this.password = null;
            return;
        }
        NameCallback nameCallback = new NameCallback("name:", INITIAL_USER);
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
            this.name = nameCallback.getName();
            this.password = Optional.ofNullable(passwordCallback.getPassword()).map(String::new).orElse(null);
        }
        catch (IOException | UnsupportedCallbackException e) {
            LoginException le = new LoginException("Exception occurred while handling callbacks");
            le.initCause(e);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        this.principal = new User(this.name);
        this.subject.getPrincipals().add((Principal)this.principal);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        return true;
    }

    public static interface Restriction {
        public boolean login(String var1) throws LoginException;
    }
}

