/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.RestConfig;
import io.confluent.rest.metrics.RestMetricsContext;
import io.confluent.rest.metrics.TestRestMetricsContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class TestRestConfig
extends RestConfig {
    private static final ConfigDef config = TestRestConfig.baseConfigDef();

    public TestRestConfig() {
        this(Collections.emptyMap());
    }

    private TestRestConfig(Map<?, ?> originals) {
        super(config, TestRestConfig.createConfigs(originals));
    }

    private static Map<Object, Object> createConfigs(Map<?, ?> originals) {
        HashMap<Object, Object> configs = new HashMap<Object, Object>();
        configs.put("listeners", "http://localhost:0");
        configs.putAll(originals);
        return configs;
    }

    public RestMetricsContext getMetricsContext() {
        return new TestRestMetricsContext(this.getString("metrics.jmx.prefix"), this.originalsWithPrefix("metrics.context.")).metricsContext();
    }

    private static Map<?, ?> compatibleOriginals(Map<?, ?> originals) {
        HashMap newOriginals = new HashMap(originals);
        newOriginals.putIfAbsent("ssl.keystore.location", "none");
        newOriginals.putIfAbsent("ssl.keystore.password", "none");
        newOriginals.putIfAbsent("ssl.key.password", "none");
        newOriginals.putIfAbsent("ssl.keystore.type", "JKS");
        newOriginals.putIfAbsent("ssl.truststore.type", "JKS");
        return newOriginals;
    }

    public static TestRestConfig maprCompatible(Map<?, ?> originals) {
        return new TestRestConfig(TestRestConfig.compatibleOriginals(originals));
    }

    public static TestRestConfig clean(Map<?, ?> originals) {
        return new TestRestConfig(originals);
    }
}

