/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestMetricsReporter;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.mapr.test.MaprHomeSupport;
import io.confluent.rest.mapr.test.MaprTestLoginRule;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Context;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.test.TestSslUtils;
import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslTest {
    private static final Logger log;
    private File trustStore;
    private File clientKeystore;
    private File serverKeystore;
    private File serverKeystoreBak;
    private File serverKeystoreErr;
    public static final String SSL_PASSWORD = "test1234";
    public static final String EXPECTED_200_MSG = "Response status must be 200.";
    public static final String EXPECTED_500_MSG = "Response status must be 500.";
    public static final int CERT_RELOAD_WAIT_TIME = 20000;
    @Rule
    public final MaprTestLoginRule loginRule = MaprTestLoginRule.forHadoopSimpleAndJpam();

    @BeforeEach
    public void setUp() throws Exception {
        try {
            this.trustStore = File.createTempFile("SslTest-truststore", ".jks");
            this.clientKeystore = File.createTempFile("SslTest-client-keystore", ".jks");
            this.serverKeystore = File.createTempFile("SslTest-server-keystore", ".jks");
            this.serverKeystoreBak = File.createTempFile("SslTest-server-keystore", ".jks.bak");
            this.serverKeystoreErr = File.createTempFile("SslTest-server-keystore", ".jks.err");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create temporary files for trust stores and keystores.");
        }
        HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
        this.createKeystoreWithCert(this.clientKeystore, "client", certs);
        this.createKeystoreWithCert(this.serverKeystore, "server", certs);
        TestSslUtils.createTrustStore((String)this.trustStore.getAbsolutePath(), (Password)new Password(SSL_PASSWORD), certs);
        Files.copy(this.serverKeystore.toPath(), this.serverKeystoreBak.toPath(), StandardCopyOption.REPLACE_EXISTING);
        certs = new HashMap();
        this.createWrongKeystoreWithCert(this.serverKeystoreErr, "server", certs);
    }

    private void createKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{"localhost"}).generate("CN=mymachine.local, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    private void configServerKeystore(Properties props) {
        props.put("ssl.keystore.location", this.serverKeystore.getAbsolutePath());
        props.put("ssl.keystore.password", SSL_PASSWORD);
        props.put("ssl.key.password", SSL_PASSWORD);
    }

    private void configServerTruststore(Properties props) {
        props.put("ssl.truststore.location", this.trustStore.getAbsolutePath());
        props.put("ssl.truststore.password", SSL_PASSWORD);
    }

    private void enableSslClientAuth(Properties props) {
        props.put("ssl.client.authentication", "REQUIRED");
    }

    private void createWrongKeystoreWithCert(File file, String alias, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{"fail"}).generate("CN=mymachine.local, O=A client", keypair);
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(SSL_PASSWORD), (Password)new Password(SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpAndHttps() throws Exception {
        TestMetricsReporter.reset();
        Properties props = new Properties();
        String httpUri = "http://localhost:8080";
        String httpsUri = "https://localhost:8081";
        props.put("listeners", httpUri + "," + httpsUri);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        this.configServerKeystore(props);
        TestRestConfig config = TestRestConfig.clean(props);
        SslTestApplication app = new SslTestApplication(config);
        try {
            app.start();
            int statusCode = this.makeGetRequest(httpUri + "/test");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequest(httpsUri + "/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            this.assertMetricsCollected();
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerSideHttpAndHttpsResolution() throws Exception {
        TestMetricsReporter.reset();
        Properties props = new Properties();
        String httpUri = "http://localhost:8080";
        String httpsUri = "https://localhost:8081";
        props.put("listeners", httpUri + "," + httpsUri);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        this.configServerKeystore(props);
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        SslTestApplication app = new SslTestApplication(config);
        try {
            app.start();
            int statusCode = this.makeGetRequest(httpUri + "/test/http-only");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequest(httpUri + "/test/https-only");
            Assertions.assertEquals((int)500, (int)statusCode, (String)EXPECTED_500_MSG);
            statusCode = this.makeGetRequest(httpsUri + "/test/https-only", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            statusCode = this.makeGetRequest(httpsUri + "/test/http-only", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)500, (int)statusCode, (String)EXPECTED_500_MSG);
            this.assertMetricsCollected();
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsOnly() throws Exception {
        TestMetricsReporter.reset();
        Properties props = new Properties();
        String uri = "https://localhost:8080";
        props.put("listeners", uri);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        this.configServerKeystore(props);
        TestRestConfig config = TestRestConfig.clean(props);
        SslTestApplication app = new SslTestApplication(config);
        try {
            app.start();
            int statusCode = this.makeGetRequest(uri + "/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            this.assertMetricsCollected();
            Assertions.assertThrows(ClientProtocolException.class, () -> this.makeGetRequest("http://localhost:8080/test"));
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpOnly() throws Exception {
        TestMetricsReporter.reset();
        Properties props = new Properties();
        String uri = "http://localhost:8080";
        props.put("listeners", uri);
        props.put("metric.reporters", "io.confluent.rest.TestMetricsReporter");
        TestRestConfig config = TestRestConfig.clean(props);
        SslTestApplication app = new SslTestApplication(config);
        try {
            app.start();
            int statusCode = this.makeGetRequest(uri + "/test");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
            this.assertMetricsCollected();
            Assertions.assertThrows(SSLException.class, () -> this.makeGetRequest("https://localhost:8080/test", this.clientKeystore.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD));
        }
        finally {
            app.stop();
        }
    }

    private void assertMetricsCollected() {
        Assertions.assertNotEquals((int)0, (int)TestMetricsReporter.getMetricTimeseries().size(), (String)"Expected to have metrics.");
        for (KafkaMetric metric : TestMetricsReporter.getMetricTimeseries()) {
            if (!metric.metricName().name().equals("request-latency-max")) continue;
            Object metricValue = metric.metricValue();
            Assertions.assertTrue((boolean)(metricValue instanceof Double), (String)"Request latency metrics should be measurable");
            double latencyMaxValue = (Double)metricValue;
            Assertions.assertNotEquals((double)0.0, (double)latencyMaxValue, (String)"Metrics should be collected (max latency shouldn't be 0)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpsWithNoClientCertAndNoServerTruststore() throws Exception {
        Properties props = new Properties();
        String uri = "https://localhost:8080";
        props.put("listeners", uri);
        this.configServerKeystore(props);
        TestRestConfig config = TestRestConfig.clean(props);
        SslTestApplication app = new SslTestApplication(config);
        try {
            app.start();
            int statusCode = this.makeGetRequest(uri + "/test");
            Assertions.assertEquals((int)200, (int)statusCode, (String)EXPECTED_200_MSG);
        }
        finally {
            app.stop();
        }
    }

    @Test
    public void testHttpsWithAuthAndBadClientCert() throws Exception {
        Properties props = new Properties();
        String uri = "https://localhost:8080";
        props.put("listeners", uri);
        this.configServerKeystore(props);
        this.configServerTruststore(props);
        this.enableSslClientAuth(props);
        TestRestConfig config = TestRestConfig.clean(props);
        SslTestApplication app = new SslTestApplication(config);
        Assertions.assertThrows(SocketException.class, () -> {
            try {
                app.start();
                File untrustedClient = File.createTempFile("SslTest-client-keystore", ".jks");
                HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
                this.createKeystoreWithCert(untrustedClient, "client", certs);
                try {
                    this.makeGetRequest(uri + "/test", untrustedClient.getAbsolutePath(), SSL_PASSWORD, SSL_PASSWORD);
                }
                catch (SSLException she) {
                    throw new SocketException(she.getMessage());
                }
            }
            finally {
                app.stop();
            }
        });
    }

    @Test
    public void testHttpsWithAuthAndNoClientCert() throws Exception {
        Properties props = new Properties();
        String uri = "https://localhost:8080";
        props.put("listeners", uri);
        this.configServerKeystore(props);
        this.configServerTruststore(props);
        this.enableSslClientAuth(props);
        TestRestConfig config = TestRestConfig.clean(props);
        SslTestApplication app = new SslTestApplication(config);
        Assertions.assertThrows(SocketException.class, () -> {
            try {
                app.start();
                try {
                    this.makeGetRequest(uri + "/test");
                }
                catch (SSLException e) {
                    throw new SocketException(e.toString());
                }
            }
            finally {
                app.stop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeGetRequest(String url, String clientKeystoreLocation, String clientKeystorePassword, String clientKeyPassword) throws Exception {
        CloseableHttpClient httpclient;
        log.debug("Making GET " + url);
        HttpGet httpget = new HttpGet(url);
        if (url.startsWith("http://")) {
            httpclient = HttpClients.createDefault();
        } else {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            if (clientKeystoreLocation != null) {
                sslContextBuilder.loadKeyMaterial(new File(clientKeystoreLocation), clientKeystorePassword.toCharArray(), clientKeyPassword.toCharArray());
            }
            SSLContext sslContext = sslContextBuilder.build();
            SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
        }
        int statusCode = -1;
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpget);
            statusCode = response.getStatusLine().getStatusCode();
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
        return statusCode;
    }

    private int makeGetRequest(String url) throws Exception {
        return this.makeGetRequest(url, null, null, null);
    }

    static {
        MaprHomeSupport.activate();
        log = LoggerFactory.getLogger(SslTest.class);
    }

    @Path(value="/test")
    @Produces(value={"application/test.v1+json"})
    public static class SslTestResource {
        @Context
        HttpServletRequest request;

        @GET
        @PerformanceMetric(value="test")
        public TestResponse hello() {
            return new TestResponse();
        }

        @Path(value="/http-only")
        @GET
        @PerformanceMetric(value="http-only")
        public TestResponse httpOnly() {
            if (!Objects.equals(this.request.getScheme(), "http")) {
                throw new InternalServerErrorException("Got request on HTTP-only endpoint via non-http protocol");
            }
            return new TestResponse();
        }

        @Path(value="/https-only")
        @GET
        @PerformanceMetric(value="https-only")
        public TestResponse httpsOnly() {
            if (!Objects.equals(this.request.getScheme(), "https")) {
                throw new InternalServerErrorException("Got request on HTTPS-only endpoint via non-https protocol");
            }
            return new TestResponse();
        }

        public static class TestResponse {
            @JsonProperty
            public String getMessage() {
                return "foo";
            }
        }
    }

    private static class SslTestApplication
    extends Application<TestRestConfig> {
        public SslTestApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register((Object)new SslTestResource());
        }

        public Map<String, String> getMetricsTags() {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("instance-id", "1");
            return tags;
        }
    }
}

