/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.TestUtils;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Configurable;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.test.TestSslUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="IntegrationTest")
public class SniHandlerIntegrationTest {
    public static final String TEST_SSL_PASSWORD = "test1234";
    public static final String KAFKA_REST_HOST = "localhost";
    public static final String KSQL_HOST = "anotherhost";
    private Server server;
    private HttpClient httpClient;
    private Properties props;
    private File clientKeystore;

    @BeforeEach
    public void setup(TestInfo info) throws Exception {
        this.props = new Properties();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.httpClient.stop();
        this.server.stop();
        this.server.join();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void test_http_SniHandlerEnabled_no_effect(boolean http2Enabled) throws Exception {
        this.props.setProperty("http2.enabled", String.valueOf(http2Enabled));
        this.props.setProperty("sni.check.enabled", "true");
        this.startHttpServer("http");
        this.startHttpClient("http");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/resource").accept(new String[]{"text/html"}).header(HttpHeader.HOST, "host.value.does.not.matter").send();
        Assertions.assertEquals((int)HttpStatus.Code.OK.getCode(), (int)response.getStatus());
    }

    @ParameterizedTest
    @MethodSource(value={"provideParameters"})
    public void test_https_SniHandlerDisabled_wrong_host_pass(boolean mTLSEnabled, boolean http2Enabled) throws Exception {
        this.props.setProperty("sni.check.enabled", "false");
        if (mTLSEnabled) {
            this.props.setProperty("ssl.client.authentication", "REQUIRED");
        }
        this.props.setProperty("http2.enabled", String.valueOf(http2Enabled));
        this.startHttpServer("https");
        this.startHttpClient("https");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/resource").accept(new String[]{"text/plain"}).header(HttpHeader.HOST, KSQL_HOST).send();
        Assertions.assertEquals((int)HttpStatus.Code.OK.getCode(), (int)response.getStatus());
    }

    @ParameterizedTest
    @MethodSource(value={"provideParameters"})
    public void test_https_SniHandlerEnabled_wrong_host_421(boolean mTLSEnabled, boolean http2Enabled) throws Exception {
        this.props.setProperty("sni.check.enabled", "true");
        if (mTLSEnabled) {
            this.props.setProperty("ssl.client.authentication", "REQUIRED");
        }
        this.props.setProperty("http2.enabled", String.valueOf(http2Enabled));
        this.startHttpServer("https");
        this.startHttpClient("https");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/resource").accept(new String[]{"text/plain"}).header(HttpHeader.HOST, KSQL_HOST).send();
        Assertions.assertEquals((int)HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), (int)response.getStatus());
        String responseContent = response.getContentAsString();
        MatcherAssert.assertThat((Object)responseContent, (Matcher)CoreMatchers.containsString((String)HttpStatus.Code.MISDIRECTED_REQUEST.getMessage()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideParameters"})
    public void test_https_SniHandlerEnabled_same_host_pass(boolean mTLSEnabled, boolean http2Enabled) throws Exception {
        this.props.setProperty("sni.check.enabled", "true");
        if (mTLSEnabled) {
            this.props.setProperty("ssl.client.authentication", "REQUIRED");
        }
        this.props.setProperty("http2.enabled", String.valueOf(http2Enabled));
        this.startHttpServer("https");
        this.startHttpClient("https");
        ContentResponse response = this.httpClient.newRequest(this.server.getURI()).path("/resource").accept(new String[]{"text/plain"}).send();
        Assertions.assertEquals((int)HttpStatus.Code.OK.getCode(), (int)response.getStatus());
        response = this.httpClient.newRequest(this.server.getURI()).path("/resource").accept(new String[]{"text/plain"}).header(HttpHeader.HOST, KAFKA_REST_HOST).send();
        Assertions.assertEquals((int)HttpStatus.Code.OK.getCode(), (int)response.getStatus());
    }

    private static Stream<Arguments> provideParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, false}), Arguments.of((Object[])new Object[]{false, true}), Arguments.of((Object[])new Object[]{true, false}), Arguments.of((Object[])new Object[]{true, true}));
    }

    private void startHttpClient(String scheme) throws Exception {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        if (scheme.equals("https")) {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            sslContextBuilder.loadKeyMaterial(new File(this.clientKeystore.getAbsolutePath()), TEST_SSL_PASSWORD.toCharArray(), TEST_SSL_PASSWORD.toCharArray());
            SSLContext sslContext = sslContextBuilder.build();
            SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setSNIProvider(SslContextFactory.Client.SniProvider.NON_DOMAIN_SNI_PROVIDER);
            sslContextFactory.setSslContext(sslContext);
            this.httpClient = new HttpClient((SslContextFactory)sslContextFactory);
        } else {
            this.httpClient = new HttpClient();
        }
        this.httpClient.start();
    }

    private void startHttpServer(String scheme) throws Exception {
        String url = scheme + "://" + KAFKA_REST_HOST + ":" + TestUtils.getFreePort();
        this.props.setProperty("listeners", url);
        if (scheme.equals("https")) {
            File serverKeystore;
            File trustStore;
            try {
                trustStore = File.createTempFile("SslTest-truststore", ".jks");
                serverKeystore = File.createTempFile("SslTest-server-keystore", ".jks");
                this.clientKeystore = File.createTempFile("SslTest-client-keystore", ".jks");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create temporary files for truststores and keystores.");
            }
            HashMap<String, X509Certificate> certs = new HashMap<String, X509Certificate>();
            this.createKeystoreWithCert(this.clientKeystore, ServiceType.CLIENT, certs);
            this.createKeystoreWithCert(serverKeystore, ServiceType.SERVER, certs);
            TestSslUtils.createTrustStore((String)trustStore.getAbsolutePath(), (Password)new Password(TEST_SSL_PASSWORD), certs);
            this.configServerKeystore(this.props, serverKeystore);
            this.configServerTruststore(this.props, trustStore);
        }
        TestApp application = new TestApp(TestRestConfig.maprCompatible(this.props), "/");
        this.server = application.createServer();
        this.server.start();
    }

    private void configServerKeystore(Properties props, File serverKeystore) {
        props.put("ssl.keystore.location", serverKeystore.getAbsolutePath());
        props.put("ssl.keystore.password", TEST_SSL_PASSWORD);
        props.put("ssl.key.password", TEST_SSL_PASSWORD);
    }

    private void configServerTruststore(Properties props, File trustStore) {
        props.put("ssl.truststore.location", trustStore.getAbsolutePath());
        props.put("ssl.truststore.password", TEST_SSL_PASSWORD);
    }

    private void createKeystoreWithCert(File file, ServiceType type, Map<String, X509Certificate> certs) throws Exception {
        KeyPair keypair = TestSslUtils.generateKeyPair((String)"RSA");
        TestSslUtils.CertificateBuilder certificateBuilder = new TestSslUtils.CertificateBuilder(30, "SHA1withRSA");
        X509Certificate cCert = certificateBuilder.sanDnsNames(new String[]{KAFKA_REST_HOST, KSQL_HOST}).generate("CN=mymachine.local, O=A client", keypair);
        String alias = type.toString().toLowerCase();
        TestSslUtils.createKeyStore((String)file.getPath(), (Password)new Password(TEST_SSL_PASSWORD), (Password)new Password(TEST_SSL_PASSWORD), (String)alias, (Key)keypair.getPrivate(), (Certificate)cCert);
        certs.put(alias, cCert);
    }

    private static enum ServiceType {
        CLIENT,
        SERVER;

    }

    @Path(value="/")
    public static class RestResource {
        @GET
        @Path(value="/resource")
        public String get() {
            return "Hello";
        }
    }

    private static class TestApp
    extends Application<TestRestConfig>
    implements AutoCloseable {
        TestApp(TestRestConfig config, String path) {
            super((RestConfig)config, path);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(RestResource.class);
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }
    }
}

