/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.NamedURI;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestConfigTest {
    public static final String CONFIG_PREFIX = "my.config.prefix.";
    public static final Set<String> EMPTY_LISTENER_NAME_SET = new HashSet<String>();
    public static final Set<String> THREE_LISTENER_NAMES_SET = new HashSet<String>(Arrays.asList("a", "b", "c"));

    @Test
    public void testValidProtocolMapCases() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listener.protocol.map", "");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Map protocolMap = config.getListenerProtocolMap();
        Assertions.assertEquals((int)0, (int)protocolMap.size());
        props = new HashMap();
        config = new RestConfig(RestConfig.baseConfigDef(), props);
        protocolMap = config.getListenerProtocolMap();
        Assertions.assertNotNull((Object)protocolMap);
        Assertions.assertEquals((int)0, (int)protocolMap.size());
        props = new HashMap();
        props.put("listener.protocol.map", "INTERNAL:http");
        config = new RestConfig(RestConfig.baseConfigDef(), props);
        protocolMap = config.getListenerProtocolMap();
        Assertions.assertEquals((int)1, (int)protocolMap.size());
        Assertions.assertTrue((boolean)protocolMap.containsKey("internal"));
        Assertions.assertEquals((Object)"http", protocolMap.get("internal"));
        props = new HashMap();
        props.put("listener.protocol.map", "INTERNAL:http,EXTERNAL:https");
        config = new RestConfig(RestConfig.baseConfigDef(), props);
        protocolMap = config.getListenerProtocolMap();
        Assertions.assertEquals((int)2, (int)protocolMap.size());
        Assertions.assertTrue((boolean)protocolMap.containsKey("internal"));
        Assertions.assertEquals((Object)"http", protocolMap.get("internal"));
        Assertions.assertTrue((boolean)protocolMap.containsKey("external"));
        Assertions.assertEquals((Object)"https", protocolMap.get("external"));
        props = new HashMap();
        props.put("listener.protocol.map", "http:http,EXTERNAL:https");
        config = new RestConfig(RestConfig.baseConfigDef(), props);
        protocolMap = config.getListenerProtocolMap();
        Assertions.assertEquals((int)2, (int)protocolMap.size());
        Assertions.assertTrue((boolean)protocolMap.containsKey("http"));
        Assertions.assertEquals((Object)"http", protocolMap.get("http"));
        Assertions.assertTrue((boolean)protocolMap.containsKey("external"));
        Assertions.assertEquals((Object)"https", protocolMap.get("external"));
    }

    @Test
    public void testHttpSetToHttps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listener.protocol.map", "HTTP:https");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Assertions.assertThrows(ConfigException.class, () -> config.getListenerProtocolMap());
    }

    @Test
    public void testInvalidProtocolMapping() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listener.protocol.map", "internal");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Assertions.assertThrows(ConfigException.class, () -> config.getListenerProtocolMap());
    }

    @Test
    public void testInvalidProtocolMappingList() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listener.protocol.map", "INTERNAL:http;EXTERNAL:https");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Assertions.assertThrows(ConfigException.class, () -> config.getListenerProtocolMap());
    }

    @Test
    public void testEmptyProtocolMappingListenerName() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listener.protocol.map", "INTERNAL:http,:https");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Assertions.assertThrows(ConfigException.class, () -> config.getListenerProtocolMap());
    }

    @Test
    public void testDuplicateProtocolMappingListenerName() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listener.protocol.map", "INTERNAL:http,INTERNAL:https");
        RestConfig config = new RestConfig(RestConfig.baseConfigDef(), props);
        Assertions.assertThrows(ConfigException.class, () -> config.getListenerProtocolMap());
    }

    @Test
    public void testEmptyProtocolMapNamedInstanceConfig() {
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("my.config.prefix.foo", "1");
        original.put("my.config.prefix.a.bar", "1");
        Map conf = RestConfig.getInstanceConfig((String)CONFIG_PREFIX, EMPTY_LISTENER_NAME_SET, original);
        Assertions.assertEquals((int)1, (int)conf.size());
        Assertions.assertTrue((boolean)conf.containsKey(""));
        Assertions.assertEquals((int)2, (int)((Map)conf.get("")).size());
        Assertions.assertTrue((boolean)((Map)conf.get("")).containsKey("foo"));
        Assertions.assertTrue((boolean)((Map)conf.get("")).containsKey("a.bar"));
    }

    @Test
    public void testMultiNamedListenerInstanceConfig() {
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("my.config.prefix.a.foo", "1");
        original.put("my.config.prefix.A.bar", "2");
        original.put("my.config.prefix.b.bar", "3");
        original.put("my.config.prefix.c.baz", "4");
        Map conf = RestConfig.getInstanceConfig((String)CONFIG_PREFIX, THREE_LISTENER_NAMES_SET, original);
        Assertions.assertEquals((int)3, (int)conf.size());
        Assertions.assertFalse((boolean)conf.containsKey(""));
        Assertions.assertEquals((int)2, (int)((Map)conf.get("a")).size());
        Assertions.assertTrue((boolean)((Map)conf.get("a")).containsKey("foo"));
        Assertions.assertTrue((boolean)((Map)conf.get("a")).containsKey("bar"));
        Assertions.assertFalse((boolean)((Map)conf.get("a")).containsKey("baz"));
        Assertions.assertEquals((Object)"1", ((Map)conf.get("a")).get("foo"));
        Assertions.assertEquals((Object)"2", ((Map)conf.get("a")).get("bar"));
        Assertions.assertEquals((int)1, (int)((Map)conf.get("b")).size());
        Assertions.assertFalse((boolean)((Map)conf.get("b")).containsKey("foo"));
        Assertions.assertTrue((boolean)((Map)conf.get("b")).containsKey("bar"));
        Assertions.assertFalse((boolean)((Map)conf.get("b")).containsKey("baz"));
        Assertions.assertEquals((Object)"3", ((Map)conf.get("b")).get("bar"));
        Assertions.assertEquals((int)1, (int)((Map)conf.get("c")).size());
        Assertions.assertFalse((boolean)((Map)conf.get("c")).containsKey("foo"));
        Assertions.assertFalse((boolean)((Map)conf.get("c")).containsKey("bar"));
        Assertions.assertTrue((boolean)((Map)conf.get("c")).containsKey("baz"));
        Assertions.assertEquals((Object)"4", ((Map)conf.get("c")).get("baz"));
    }

    @Test
    public void testSingleNamedListenerInstanceConfig() {
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("my.config.prefix.a.foo", "1");
        original.put("my.config.prefix.a.bar", "2");
        Map conf = RestConfig.getInstanceConfig((String)CONFIG_PREFIX, THREE_LISTENER_NAMES_SET, original);
        Assertions.assertEquals((int)1, (int)conf.size());
        Assertions.assertFalse((boolean)conf.containsKey(""));
        Assertions.assertFalse((boolean)conf.containsKey("b"));
        Assertions.assertFalse((boolean)conf.containsKey("c"));
        Assertions.assertEquals((int)2, (int)((Map)conf.get("a")).size());
        Assertions.assertTrue((boolean)((Map)conf.get("a")).containsKey("foo"));
        Assertions.assertTrue((boolean)((Map)conf.get("a")).containsKey("bar"));
        Assertions.assertFalse((boolean)((Map)conf.get("a")).containsKey("baz"));
        Assertions.assertEquals((Object)"1", ((Map)conf.get("a")).get("foo"));
        Assertions.assertEquals((Object)"2", ((Map)conf.get("a")).get("bar"));
    }

    @Test
    public void testNamedInstanceConfigWhenNoPropertiesPrefixed() {
        HashMap original = new HashMap();
        Map conf = RestConfig.getInstanceConfig((String)CONFIG_PREFIX, THREE_LISTENER_NAMES_SET, original);
        Assertions.assertEquals((int)1, (int)conf.size());
        Assertions.assertTrue((boolean)conf.containsKey(""));
        Assertions.assertEquals((int)0, (int)((Map)conf.get("")).size());
    }

    @Test
    public void testPerListenerSslConfig() throws URISyntaxException {
        RestConfig restConfig = new RestConfig(RestConfig.baseConfigDef(), (Map)ImmutableMap.builder().put((Object)"listeners", (Object)"A://1.1.1.1:1,B://2.2.2.2:2").put((Object)"listener.protocol.map", (Object)"A:https,B:https").put((Object)"ssl.keystore.location", (Object)"default.jks").put((Object)"listener.name.A.ssl.keystore.location", (Object)"a.jks").build());
        Map sslConfigs = restConfig.getSslConfigs();
        SslConfig baseSslConfig = restConfig.getBaseSslConfig();
        SslConfig aSslConfig = (SslConfig)sslConfigs.get(new NamedURI(new URI("https://1.1.1.1:1"), "A"));
        SslConfig bSslConfig = (SslConfig)sslConfigs.get(new NamedURI(new URI("https://2.2.2.2:2"), "B"));
        Assertions.assertEquals((Object)"default.jks", (Object)baseSslConfig.getKeyStorePath());
        Assertions.assertEquals((Object)"a.jks", (Object)aSslConfig.getKeyStorePath());
        Assertions.assertEquals((Object)"default.jks", (Object)bSslConfig.getKeyStorePath());
    }

    @Test
    public void testPerListenerSslConfigHttpsName() throws URISyntaxException {
        RestConfig restConfig = new RestConfig(RestConfig.baseConfigDef(), (Map)ImmutableMap.builder().put((Object)"listeners", (Object)"https://1.1.1.1:1,https://2.2.2.2:2,A://3.3.3.3:3").put((Object)"listener.protocol.map", (Object)"A:https").put((Object)"ssl.keystore.location", (Object)"default.jks").put((Object)"listener.name.https.ssl.keystore.location", (Object)"https.jks").put((Object)"listener.name.A.ssl.keystore.location", (Object)"a.jks").build());
        Map sslConfigs = restConfig.getSslConfigs();
        SslConfig baseSslConfig = restConfig.getBaseSslConfig();
        SslConfig https1SslConfig = (SslConfig)sslConfigs.get(new NamedURI(new URI("https://1.1.1.1:1"), null));
        SslConfig https2SslConfig = (SslConfig)sslConfigs.get(new NamedURI(new URI("https://2.2.2.2:2"), null));
        SslConfig aSslConfig = (SslConfig)sslConfigs.get(new NamedURI(new URI("https://3.3.3.3:3"), "A"));
        Assertions.assertEquals((Object)"default.jks", (Object)baseSslConfig.getKeyStorePath());
        Assertions.assertEquals((Object)"https.jks", (Object)https1SslConfig.getKeyStorePath());
        Assertions.assertEquals((Object)"https.jks", (Object)https2SslConfig.getKeyStorePath());
        Assertions.assertEquals((Object)"a.jks", (Object)aSslConfig.getKeyStorePath());
    }

    @Test
    public void testPerListenerSslConfigRepeatedConfig() throws URISyntaxException {
        RestConfig restConfig = new RestConfig(RestConfig.baseConfigDef(), (Map)ImmutableMap.builder().put((Object)"listeners", (Object)"A://1.1.1.1:1").put((Object)"listener.protocol.map", (Object)"A:https").put((Object)"ssl.keystore.location", (Object)"default.jks").put((Object)"listener.name.a.ssl.keystore.location", (Object)"a1.jks").put((Object)"listener.name.A.ssl.keystore.location", (Object)"a2.jks").build());
        Map sslConfigs = restConfig.getSslConfigs();
        SslConfig baseSslConfig = restConfig.getBaseSslConfig();
        SslConfig aSslConfig = (SslConfig)sslConfigs.get(new NamedURI(new URI("https://1.1.1.1:1"), "A"));
        Assertions.assertEquals((Object)"default.jks", (Object)baseSslConfig.getKeyStorePath());
        Assertions.assertTrue((boolean)aSslConfig.getKeyStorePath().matches("a[12]\\.jks"));
    }
}

