/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.TestUtils;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Tag(value="IntegrationTest")
public class RequestLogHandlerIntegrationTest {
    private final HttpClient httpClient = new HttpClient();
    @Captor
    private ArgumentCaptor<Request> requestCaptor;
    @Captor
    private ArgumentCaptor<Response> responseCaptor;

    @BeforeEach
    public void setUp() throws Exception {
        this.httpClient.start();
        this.requestCaptor = ArgumentCaptor.forClass(Request.class);
        this.responseCaptor = ArgumentCaptor.forClass(Response.class);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.httpClient.stop();
    }

    @Test
    public void test_CustomRequestLog_registeredToCorrectListener() throws Exception {
        int internalPort = TestUtils.getFreePort();
        int externalPort = TestUtils.getFreePort();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "INTERNAL://127.0.0.1:" + internalPort + ",EXTERNAL://127.0.0.1:" + externalPort);
        props.put("listener.protocol.map", "INTERNAL:http,EXTERNAL:http");
        TestRestConfig config = TestRestConfig.maprCompatible(props);
        CustomRequestLog mockLogInternal = (CustomRequestLog)Mockito.mock(CustomRequestLog.class);
        TestApp internalApp = new TestApp(config, "/", "internal", mockLogInternal);
        Server server = internalApp.createServer();
        CustomRequestLog mockLogExternal = (CustomRequestLog)Mockito.mock(CustomRequestLog.class);
        TestApp externalApp = new TestApp(config, "/", "external", mockLogExternal);
        ((ApplicationServer)server).registerApplication((Application)externalApp);
        server.start();
        ContentResponse response = this.httpClient.newRequest("http://127.0.0.1:" + internalPort).path("/custom/resource").send();
        ((CustomRequestLog)Mockito.verify((Object)mockLogInternal, (VerificationMode)Mockito.times((int)1))).log((Request)this.requestCaptor.capture(), (Response)this.responseCaptor.capture());
        ((CustomRequestLog)Mockito.verify((Object)mockLogExternal, (VerificationMode)Mockito.never())).log((Request)Mockito.any(), (Response)Mockito.any());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)((Request)this.requestCaptor.getValue()).getServerName());
        Assertions.assertEquals((int)200, (int)((Response)this.responseCaptor.getValue()).getStatus());
        Assertions.assertEquals((int)200, (int)response.getStatus());
        server.stop();
    }

    @Path(value="/custom")
    @Produces(value={"text/plain"})
    public static class RestResource {
        @GET
        @Path(value="/resource")
        public String get() {
            return "Hello";
        }
    }

    private static class TestApp
    extends Application<TestRestConfig>
    implements AutoCloseable {
        private static final AtomicBoolean SHUTDOWN_CALLED = new AtomicBoolean(true);

        public TestApp(TestRestConfig config, String path, String listenerName, CustomRequestLog customRequestLog) {
            super((RestConfig)config, path, listenerName, (RequestLog)customRequestLog);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            config.register(RestResource.class);
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }

        public void onShutdown() {
            SHUTDOWN_CALLED.set(true);
        }
    }
}

