/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.JsonMappingExceptionMapper;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JsonMappingExceptionMapperTest {
    private JsonMappingExceptionMapper mapper;

    @BeforeEach
    public void setUp() {
        this.mapper = new JsonMappingExceptionMapper();
    }

    @Test
    public void testJsonMappingException() {
        try {
            String json = "{\"name\":{}}";
            ObjectMapper mapper = new ObjectMapper();
            mapper.reader().forType(User.class).readValue(json);
        }
        catch (JsonMappingException e) {
            Response response = this.mapper.toResponse(e);
            Assertions.assertEquals((int)400, (int)response.getStatus());
            ErrorMessage out = (ErrorMessage)response.getEntity();
            Assertions.assertEquals((int)400, (int)out.getErrorCode());
        }
        catch (Exception e) {
            Assertions.fail((String)"A JsonMappingException is expected.");
        }
    }

    @Test
    public void testJsonMappingExceptionRemoveDetailsFromMessage() {
        JsonMappingException jsonMappingException = new JsonMappingException("Json mapping error (for Object starting at:", JsonLocation.NA);
        jsonMappingException.prependPath((Object)new JsonMappingException.Reference((Object)"path"), 0);
        Response response = this.mapper.toResponse(jsonMappingException);
        Assertions.assertEquals((int)400, (int)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assertions.assertEquals((int)400, (int)out.getErrorCode());
        Assertions.assertEquals((Object)"Json mapping error", (Object)out.getMessage());
    }

    @Test
    public void testJsonMappingExceptionRemoveDetailsCannotConstruct() {
        JsonMappingException jsonMappingException = new JsonMappingException("Cannot construct instance of `io.confluent.kafkarest.entities.v3.CreateAclRequest`, problem: Null resourceType", JsonLocation.NA);
        jsonMappingException.prependPath((Object)new JsonMappingException.Reference((Object)"path"), 0);
        Response response = this.mapper.toResponse(jsonMappingException);
        Assertions.assertEquals((int)400, (int)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assertions.assertEquals((int)400, (int)out.getErrorCode());
        Assertions.assertEquals((Object)"Cannot construct instance of `CreateAclRequest`, problem: Null resourceType", (Object)out.getMessage());
    }

    @Test
    public void testJsonMappingExceptionRemoveDetailsCannotDeserializeEnum() {
        JsonMappingException jsonMappingException = new JsonMappingException("Cannot deserialize value of type `io.confluent.kafkarest.entities.Acl$ResourceType` from String \"TEAPOT\": not one of the values accepted for Enum class: [TRANSACTIONAL_ID, DELEGATION_TOKEN, UNKNOWN, ANY, GROUP, CLUSTER, TOPIC]", JsonLocation.NA);
        jsonMappingException.prependPath((Object)new JsonMappingException.Reference((Object)"path"), 0);
        Response response = this.mapper.toResponse(jsonMappingException);
        Assertions.assertEquals((int)400, (int)response.getStatus());
        ErrorMessage out = (ErrorMessage)response.getEntity();
        Assertions.assertEquals((int)400, (int)out.getErrorCode());
        Assertions.assertEquals((Object)"Cannot deserialize value of type `ResourceType` from String \"TEAPOT\": not one of the values accepted for Enum class: [TRANSACTIONAL_ID, DELEGATION_TOKEN, UNKNOWN, ANY, GROUP, CLUSTER, TOPIC]", (Object)out.getMessage());
    }

    @Test
    public void testSanitizeExceptionMessage() {
        Assertions.assertEquals(null, (Object)this.mapper.sanitizeExceptionMessage(null));
        Assertions.assertEquals((Object)"a.b.c$D", (Object)this.mapper.sanitizeExceptionMessage("a.b.c$D"));
        Assertions.assertEquals((Object)"`D`", (Object)this.mapper.sanitizeExceptionMessage("`a.b.c$D`"));
        Assertions.assertEquals((Object)"x`c$`y", (Object)this.mapper.sanitizeExceptionMessage("x`a.b.c$`y"));
        Assertions.assertEquals((Object)"`D`", (Object)this.mapper.sanitizeExceptionMessage("`a.b.c$D`"));
        Assertions.assertEquals((Object)"x`Def`y", (Object)this.mapper.sanitizeExceptionMessage("x`a.b.c$Def`y"));
        Assertions.assertEquals((Object)"`D`", (Object)this.mapper.sanitizeExceptionMessage("`D`"));
        Assertions.assertEquals((Object)"x`D`y", (Object)this.mapper.sanitizeExceptionMessage("x`a.b.c.D`y"));
        Assertions.assertEquals((Object)"This `Name` is more `complicated`.", (Object)this.mapper.sanitizeExceptionMessage("This `class.Name` is more `complicated`."));
        Assertions.assertEquals((Object)"This one`s just obtuse.", (Object)this.mapper.sanitizeExceptionMessage("This one`s just obtuse."));
        Assertions.assertEquals((Object)"", (Object)this.mapper.sanitizeExceptionMessage(""));
        Assertions.assertEquals((Object)"`", (Object)this.mapper.sanitizeExceptionMessage("`"));
        Assertions.assertEquals((Object)"``", (Object)this.mapper.sanitizeExceptionMessage("``"));
        Assertions.assertEquals((Object)"```", (Object)this.mapper.sanitizeExceptionMessage("```"));
        Assertions.assertEquals((Object)"````", (Object)this.mapper.sanitizeExceptionMessage("````"));
    }

    class User {
        public String name;

        User(String name) {
            this.name = name;
        }
    }
}

