/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.auth;

import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import io.confluent.rest.impersonation.Errors;
import java.io.IOException;
import java.net.HttpCookie;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class MaprAuthenticationUtils {
    private static final String MAPR_NEGOTIATE = "MAPR-Negotiate";
    private static final String BASIC = "Basic";
    private static final String HADOOP_AUTH_COOKIE = "hadoop.auth";

    public static String getUserNameFromRequestContext(ContainerRequestContext request) {
        String authorization = request.getHeaderString("Authorization");
        return MaprAuthenticationUtils.findUserNameFromAuthentication(authorization).orElseGet(() -> MaprAuthenticationUtils.findUserNameFromRequestCookie(request).orElseThrow(MaprAuthenticationUtils::onMissingUsername));
    }

    private static Optional<String> findUserNameFromRequestCookie(ContainerRequestContext request) {
        return Optional.ofNullable(request.getCookies()).map(cookies -> (Cookie)cookies.get(HADOOP_AUTH_COOKIE)).map(Cookie::getValue).flatMap(MaprAuthenticationUtils::findUserNameFromHadoopAuthCookieValue);
    }

    public static String getUserNameFromAuthenticationOrCookie(String auth, String cookie) {
        return MaprAuthenticationUtils.findUserNameFromAuthentication(auth).orElseGet(() -> MaprAuthenticationUtils.findUserNameFromCookie(cookie).orElseThrow(MaprAuthenticationUtils::onMissingUsername));
    }

    private static RuntimeException onMissingUsername() {
        return Errors.serverLoginException(new IOException("Username is unavailable"));
    }

    public static Optional<String> findUserNameFromAuthentication(String auth) {
        String type = StringUtils.substringBefore((String)auth, (String)" ");
        String value = StringUtils.substringAfter((String)auth, (String)" ");
        if (BASIC.equals(type)) {
            return Optional.ofNullable(MaprAuthenticationUtils.getUserNameFromBasicAuthentication(value.trim()));
        }
        if (MAPR_NEGOTIATE.equals(type)) {
            return Optional.ofNullable(MaprAuthenticationUtils.getUserNameFromMaprTicketAuthentication(value.trim()));
        }
        return Optional.empty();
    }

    private static String getUserNameFromBasicAuthentication(String base64Credentials) {
        Base64.Decoder decoder = java.util.Base64.getDecoder();
        String credentials = new String(decoder.decode(base64Credentials), StandardCharsets.UTF_8);
        return StringUtils.substringBefore((String)credentials, (String)":");
    }

    private static String getUserNameFromMaprTicketAuthentication(String authRequest) {
        try {
            byte[] base64decoded = Base64.decodeBase64((String)authRequest);
            Security.AuthenticationReqFull req = Security.AuthenticationReqFull.parseFrom((byte[])base64decoded);
            if (req != null && req.hasEncryptedTicket()) {
                byte[] encryptedTicket = req.getEncryptedTicket().toByteArray();
                MutableInt err = new MutableInt();
                Security.Ticket decryptedTicket = Security.DecryptTicket((byte[])encryptedTicket, (MutableInt)err);
                if (err.GetValue() == 0 && decryptedTicket != null) {
                    Security.CredentialsMsg userCreds = decryptedTicket.getUserCreds();
                    return userCreds.getUserName();
                }
                String decryptError = "Error while decrypting ticket and key " + err.GetValue();
                throw Errors.maprTicketDecryptException(decryptError);
            }
            String clientRequestError = "Malformed client request";
            throw Errors.maprTicketDecryptException(clientRequestError);
        }
        catch (InvalidProtocolBufferException e) {
            throw Errors.maprTicketDecryptException("Bad server key", e);
        }
    }

    public static Optional<String> findUserNameFromCookie(String cookie) {
        return Optional.ofNullable(cookie).map(HttpCookie::parse).orElse(Collections.emptyList()).stream().filter(httpCookie -> httpCookie.getName().equals(HADOOP_AUTH_COOKIE)).findFirst().map(HttpCookie::getValue).flatMap(MaprAuthenticationUtils::findUserNameFromHadoopAuthCookieValue);
    }

    private static Optional<String> findUserNameFromHadoopAuthCookieValue(String value) {
        String[] parameters;
        for (String parameter : parameters = value.split("&")) {
            if (!parameter.startsWith("u=")) continue;
            return Optional.of(StringUtils.removeStart((String)parameter, (String)"u="));
        }
        return Optional.empty();
    }
}

