/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.JettyDosFilterMultiListener;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.servlets.DoSFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JettyDosFilterMultiListenerTest {
    private final DoSFilter.Listener listener1 = (DoSFilter.Listener)Mockito.mock(DoSFilter.Listener.class);
    private final DoSFilter.Listener listener2 = (DoSFilter.Listener)Mockito.mock(DoSFilter.Listener.class);
    private final List<DoSFilter.Listener> listeners = Arrays.asList(this.listener1, this.listener2);
    private final JettyDosFilterMultiListener multiListener = new JettyDosFilterMultiListener(this.listeners);
    private final DoSFilter dosfilter = (DoSFilter)Mockito.mock(DoSFilter.class);
    private final long rejectDelayMs = -1L;

    @Test
    public void test_2Listeners_bothListenersAreCalled() {
        Mockito.when((Object)this.dosfilter.getDelayMs()).thenReturn((Object)-1L);
        Mockito.when((Object)this.listener1.onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any())).thenReturn((Object)DoSFilter.Action.REJECT);
        Mockito.when((Object)this.listener2.onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any())).thenReturn((Object)DoSFilter.Action.REJECT);
        DoSFilter.Action action = this.multiListener.onRequestOverLimit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), (DoSFilter.OverLimit)Mockito.mock(DoSFilter.OverLimit.class), this.dosfilter);
        Assertions.assertEquals((Object)action, (Object)DoSFilter.Action.REJECT);
        ((DoSFilter.Listener)Mockito.verify((Object)this.listener1, (VerificationMode)Mockito.times((int)1))).onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any());
        ((DoSFilter.Listener)Mockito.verify((Object)this.listener2, (VerificationMode)Mockito.times((int)1))).onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any());
    }

    @Test
    public void test_2Listeners_1ListenersThrows_OtherListenerIsCalled() {
        Mockito.when((Object)this.dosfilter.getDelayMs()).thenReturn((Object)-1L);
        Mockito.when((Object)this.listener1.onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.listener2.onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any())).thenReturn((Object)DoSFilter.Action.REJECT);
        DoSFilter.Action action = this.multiListener.onRequestOverLimit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), (DoSFilter.OverLimit)Mockito.mock(DoSFilter.OverLimit.class), this.dosfilter);
        Assertions.assertEquals((Object)action, (Object)DoSFilter.Action.REJECT);
        ((DoSFilter.Listener)Mockito.verify((Object)this.listener1, (VerificationMode)Mockito.times((int)1))).onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any());
        ((DoSFilter.Listener)Mockito.verify((Object)this.listener2, (VerificationMode)Mockito.times((int)1))).onRequestOverLimit((HttpServletRequest)ArgumentMatchers.any(), (DoSFilter.OverLimit)ArgumentMatchers.any(), (DoSFilter)ArgumentMatchers.any());
    }
}

