/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.TestRestConfig;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.RestNotFoundException;
import io.confluent.rest.exceptions.RestServerErrorException;
import io.confluent.rest.exceptions.RestTimeoutException;
import java.util.HashMap;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExceptionHandlingTest {
    private TestRestConfig config;
    private Server server;
    private ExceptionApplication application;

    @BeforeEach
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("debug", "false");
        props.setProperty("listeners", "http://localhost:0");
        this.config = TestRestConfig.maprCompatible(props);
        this.application = new ExceptionApplication(this.config);
        this.server = this.application.createServer();
        this.server.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.join();
    }

    private void testGetException(String path, int expectedStatus, int expectedErrorCode, String expectedMessage) {
        Response response = ClientBuilder.newClient((Configuration)this.application.resourceConfig.getConfiguration()).target(this.server.getURI()).path(path).request().get();
        Assertions.assertEquals((int)expectedStatus, (int)response.getStatus());
        ErrorMessage msg = (ErrorMessage)response.readEntity(ErrorMessage.class);
        Assertions.assertEquals((int)expectedErrorCode, (int)msg.getErrorCode());
        Assertions.assertEquals((Object)expectedMessage, (Object)msg.getMessage());
    }

    private void testPostException(String path, Entity entity, int expectedStatus, int expectedErrorCode, String expectedMessage) {
        Response response = ClientBuilder.newClient((Configuration)this.application.resourceConfig.getConfiguration()).target(this.server.getURI()).path(path).request().post(entity);
        Assertions.assertEquals((int)expectedStatus, (int)response.getStatus());
        ErrorMessage msg = (ErrorMessage)response.readEntity(ErrorMessage.class);
        Assertions.assertEquals((int)expectedErrorCode, (int)msg.getErrorCode());
        Assertions.assertEquals((Object)expectedMessage, (Object)msg.getMessage());
    }

    @Test
    public void testRestException() {
        this.testGetException("/restnotfound", 404, 4040, "Rest Not Found");
    }

    @Test
    public void testNonRestException() {
        this.testGetException("/notfound", 404, 404, "Generic Not Found");
    }

    @Test
    public void testUnexpectedException() {
        this.testGetException("/unexpected", 500, 50001, Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    @Test
    public void testRestTimeoutException() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("something", "something");
        m.put("something-else", "something-else");
        this.testPostException("readTimeout", Entity.json(m), 408, 408, "Idle timeout expired");
    }

    @Test
    public void testUnrecognizedField() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("something", "something");
        m.put("something-else", "something-else");
        this.testPostException("/unrecognizedfield", Entity.json(m), 422, 422, "Unrecognized field: something-else");
    }

    @Produces(value={"application/json"})
    @Path(value="/")
    public static class ExceptionResource {
        @GET
        @Path(value="/restnotfound")
        public String restNotFound() {
            throw new RestNotFoundException("Rest Not Found", 4040);
        }

        @GET
        @Path(value="/notfound")
        public String notFound() {
            throw new NotFoundException("Generic Not Found");
        }

        @GET
        @Path(value="/unexpected")
        public String unexpected() {
            throw new RestServerErrorException("Internal Server Error", 50001);
        }

        @POST
        @Path(value="/unrecognizedfield")
        public String blah(FakeType ft) {
            return ft.something;
        }

        @POST
        @Path(value="/readTimeout")
        public String restTimeout() {
            throw new RestTimeoutException("Idle timeout expired", 408, 408);
        }
    }

    private static class ExceptionApplication
    extends Application<TestRestConfig> {
        Configurable<?> resourceConfig;

        ExceptionApplication(TestRestConfig props) {
            super((RestConfig)props);
        }

        public void setupResources(Configurable<?> config, TestRestConfig appConfig) {
            this.resourceConfig = config;
            config.register(ExceptionResource.class);
        }
    }

    public static class FakeType {
        public String something;
    }
}

