/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DosFilterTest {
    @Test
    public void dosFilterEnabled_defaultTracking_throttlesRequestsPerIp() throws Exception {
        FooApplication application = new FooApplication(new FooConfig((Map<String, String>)ImmutableMap.of((Object)"listeners", (Object)"http://localhost:0", (Object)"dos.filter.enabled", (Object)"true", (Object)"dos.filter.max.requests.per.connection.per.sec", (Object)"1", (Object)"dos.filter.max.requests.per.sec", (Object)"1000", (Object)"dos.filter.delay.ms", (Object)"-1")));
        Server server = application.createServer();
        server.start();
        HttpGet request = DosFilterTest.createRequest(server.getURI());
        CloseableHttpClient ephemeralClient = DosFilterTest.createEphemeralClient();
        CloseableHttpResponse response1 = ephemeralClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response1.getStatusLine().getStatusCode());
        response1.close();
        for (int i = 0; i < 100; ++i) {
            CloseableHttpResponse response2 = ephemeralClient.execute((HttpUriRequest)request);
            Assertions.assertEquals((int)Response.Status.TOO_MANY_REQUESTS.getStatusCode(), (int)response2.getStatusLine().getStatusCode());
            response2.close();
        }
        Thread.sleep(1000L);
        CloseableHttpResponse response3 = ephemeralClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response3.getStatusLine().getStatusCode());
        response3.close();
        server.stop();
    }

    @Test
    public void dosFilterDisabled_doesNotThrottleRequests() throws Exception {
        FooApplication application = new FooApplication(new FooConfig((Map<String, String>)ImmutableMap.of((Object)"listeners", (Object)"http://localhost:0", (Object)"dos.filter.enabled", (Object)"false", (Object)"dos.filter.max.requests.per.connection.per.sec", (Object)"1", (Object)"dos.filter.delay.ms", (Object)"-1")));
        Server server = application.createServer();
        server.start();
        HttpGet request = DosFilterTest.createRequest(server.getURI());
        CloseableHttpClient ephemeralClient = DosFilterTest.createEphemeralClient();
        CloseableHttpResponse response1 = ephemeralClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response1.getStatusLine().getStatusCode());
        response1.close();
        for (int i = 0; i < 100; ++i) {
            CloseableHttpResponse response2 = ephemeralClient.execute((HttpUriRequest)request);
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response2.getStatusLine().getStatusCode());
            response2.close();
        }
        server.stop();
    }

    @Test
    public void dosFilterEnabled_throttlesRequestsGlobally() throws Exception {
        FooApplication application = new FooApplication(new FooConfig((Map<String, String>)ImmutableMap.builder().put((Object)"listeners", (Object)"http://localhost:0").put((Object)"dos.filter.enabled", (Object)"true").put((Object)"dos.filter.max.requests.per.sec", (Object)"1").put((Object)"dos.filter.max.requests.per.connection.per.sec", (Object)"100").put((Object)"dos.filter.delay.ms", (Object)"-1").build()));
        Server server = application.createServer();
        server.start();
        HttpGet request = DosFilterTest.createRequest(server.getURI());
        CloseableHttpClient ephemeralClient = DosFilterTest.createEphemeralClient();
        CloseableHttpClient persistentClient = DosFilterTest.createPersistentClient();
        CloseableHttpResponse response1 = ephemeralClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response1.getStatusLine().getStatusCode());
        response1.close();
        CloseableHttpResponse responsePersistent = persistentClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.TOO_MANY_REQUESTS.getStatusCode(), (int)responsePersistent.getStatusLine().getStatusCode());
        responsePersistent.getEntity().getContent().close();
        responsePersistent.close();
        CloseableHttpResponse responseEphemeral = ephemeralClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.TOO_MANY_REQUESTS.getStatusCode(), (int)responseEphemeral.getStatusLine().getStatusCode());
        responseEphemeral.close();
        Thread.sleep(1000L);
        CloseableHttpResponse response2 = persistentClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response2.getStatusLine().getStatusCode());
        CloseableHttpResponse response3 = ephemeralClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.TOO_MANY_REQUESTS.getStatusCode(), (int)response3.getStatusLine().getStatusCode());
        Thread.sleep(1000L);
        CloseableHttpResponse response4 = persistentClient.execute((HttpUriRequest)request);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response4.getStatusLine().getStatusCode());
        server.stop();
    }

    private static HttpGet createRequest(URI serverUri) {
        return new HttpGet(UriBuilder.fromUri((URI)serverUri).path("/foo").build(new Object[0]));
    }

    private static CloseableHttpClient createEphemeralClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager()).setKeepAliveStrategy((httpResponse, httpContext) -> -1L).build();
    }

    private static CloseableHttpClient createPersistentClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setKeepAliveStrategy((httpResponse, httpContext) -> 5000L).build();
    }

    @Path(value="/foo")
    public static final class FooResource {
        @GET
        public String getFoo() {
            return "bar";
        }
    }

    public static final class FooConfig
    extends RestConfig {
        public FooConfig(Map<String, String> configs) {
            super(FooConfig.baseConfigDef(), configs);
        }
    }

    public static final class FooApplication
    extends Application<FooConfig> {
        public FooApplication(FooConfig config) {
            super((RestConfig)config);
        }

        public void setupResources(Configurable<?> config, FooConfig appConfig) {
            config.register(FooResource.class);
        }
    }
}

