/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.rest.entities.ErrorMessage;
import javax.annotation.Priority;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=1)
public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    public static final int BAD_REQUEST_CODE = 400;
    public static final String MESSAGE_SOURCE_SPLITTER = "\\(for Object starting at";

    public Response toResponse(JsonMappingException exception) {
        ErrorMessage message = new ErrorMessage(400, this.sanitizeExceptionMessage(exception.getOriginalMessage()));
        return Response.status((int)400).entity((Object)message).build();
    }

    @VisibleForTesting
    public String sanitizeExceptionMessage(String originalMessage) {
        if (originalMessage == null) {
            return null;
        }
        String sanitizedMessage = originalMessage.split(MESSAGE_SOURCE_SPLITTER)[0].trim();
        CharSequence[] fragments = sanitizedMessage.split("\\`", -1);
        if (fragments.length > 2) {
            int dollar;
            String className = fragments[1];
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1 && lastDot != className.length() - 1) {
                className = className.substring(lastDot + 1);
            }
            if ((dollar = className.lastIndexOf(36)) != -1 && dollar != className.length() - 1) {
                className = className.substring(dollar + 1);
            }
            fragments[1] = className;
            sanitizedMessage = String.join((CharSequence)"`", fragments);
        }
        return sanitizedMessage;
    }
}

