/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.streams.serdes.avro.AvroUtils;
import io.confluent.kafka.streams.serdes.avro.GenericAvroSerde;
import java.util.HashMap;
import org.apache.avro.generic.GenericRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class GenericAvroSerdeTest {
    private static final String ANY_TOPIC = "any-topic";

    private static GenericAvroSerde createConfiguredSerdeForRecordValues() {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        GenericAvroSerde serde = new GenericAvroSerde((SchemaRegistryClient)schemaRegistryClient);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    @Test
    public void shouldRoundTripRecords() {
        GenericAvroSerde serde = GenericAvroSerdeTest.createConfiguredSerdeForRecordValues();
        GenericRecord record = AvroUtils.createGenericRecord();
        GenericRecord roundtrippedRecord = (GenericRecord)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, (Object)record));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.equalTo((Object)record));
        serde.close();
    }

    @Test
    public void shouldRoundTripNullRecordsToNull() {
        GenericAvroSerde serde = GenericAvroSerdeTest.createConfiguredSerdeForRecordValues();
        GenericRecord roundtrippedRecord = (GenericRecord)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, null));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.nullValue());
        serde.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenInstantiatedWithNullSchemaRegistryClient() {
        new GenericAvroSerde(null);
    }
}

