/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.example.Widget;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.streams.serdes.avro.ReflectionAvroSerde;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionAvroSerdeSpecificTest {
    private static final String ANY_TOPIC = "any-topic";

    private static <T> ReflectionAvroSerde<T> createConfiguredSerdeForRecordValues(Class<T> type) {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        ReflectionAvroSerde serde = new ReflectionAvroSerde((SchemaRegistryClient)schemaRegistryClient, type);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    private static <T> ReflectionAvroSerde<T> createConfiguredSerdeForAnyValues() {
        MockSchemaRegistryClient schemaRegistryClient = new MockSchemaRegistryClient();
        ReflectionAvroSerde serde = new ReflectionAvroSerde((SchemaRegistryClient)schemaRegistryClient);
        HashMap<String, String> serdeConfig = new HashMap<String, String>();
        serdeConfig.put("schema.registry.url", "fake");
        serde.configure(serdeConfig, false);
        return serde;
    }

    @Test
    public void shouldRoundTripRecords() {
        ReflectionAvroSerde<Widget> serde = ReflectionAvroSerdeSpecificTest.createConfiguredSerdeForRecordValues(Widget.class);
        Widget record = new Widget("alice");
        Widget roundtrippedRecord = (Widget)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, (Object)record));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.equalTo((Object)record));
        serde.close();
    }

    @Test
    public void shouldRoundTripNullRecordsToNull() {
        ReflectionAvroSerde<Widget> serde = ReflectionAvroSerdeSpecificTest.createConfiguredSerdeForRecordValues(Widget.class);
        Widget roundtrippedRecord = (Widget)serde.deserializer().deserialize(ANY_TOPIC, serde.serializer().serialize(ANY_TOPIC, null));
        Assert.assertThat((Object)roundtrippedRecord, (Matcher)CoreMatchers.nullValue());
        serde.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenInstantiatedWithNullSchemaRegistryClient() {
        new ReflectionAvroSerde(null, Widget.class);
    }
}

