/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.cel.avro;

import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroEnumDescription;
import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroEnumValue;
import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroObjectT;
import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroTypeDescription;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.util.Utf8;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.ref.FieldType;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeAdapterSupport;
import org.projectnessie.cel.common.types.ref.TypeRegistry;
import org.projectnessie.cel.common.types.ref.Val;

public final class AvroRegistry
implements TypeRegistry {
    private final Map<Schema, AvroTypeDescription> knownTypes = new HashMap<Schema, AvroTypeDescription>();
    private final Map<String, AvroTypeDescription> knownTypesByName = new HashMap<String, AvroTypeDescription>();
    private final Map<Schema, AvroEnumDescription> enumMap = new HashMap<Schema, AvroEnumDescription>();
    private final Map<String, AvroEnumValue> enumValues = new HashMap<String, AvroEnumValue>();

    private AvroRegistry() {
    }

    public static TypeRegistry newRegistry() {
        return new AvroRegistry();
    }

    public TypeRegistry copy() {
        return this;
    }

    public void register(Object t) {
        Schema s;
        if (t instanceof Schema) {
            s = (Schema)t;
        } else if (t instanceof GenericContainer) {
            s = ((GenericContainer)t).getSchema();
        } else {
            throw new IllegalArgumentException("argument is not of type Schema or GenericContainer");
        }
        if (s.getType() == Schema.Type.RECORD) {
            this.typeDescription(s);
        }
    }

    public void registerType(Type ... types) {
        throw new UnsupportedOperationException();
    }

    public Val enumValue(String enumName) {
        AvroEnumValue enumVal = this.enumValues.get(enumName);
        if (enumVal == null) {
            return Err.newErr((String)"unknown enum name '%s'", (Object[])new Object[]{enumName});
        }
        return enumVal.stringValue();
    }

    public Val findIdent(String identName) {
        AvroTypeDescription td = this.knownTypesByName.get(identName);
        if (td != null) {
            return td.type();
        }
        AvroEnumValue enumVal = this.enumValues.get(identName);
        if (enumVal != null) {
            return enumVal.stringValue();
        }
        return null;
    }

    public com.google.api.expr.v1alpha1.Type findType(String typeName) {
        AvroTypeDescription td = this.knownTypesByName.get(typeName);
        if (td == null) {
            return null;
        }
        return td.pbType();
    }

    public FieldType findFieldType(String messageType, String fieldName) {
        AvroTypeDescription td = this.knownTypesByName.get(messageType);
        if (td == null) {
            return null;
        }
        return td.fieldType(fieldName);
    }

    public Val newValue(String typeName, Map<String, Val> fields) {
        throw new UnsupportedOperationException();
    }

    public Val nativeToValue(Object value) {
        if (value instanceof Val) {
            return (Val)value;
        }
        Val maybe = TypeAdapterSupport.maybeNativeToValue((TypeAdapter)this, (Object)value);
        if (maybe != null) {
            return maybe;
        }
        if (value instanceof Utf8) {
            return StringT.stringOf((String)value.toString());
        }
        if (value instanceof GenericEnumSymbol) {
            String fq = AvroEnumValue.fullyQualifiedName((GenericEnumSymbol)value);
            AvroEnumValue v = this.enumValues.get(fq);
            if (v == null) {
                return Err.newErr((String)"unknown enum name '%s'", (Object[])new Object[]{fq});
            }
            return v.stringValue();
        }
        try {
            return AvroObjectT.newObject(this, value, this.typeDescription(((GenericContainer)value).getSchema()));
        }
        catch (Exception e) {
            throw new RuntimeException("oops", e);
        }
    }

    AvroEnumDescription enumDescription(Schema schema) {
        if (schema.getType() != Schema.Type.ENUM) {
            throw new IllegalArgumentException("only enum allowed here");
        }
        AvroEnumDescription ed = this.enumMap.get(schema);
        if (ed != null) {
            return ed;
        }
        ed = this.computeEnumDescription(schema);
        this.enumMap.put(schema, ed);
        return ed;
    }

    private AvroEnumDescription computeEnumDescription(Schema schema) {
        AvroEnumDescription enumDesc = new AvroEnumDescription(schema);
        this.enumMap.put(schema, enumDesc);
        enumDesc.buildValues().forEach(v -> this.enumValues.put(v.fullyQualifiedName(), (AvroEnumValue)v));
        return enumDesc;
    }

    AvroTypeDescription typeDescription(Schema schema) {
        if (schema.getType() == Schema.Type.ENUM) {
            throw new IllegalArgumentException("enum not allowed here");
        }
        AvroTypeDescription td = this.knownTypes.get(schema);
        if (td != null) {
            return td;
        }
        td = this.computeTypeDescription(schema);
        this.knownTypes.put(schema, td);
        return td;
    }

    private AvroTypeDescription computeTypeDescription(Schema schema) {
        AvroTypeDescription typeDesc = new AvroTypeDescription(schema, this::typeQuery);
        this.knownTypesByName.put(schema.getFullName(), typeDesc);
        return typeDesc;
    }

    private com.google.api.expr.v1alpha1.Type typeQuery(Schema schema) {
        if (schema.getType() == Schema.Type.ENUM) {
            return this.enumDescription(schema).pbType();
        }
        return this.typeDescription(schema).pbType();
    }
}

