/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.cel;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rules.DlqAction;
import io.confluent.kafka.schemaregistry.rules.PiiProto;
import io.confluent.kafka.schemaregistry.rules.WidgetProto;
import io.confluent.kafka.schemaregistry.rules.WidgetProto2;
import io.confluent.kafka.schemaregistry.rules.WidgetWithRefProto;
import io.confluent.kafka.schemaregistry.rules.cel.CelExecutor;
import io.confluent.kafka.schemaregistry.rules.cel.CelFieldExecutor;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CelExecutorTest {
    private final SchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient((List)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()));
    private final KafkaAvroSerializer avroSerializer;
    private final KafkaAvroDeserializer avroDeserializer;
    private final KafkaAvroSerializer avroKeySerializer;
    private final KafkaAvroDeserializer avroKeyDeserializer;
    private final KafkaAvroSerializer reflectionAvroSerializer;
    private final KafkaAvroDeserializer reflectionAvroDeserializer;
    private final KafkaProtobufSerializer<WidgetProto.Widget> protobufSerializer;
    private final KafkaProtobufSerializer<WidgetProto2.Widget2> protobuf2Serializer;
    private final KafkaProtobufSerializer<WidgetWithRefProto.WidgetWithRef> protobufWithRefSerializer;
    private final KafkaProtobufDeserializer<DynamicMessage> protobufDeserializer;
    private final KafkaJsonSchemaSerializer<OldWidget> jsonSchemaSerializer;
    private final KafkaJsonSchemaSerializer<AnnotatedOldWidget> jsonSchemaSerializer2;
    private final KafkaJsonSchemaSerializer<JsonNode> jsonSchemaSerializer3;
    private final KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaDeserializer;
    private final String topic;
    private final KafkaProducer<byte[], byte[]> producer = (KafkaProducer)Mockito.mock(KafkaProducer.class);
    private final KafkaProducer<byte[], byte[]> producer2;
    private static final ObjectMapper mapper = new ObjectMapper();

    public CelExecutorTest() {
        this.topic = "test";
        Mockito.when((Object)this.producer.send((ProducerRecord)ArgumentMatchers.any(ProducerRecord.class), (Callback)ArgumentMatchers.any(Callback.class))).thenReturn(CompletableFuture.completedFuture(null));
        this.producer2 = (KafkaProducer)Mockito.mock(KafkaProducer.class);
        Mockito.when((Object)this.producer2.send((ProducerRecord)ArgumentMatchers.any(ProducerRecord.class), (Callback)ArgumentMatchers.any(Callback.class))).thenReturn(CompletableFuture.completedFuture(null));
        HashMap<String, Object> defaultConfig = new HashMap<String, Object>();
        defaultConfig.put("schema.registry.url", "bogus");
        defaultConfig.put("auto.register.schemas", "false");
        defaultConfig.put("use.latest.version", "true");
        defaultConfig.put("latest.cache.size", "0");
        defaultConfig.put("rule.executors", "cel,cel-field");
        defaultConfig.put("rule.executors.cel.class", CelExecutor.class.getName());
        defaultConfig.put("rule.executors.cel-field.class", CelFieldExecutor.class.getName());
        defaultConfig.put("rule.actions", "cel,cel_field");
        defaultConfig.put("rule.actions.cel.class", DlqAction.class.getName());
        defaultConfig.put("rule.actions.cel.param.dlq.topic", "dlq-topic");
        defaultConfig.put("rule.actions.cel.param.producer", this.producer);
        defaultConfig.put("rule.actions.cel.param.dlq.auto.flush", true);
        defaultConfig.put("rule.actions.cel_field.class", DlqAction.class.getName());
        defaultConfig.put("rule.actions.cel_field.param.dlq.topic", "dlq-topic2");
        defaultConfig.put("rule.actions.cel_field.param.producer", this.producer2);
        defaultConfig.put("rule.actions.cel_field.param.dlq.auto.flush", true);
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, defaultConfig);
        this.avroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, defaultConfig);
        this.avroKeySerializer = new KafkaAvroSerializer(this.schemaRegistry);
        this.avroKeySerializer.configure(defaultConfig, true);
        this.avroKeyDeserializer = new KafkaAvroDeserializer(this.schemaRegistry);
        this.avroKeyDeserializer.configure(defaultConfig, true);
        HashMap<String, String> reflectionProps = new HashMap<String, String>(defaultConfig);
        reflectionProps.put("schema.reflection", "true");
        this.reflectionAvroSerializer = new KafkaAvroSerializer(this.schemaRegistry, reflectionProps);
        this.reflectionAvroDeserializer = new KafkaAvroDeserializer(this.schemaRegistry, reflectionProps);
        this.protobufSerializer = new KafkaProtobufSerializer(this.schemaRegistry, defaultConfig);
        this.protobuf2Serializer = new KafkaProtobufSerializer(this.schemaRegistry, defaultConfig);
        this.protobufWithRefSerializer = new KafkaProtobufSerializer(this.schemaRegistry, defaultConfig);
        this.protobufDeserializer = new KafkaProtobufDeserializer(this.schemaRegistry, defaultConfig);
        this.jsonSchemaSerializer = new KafkaJsonSchemaSerializer(this.schemaRegistry, defaultConfig);
        this.jsonSchemaSerializer2 = new KafkaJsonSchemaSerializer(this.schemaRegistry, defaultConfig);
        this.jsonSchemaSerializer3 = new KafkaJsonSchemaSerializer(this.schemaRegistry, defaultConfig);
        this.jsonSchemaDeserializer = new KafkaJsonSchemaDeserializer(this.schemaRegistry, defaultConfig);
    }

    private Schema createEnumSchema() {
        String enumSchema = "{\"name\": \"Kind\",\"namespace\": \"example.avro\",\n   \"type\": \"enum\",\n  \"symbols\" : [\"ONE\", \"TWO\", \"THREE\"]\n}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(enumSchema);
        return schema;
    }

    private Schema createUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}, {\"name\": \"lastName\", \"type\": [\"null\", \"string\"]}, {\"name\": \"fullName\", \"type\": [\"null\", \"string\"]}, {\"name\": \"mybytes\", \"type\": \"bytes\"}, {\"name\": \"myint\", \"type\": \"int\"}, {\"name\": \"mylong\", \"type\": \"long\"}, {\"name\": \"myfloat\", \"type\": \"float\"}, {\"name\": \"mydouble\", \"type\": \"double\"}, {\"name\": \"myboolean\", \"type\": \"boolean\"}, {\"name\": \"mynull\", \"type\": \"null\"}, {\"name\": \"kind\",\n  \"type\": {\n    \"name\": \"Kind\",\n    \"type\": \"enum\",\n    \"symbols\" : [\"ONE\", \"TWO\", \"THREE\"]\n  }\n}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private IndexedRecord createUserRecord() {
        return this.createUserRecord("testUser");
    }

    private IndexedRecord createUserRecord(String name) {
        Schema enumSchema = this.createEnumSchema();
        Schema schema = this.createUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)name);
        avroRecord.put("mybytes", (Object)ByteBuffer.wrap(new byte[]{0}));
        avroRecord.put("myint", (Object)1);
        avroRecord.put("mylong", (Object)2L);
        avroRecord.put("myfloat", (Object)Float.valueOf(3.0f));
        avroRecord.put("mydouble", (Object)4.0);
        avroRecord.put("myboolean", (Object)true);
        avroRecord.put("kind", (Object)new GenericData.EnumSymbol(enumSchema, "ONE"));
        return avroRecord;
    }

    private Schema createWidgetSchema() {
        String userSchema = "{\"type\":\"record\",\"name\":\"OldWidget\",\"namespace\":\"io.confluent.kafka.schemaregistry.rules.cel.CelExecutorTest\",\"fields\":\n[{\"name\": \"name\", \"type\": \"string\",\"confluent:tags\": [\"PII\"]},\n{\"name\": \"lastName\", \"type\": \"string\"},\n{\"name\": \"fullName\", \"type\": \"string\"},\n{\"name\": \"myint\", \"type\": \"int\"}, {\"name\": \"mylong\", \"type\": \"long\"}, {\"name\": \"myfloat\", \"type\": \"float\"}, {\"name\": \"mydouble\", \"type\": \"double\"}, {\"name\": \"myboolean\", \"type\": \"boolean\"}, {\"name\": \"ssn\", \"type\": { \"type\": \"array\", \"items\": \"string\"},\"confluent:tags\": [\"PII\"]},\n{\"name\": \"piiArray\", \"type\": { \"type\": \"array\", \"items\": { \"type\": \"record\", \"name\":\"OldPii\", \"fields\":\n[{\"name\": \"pii\", \"type\": \"string\",\"confluent:tags\": [\"PII\"]}]}}},\n{\"name\": \"piiMap\", \"type\": { \"type\": \"map\", \"values\": \"OldPii\"},\n\"confluent:tags\": [\"PII\"]},\n{\"name\": \"size\", \"type\": \"int\"},{\"name\": \"version\", \"type\": \"int\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private Schema createWidgetSchemaNoTags() {
        String userSchema = "{\"type\":\"record\",\"name\":\"OldWidget\",\"namespace\":\"io.confluent.kafka.schemaregistry.rules.cel.CelExecutorTest\",\"fields\":\n[{\"name\": \"name\", \"type\": \"string\"},\n{\"name\": \"lastName\", \"type\": \"string\"},\n{\"name\": \"fullName\", \"type\": \"string\"},\n{\"name\": \"ssn\", \"type\": { \"type\": \"array\", \"items\": \"string\"}},\n{\"name\": \"piiArray\", \"type\": { \"type\": \"array\", \"items\": { \"type\": \"record\", \"name\":\"OldPii\", \"fields\":\n[{\"name\": \"pii\", \"type\": \"string\"}]}}},\n{\"name\": \"piiMap\", \"type\": { \"type\": \"map\", \"values\": \"OldPii\"}}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private Schema createWidgetSchemaWithGuard() {
        String userSchema = "{\"type\":\"record\",\"name\":\"OldWidget\",\"namespace\":\"io.confluent.kafka.schemaregistry.rules.cel.CelExecutorTest\",\"fields\":\n[{\"name\": \"name\", \"type\": \"string\"},\n{\"name\": \"lastName\", \"type\": \"string\"},\n{\"name\": \"fullName\", \"type\": \"string\"},\n{\"name\": \"ssn\", \"type\": { \"type\": \"array\", \"items\": \"string\"}},\n{\"name\": \"piiArray\", \"type\": { \"type\": \"array\", \"items\": { \"type\": \"record\", \"name\":\"OldPii\", \"fields\":\n[{\"name\": \"pii\", \"type\": \"string\"}]}}},\n{\"name\": \"piiMap\", \"type\": { \"type\": \"map\", \"values\": \"OldPii\"}},\n{\"name\": \"size\", \"type\": \"int\"},{\"name\": \"version\", \"type\": \"int\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private Schema createFixedSchema() {
        String fixedSchema = "{\"name\": \"Fixed\",\n   \"type\": \"fixed\",\n  \"size\" : 4\n}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(fixedSchema);
        return schema;
    }

    private Schema createComplexSchema() {
        return new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"enum\",\n       \"type\": {\n         \"name\": \"Kind\",\n         \"type\": \"enum\",\n         \"symbols\" : [\"ONE\", \"TWO\", \"THREE\"]\n       }\n     },\n     {\"name\": \"array\",\n       \"type\": {\n         \"type\": \"array\",\n         \"items\" : \"string\"\n       }\n     },\n     {\"name\": \"map\",\n       \"type\": {\n         \"type\": \"map\",\n         \"values\" : \"string\"\n       }\n     },\n     {\"name\": \"union\", \"type\": [\"null\", \"string\"]},\n     {\"name\": \"fixed\",\n       \"type\": {\n         \"name\": \"Fixed\",\n         \"type\": \"fixed\",\n         \"size\" : 4\n       }\n     }\n]\n}");
    }

    private IndexedRecord createComplexRecord() {
        Schema enumSchema = this.createEnumSchema();
        Schema fixedSchema = this.createFixedSchema();
        Schema schema = this.createComplexSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("null", null);
        avroRecord.put("boolean", (Object)true);
        avroRecord.put("int", (Object)1);
        avroRecord.put("long", (Object)2L);
        avroRecord.put("float", (Object)Float.valueOf(3.0f));
        avroRecord.put("double", (Object)4.0);
        avroRecord.put("bytes", (Object)ByteBuffer.wrap(new byte[]{0, 1, 2}));
        avroRecord.put("string", (Object)"testUser");
        avroRecord.put("enum", (Object)new GenericData.EnumSymbol(enumSchema, "ONE"));
        avroRecord.put("array", (Object)ImmutableList.of((Object)"hi", (Object)"there"));
        avroRecord.put("map", (Object)ImmutableMap.of((Object)"bye", (Object)"there"));
        avroRecord.put("union", (Object)"zap");
        avroRecord.put("fixed", (Object)new GenericData.Fixed(fixedSchema, new byte[]{0, 0, 0, 0}));
        return avroRecord;
    }

    @Test
    public void testKafkaAvroSerializer() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name == \"testUser\" && size(message.name) == 8 && message.kind == \"ONE\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
    }

    @Test
    public void testKafkaAvroSerializerFieldTransform() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"name\" ; value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        GenericRecord obj = (GenericRecord)this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)"testUser-suffix", (Object)obj.get("name").toString());
    }

    @Test
    public void testKafkaAvroSerializerFieldTransformExternalTag() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        ((GenericRecord)avroRecord).put("lastName", (Object)"smith");
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "name == \"lastName\" ; value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = new Metadata(Collections.singletonMap("example.avro.User.lastName", ImmutableSet.of((Object)"PII")), null, null);
        avroSchema = avroSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        GenericRecord obj = (GenericRecord)this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)"smith-suffix", (Object)obj.get("lastName").toString());
    }

    @Test
    public void testKafkaAvroSerializerFieldTransformUsingMessage() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        ((GenericRecord)avroRecord).put("lastName", (Object)"smith");
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"fullName\" ; dyn(value) == null ? message.name + \" \" + message.lastName : dyn(value)", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule2", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mybytes\" ; value == b\"\\x00\" ? b\"\\x01\" : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule3", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myint\" ; value == 1 ? 2 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule4", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mylong\" ; value == 2 ? 3 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule5", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myfloat\" ; value == 3.0 ? 4.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule6", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mydouble\" ; value == 4.0 ? 5.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule7", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myboolean\" ; value == true ? false : value", null, null, false);
        rules.add(rule);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), rules);
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        GenericRecord obj = (GenericRecord)this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)"testUser smith", (Object)obj.get("fullName").toString());
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])((ByteBuffer)obj.get("mybytes")).array());
        Assert.assertEquals((long)2L, (long)((Integer)obj.get("myint")).intValue());
        Assert.assertEquals((long)3L, (long)((Long)obj.get("mylong")));
        Assert.assertEquals((double)4.0, (double)((Float)obj.get("myfloat")).floatValue(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)((Double)obj.get("mydouble")), (double)0.1);
        Assert.assertFalse((boolean)((Boolean)obj.get("myboolean")));
    }

    @Test
    public void testKafkaAvroSerializerFieldTransformComplex() throws Exception {
        IndexedRecord avroRecord = this.createComplexRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"string\" ; value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        GenericRecord obj = (GenericRecord)this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)"testUser-suffix", (Object)obj.get("string").toString());
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerConstraintException() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.READ, "CEL", null, null, "message.name != \"testUser\" || message.kind != \"ONE\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        this.avroDeserializer.deserialize(this.topic, bytes);
    }

    @Test
    public void testKafkaAvroSerializerConstraintGuard() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.READ, "CEL", null, null, "has(message.foo) ; message.name != \"testUser\" || message.kind != \"ONE\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
    }

    @Test
    public void testKafkaAvroSerializerConstraintIgnore() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.READ, "CEL", null, null, "message.name != \"testUser\" || message.kind != \"ONE\"", null, "NONE", false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
    }

    @Test
    public void testKafkaAvroSerializerConstraintDlq() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.READ, "CEL", null, null, "message.name != \"testUser\" || message.kind != \"ONE\"", null, "DLQ", false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        try {
            byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
            this.avroDeserializer.deserialize(this.topic, bytes);
            Assert.fail((String)"Should send to DLQ and throw exception");
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        ((KafkaProducer)Mockito.verify(this.producer)).send((ProducerRecord)ArgumentMatchers.any(ProducerRecord.class), (Callback)ArgumentMatchers.any(Callback.class));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.producer2});
    }

    @Test
    public void testKafkaAvroSerializerConstraintDlqWithKey() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        this.schemaRegistry.register(this.topic + "-key", (ParsedSchema)avroSchema);
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.READ, "CEL", null, null, "message.name != \"testUser\" || message.kind != \"ONE\"", null, "DLQ", false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        try {
            byte[] keyBytes = this.avroKeySerializer.serialize(this.topic, (Object)avroRecord);
            byte[] valueBytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
            this.avroKeyDeserializer.deserialize(this.topic, keyBytes);
            this.avroDeserializer.deserialize(this.topic, valueBytes);
            Assert.fail((String)"Should send to DLQ and throw exception");
        }
        catch (SerializationException keyBytes) {
            // empty catch block
        }
        ArgumentCaptor argument = ArgumentCaptor.forClass(ProducerRecord.class);
        ((KafkaProducer)Mockito.verify(this.producer)).send((ProducerRecord)argument.capture(), (Callback)ArgumentMatchers.any(Callback.class));
        Assert.assertNotNull((Object)((ProducerRecord)argument.getValue()).key());
        Assert.assertNotNull((Object)((ProducerRecord)argument.getValue()).value());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.producer2});
    }

    @Test
    public void testKafkaAvroSerializerReflection() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("");
        widget.setFullName("");
        Schema schema = ReflectData.get().getSchema(widget.getClass());
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.READ, "CEL", null, null, "message.name == \"alice\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object does not match", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
    }

    @Test
    public void testKafkaAvroSerializerReflectionFieldTransform() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("");
        widget.setFullName("");
        widget.setMyint(1);
        widget.setMylong(2L);
        widget.setMyfloat(3.0f);
        widget.setMydouble(4.0);
        widget.setMyboolean(true);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchema();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object does not match", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        Assert.assertEquals((Object)"alice-suffix", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"123-suffix", (Object)((OldWidget)obj).getSsn().get(0));
        Assert.assertEquals((Object)"456-suffix", (Object)((OldWidget)obj).getSsn().get(1));
        Assert.assertEquals((Object)"789-suffix", (Object)((OldWidget)obj).getPiiArray().get(0).getPii());
        Assert.assertEquals((Object)"012-suffix", (Object)((OldWidget)obj).getPiiArray().get(1).getPii());
        Assert.assertEquals((Object)"345-suffix", (Object)((OldWidget)obj).getPiiMap().get("key1").getPii());
        Assert.assertEquals((Object)"678-suffix", (Object)((OldWidget)obj).getPiiMap().get("key2").getPii());
    }

    @Test
    public void testKafkaAvroSerializerReflectionFieldTransformUsingMessage() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("smith");
        widget.setMyint(1);
        widget.setMylong(2L);
        widget.setMyfloat(3.0f);
        widget.setMydouble(4.0);
        widget.setMyboolean(true);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchema();
        AvroSchema avroSchema = new AvroSchema(schema);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"fullName\" ; dyn(value) == null ? message.name + \" \" + message.lastName : dyn(value)", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule2", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mybytes\" ; value == b\"\\x00\" ? b\"\\x01\" : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule3", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myint\" ; value == 1 ? 2 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule4", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mylong\" ; value == 2 ? 3 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule5", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myfloat\" ; value == 3.0 ? 4.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule6", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mydouble\" ; value == 4.0 ? 5.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule7", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myboolean\" ; value == true ? false : value", null, null, false);
        rules.add(rule);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), rules);
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object does not match", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        Assert.assertEquals((Object)"alice", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"alice smith", (Object)((OldWidget)obj).getFullName());
        Assert.assertEquals((long)2L, (long)((OldWidget)obj).getMyint());
        Assert.assertEquals((long)3L, (long)((OldWidget)obj).getMylong());
        Assert.assertEquals((double)4.0, (double)((OldWidget)obj).getMyfloat(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)((OldWidget)obj).getMydouble(), (double)0.1);
        Assert.assertFalse((boolean)((OldWidget)obj).isMyboolean());
        Assert.assertEquals((Object)"123", (Object)((OldWidget)obj).getSsn().get(0));
        Assert.assertEquals((Object)"456", (Object)((OldWidget)obj).getSsn().get(1));
        Assert.assertEquals((Object)"789", (Object)((OldWidget)obj).getPiiArray().get(0).getPii());
        Assert.assertEquals((Object)"012", (Object)((OldWidget)obj).getPiiArray().get(1).getPii());
        Assert.assertEquals((Object)"345", (Object)((OldWidget)obj).getPiiMap().get("key1").getPii());
        Assert.assertEquals((Object)"678", (Object)((OldWidget)obj).getPiiMap().get("key2").getPii());
    }

    @Test
    public void testKafkaAvroSerializerReflectionFieldTransformIgnoreGuardSeparator() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("");
        widget.setFullName("");
        widget.setMyint(1);
        widget.setMylong(2L);
        widget.setMyfloat(3.0f);
        widget.setMydouble(4.0);
        widget.setMyboolean(true);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchema();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), (Map)ImmutableMap.of((Object)"cel.ignore.guard.separator", (Object)"true"), "value + \"-suffix;\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object does not match", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        Assert.assertEquals((Object)"alice-suffix;", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"123-suffix;", (Object)((OldWidget)obj).getSsn().get(0));
        Assert.assertEquals((Object)"456-suffix;", (Object)((OldWidget)obj).getSsn().get(1));
        Assert.assertEquals((Object)"789-suffix;", (Object)((OldWidget)obj).getPiiArray().get(0).getPii());
        Assert.assertEquals((Object)"012-suffix;", (Object)((OldWidget)obj).getPiiArray().get(1).getPii());
        Assert.assertEquals((Object)"345-suffix;", (Object)((OldWidget)obj).getPiiMap().get("key1").getPii());
        Assert.assertEquals((Object)"678-suffix;", (Object)((OldWidget)obj).getPiiMap().get("key2").getPii());
    }

    @Test
    public void testKafkaAvroSerializerReflectionFieldTransformNoTags() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("");
        widget.setFullName("");
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchemaNoTags();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object does not match", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        Assert.assertEquals((Object)"alice-suffix", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"123-suffix", (Object)((OldWidget)obj).getSsn().get(0));
        Assert.assertEquals((Object)"456-suffix", (Object)((OldWidget)obj).getSsn().get(1));
        Assert.assertEquals((Object)"789-suffix", (Object)((OldWidget)obj).getPiiArray().get(0).getPii());
        Assert.assertEquals((Object)"012-suffix", (Object)((OldWidget)obj).getPiiArray().get(1).getPii());
        Assert.assertEquals((Object)"345-suffix", (Object)((OldWidget)obj).getPiiMap().get("key1").getPii());
        Assert.assertEquals((Object)"678-suffix", (Object)((OldWidget)obj).getPiiMap().get("key2").getPii());
    }

    @Test
    public void testKafkaAvroSerializerReflectionFieldTransformWithGuard() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("");
        widget.setFullName("");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchemaWithGuard();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "typeName == 'STRING'; value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object does not match", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        Assert.assertEquals((Object)"alice-suffix", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"123-suffix", (Object)((OldWidget)obj).getSsn().get(0));
        Assert.assertEquals((Object)"456-suffix", (Object)((OldWidget)obj).getSsn().get(1));
        Assert.assertEquals((Object)"789-suffix", (Object)((OldWidget)obj).getPiiArray().get(0).getPii());
        Assert.assertEquals((Object)"012-suffix", (Object)((OldWidget)obj).getPiiArray().get(1).getPii());
        Assert.assertEquals((Object)"345-suffix", (Object)((OldWidget)obj).getPiiMap().get("key1").getPii());
        Assert.assertEquals((Object)"678-suffix", (Object)((OldWidget)obj).getPiiMap().get("key2").getPii());
        Assert.assertEquals((long)123L, (long)((OldWidget)obj).getSize());
    }

    @Test
    public void testKafkaAvroSerializerReflectionFieldTransformWithSameTag() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("");
        widget.setFullName("");
        widget.setMyint(1);
        widget.setMylong(2L);
        widget.setMyfloat(3.0f);
        widget.setMydouble(4.0);
        widget.setMyboolean(true);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        widget.setPiiMap((Map<String, OldPii>)ImmutableMap.of((Object)"key1", (Object)new OldPii("345"), (Object)"key2", (Object)new OldPii("678")));
        Schema schema = this.createWidgetSchema();
        AvroSchema avroSchema = new AvroSchema(schema);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix2\"", null, null, false);
        Rule rule2 = new Rule("myRule2", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), (List)ImmutableList.of((Object)rule, (Object)rule2));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.reflectionAvroSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.reflectionAvroDeserializer.deserialize(this.topic, bytes, schema);
        Assert.assertTrue((String)"Returned object does not match", (boolean)OldWidget.class.isInstance(obj));
        Assert.assertEquals((Object)widget, (Object)obj);
        Assert.assertEquals((Object)"alice-suffix2", (Object)((OldWidget)obj).getName());
        Assert.assertEquals((Object)"123-suffix2", (Object)((OldWidget)obj).getSsn().get(0));
        Assert.assertEquals((Object)"456-suffix2", (Object)((OldWidget)obj).getSsn().get(1));
        Assert.assertEquals((Object)"789-suffix2", (Object)((OldWidget)obj).getPiiArray().get(0).getPii());
        Assert.assertEquals((Object)"012-suffix2", (Object)((OldWidget)obj).getPiiArray().get(1).getPii());
        Assert.assertEquals((Object)"345-suffix2", (Object)((OldWidget)obj).getPiiMap().get("key1").getPii());
        Assert.assertEquals((Object)"678-suffix2", (Object)((OldWidget)obj).getPiiMap().get("key2").getPii());
    }

    @Test
    public void testKafkaAvroSerializerNewMapTransform() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "{'name': 'Bob', 'lastName': null, 'fullName': null, 'mybytes': b\"\\x00\", 'myint': 1, 'mylong': 2, 'myfloat': 3, 'mydouble': 4, 'myboolean': true, 'mynull': null, 'kind': 'TWO'}", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        GenericRecord obj = (GenericRecord)this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)"Bob", (Object)obj.get("name").toString());
        Assert.assertNull((Object)obj.get("lastName"));
        Assert.assertNull((Object)obj.get("fullName"));
        Assert.assertEquals((Object)"TWO", (Object)obj.get("kind").toString());
    }

    @Test
    public void testKafkaAvroSerializerIdentityTransform() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "message", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        GenericRecord obj = (GenericRecord)this.avroDeserializer.deserialize(this.topic, bytes);
        Assert.assertEquals((Object)avroRecord, (Object)obj);
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerBadTransform() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "message.name == \"testUser\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        this.avroSerializer.serialize(this.topic, (Object)avroRecord);
    }

    @Test(expected=SerializationException.class)
    public void testKafkaAvroSerializerNullTransform() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "null", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        this.avroSerializer.serialize(this.topic, (Object)avroRecord);
    }

    @Test
    public void testKafkaAvroSerializerStringFunctions() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord();
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.charAt(0) == 't' && message.name.indexOf('e') == 1 && [message.name,'1'].join() == 'testUser1' && message.name.lastIndexOf('e') == 6 && message.name.lowerAscii() == 'testuser' && message.name.replace('User','Customer') == 'testCustomer' && message.name.split('U') == ['test', 'ser'] && ' testUser '.trim() == 'testUser' && message.name.upperAscii() == 'TESTUSER'", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
    }

    @Test
    public void testKafkaAvroSerializerBuiltinFunctions() throws Exception {
        IndexedRecord avroRecord = this.createUserRecord("bob@confluent.com");
        AvroSchema avroSchema = new AvroSchema(avroRecord.getSchema());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.isEmail()", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        byte[] bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        IndexedRecord avroRecord2 = this.createUserRecord("bob.@confluent.com");
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)avroRecord2));
        avroRecord = this.createUserRecord("localhost");
        rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.isHostname()", null, null, false);
        ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        IndexedRecord avroRecord3 = this.createUserRecord("local_host");
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)avroRecord3));
        avroRecord = this.createUserRecord("127.0.0.1");
        rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.isIpv4()", null, null, false);
        ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        IndexedRecord avroRecord4 = this.createUserRecord("foo");
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)avroRecord4));
        avroRecord = this.createUserRecord("2001:db8:85a3:0:0:8a2e:370:7334");
        rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.isIpv6()", null, null, false);
        ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        IndexedRecord avroRecord5 = this.createUserRecord("foo");
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)avroRecord5));
        avroRecord = this.createUserRecord("http://confluent.com/index.html");
        rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.isUri()", null, null, false);
        ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        IndexedRecord avroRecord6 = this.createUserRecord("foo");
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)avroRecord6));
        avroRecord = this.createUserRecord("/index.html");
        rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.isUriRef()", null, null, false);
        ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        IndexedRecord avroRecord7 = this.createUserRecord("::foo");
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)avroRecord7));
        avroRecord = this.createUserRecord("fa02a430-892f-4160-97cd-6e3d1bc14494");
        rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name.isUuid()", null, null, false);
        ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        avroSchema = avroSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)avroSchema);
        bytes = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer.deserialize(this.topic, bytes));
        IndexedRecord avroRecord8 = this.createUserRecord("::foo");
        Assert.assertThrows(SerializationException.class, () -> this.avroSerializer.serialize(this.topic, (Object)avroRecord8));
    }

    @Test
    public void testKafkaProtobufSerializer() throws Exception {
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").setKind(WidgetProto.Kind.ONE).addSsn("123").addSsn("456").addPiiArray(WidgetProto.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name == \"alice\" && size(message.name) == 5 && message.kind == 1", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        protobufSchema = protobufSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
    }

    @Test
    public void testKafkaProtobuf2Serializer() throws Exception {
        WidgetProto2.Widget2 widget = WidgetProto2.Widget2.newBuilder().setName("alice").setKind(WidgetProto2.Kind.ONE).addSsn("123").addSsn("456").addPiiArray(WidgetProto2.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto2.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto2.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto2.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name == \"alice\" && size(message.name) == 5 && message.kind == 1", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        protobufSchema = protobufSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobuf2Serializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object should be a Widget", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object should be a NewWidget", (Object)"alice", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
    }

    @Test
    public void testKafkaProtobufSerializerFieldTransform() throws Exception {
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").addSsn("123").addSsn("456").addPiiArray(WidgetProto.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        protobufSchema = protobufSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"123-suffix", (Object)"456-suffix"), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("ssn")));
        List ssnArrayValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_array"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            return msg.getField(msg.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"789-suffix", (Object)"012-suffix"), ssnArrayValues);
        List ssnMapValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_map"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            DynamicMessage msg2 = (DynamicMessage)msg.getField(msg.getDescriptorForType().findFieldByName("value"));
            return msg2.getField(msg2.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"345-suffix", (Object)"678-suffix"), ssnMapValues);
    }

    @Test
    public void testKafkaProtobufSerializerFieldTransformExternalTag() throws Exception {
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").setLastName("smith").addSsn("123").addSsn("456").addPiiArray(WidgetProto.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = new Metadata(Collections.singletonMap("io.confluent.kafka.schemaregistry.rules.Widget.lastName", ImmutableSet.of((Object)"PII")), null, null);
        protobufSchema = protobufSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
        Assert.assertEquals((String)"Returned object does not match", (Object)"smith-suffix", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("lastName")));
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"123-suffix", (Object)"456-suffix"), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("ssn")));
        List ssnArrayValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_array"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            return msg.getField(msg.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"789-suffix", (Object)"012-suffix"), ssnArrayValues);
        List ssnMapValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_map"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            DynamicMessage msg2 = (DynamicMessage)msg.getField(msg.getDescriptorForType().findFieldByName("value"));
            return msg2.getField(msg2.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"345-suffix", (Object)"678-suffix"), ssnMapValues);
    }

    @Test
    public void testKafkaProtobufSerializerFieldTransformUsingMessage() throws Exception {
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").setLastName("smith").setMybytes(ByteString.copyFrom((byte[])new byte[]{0})).setMyint(1).setMylong(2L).setMyfloat(3.0f).setMydouble(4.0).setMyboolean(true).addSsn("123").addSsn("456").addPiiArray(WidgetProto.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"fullName\" ; value == \"\" ? message.name + \" \" + message.lastName : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule2", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mybytes\" ; value == b\"\\x00\" ? b\"\\x01\" : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule3", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myint\" ; value == 1 ? 2 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule4", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mylong\" ; value == 2 ? 3 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule5", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myfloat\" ; value == 3.0 ? 4.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule6", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mydouble\" ; value == 4.0 ? 5.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule7", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myboolean\" ; value == true ? false : value", null, null, false);
        rules.add(rule);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), rules);
        protobufSchema = protobufSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice smith", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("fullName")));
        Assert.assertEquals((String)"Returned object does not match", (Object)ByteString.copyFrom((byte[])new byte[]{1}), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("mybytes")));
        Assert.assertEquals((String)"Returned object does not match", (Object)2, (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("myint")));
        Assert.assertEquals((String)"Returned object does not match", (Object)3L, (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("mylong")));
        Assert.assertEquals((String)"Returned object does not match", (double)4.0, (double)((Float)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("myfloat"))).floatValue(), (double)0.1);
        Assert.assertEquals((String)"Returned object does not match", (double)5.0, (double)((Double)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("mydouble"))), (double)0.1);
        Assert.assertFalse((String)"Returned object does not match", (boolean)((Boolean)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("myboolean"))));
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"123", (Object)"456"), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("ssn")));
        List ssnArrayValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_array"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            return msg.getField(msg.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"789", (Object)"012"), ssnArrayValues);
        List ssnMapValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_map"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            DynamicMessage msg2 = (DynamicMessage)msg.getField(msg.getDescriptorForType().findFieldByName("value"));
            return msg2.getField(msg2.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"345", (Object)"678"), ssnMapValues);
    }

    @Test
    public void testKafkaProtobufSerializerFieldTransformWithRef() throws Exception {
        this.schemaRegistry.register("Pii.proto", (ParsedSchema)new ProtobufSchema(PiiProto.Pii.getDescriptor()).copy(Integer.valueOf(1)));
        WidgetWithRefProto.WidgetWithRef widget = WidgetWithRefProto.WidgetWithRef.newBuilder().setName("alice").addSsn("123").addSsn("456").addPiiArray(PiiProto.Pii.newBuilder().setPii("789").build()).addPiiArray(PiiProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", PiiProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", PiiProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        List<SchemaReference> refs = Collections.singletonList(new SchemaReference("Pii.proto", "Pii.proto", Integer.valueOf(1)));
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType(), refs);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        protobufSchema = protobufSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufWithRefSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"123-suffix", (Object)"456-suffix"), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("ssn")));
        List ssnArrayValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_array"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            return msg.getField(msg.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"789-suffix", (Object)"012-suffix"), ssnArrayValues);
        List ssnMapValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_map"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            DynamicMessage msg2 = (DynamicMessage)msg.getField(msg.getDescriptorForType().findFieldByName("value"));
            return msg2.getField(msg2.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"345-suffix", (Object)"678-suffix"), ssnMapValues);
    }

    @Test
    public void testKafkaProtobufSerializerNewMessageTransform() throws Exception {
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").addSsn("123").addSsn("456").addPiiArray(WidgetProto.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "io.confluent.kafka.schemaregistry.rules.Widget{ name: \"Bob\" }", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        protobufSchema = protobufSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object does not match", (Object)"Bob", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
    }

    @Test
    public void testKafkaProtobufSerializerIdentityTransform() throws Exception {
        WidgetProto.Widget widget = WidgetProto.Widget.newBuilder().setName("alice").addSsn("123").addSsn("456").addPiiArray(WidgetProto.Pii.newBuilder().setPii("789").build()).addPiiArray(WidgetProto.Pii.newBuilder().setPii("012").build()).putPiiMap("key1", WidgetProto.Pii.newBuilder().setPii("345").build()).putPiiMap("key2", WidgetProto.Pii.newBuilder().setPii("678").build()).setSize(123).build();
        ProtobufSchema protobufSchema = new ProtobufSchema(widget.getDescriptorForType());
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "message", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        protobufSchema = protobufSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)protobufSchema);
        byte[] bytes = this.protobufSerializer.serialize(this.topic, (Message)widget);
        Message obj = this.protobufDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)DynamicMessage.class.isInstance(obj));
        DynamicMessage dynamicMessage = (DynamicMessage)obj;
        Descriptors.Descriptor dynamicDesc = dynamicMessage.getDescriptorForType();
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("name")));
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"123", (Object)"456"), (Object)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("ssn")));
        List ssnArrayValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_array"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            return msg.getField(msg.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"789", (Object)"012"), ssnArrayValues);
        List ssnMapValues = ((List)((DynamicMessage)obj).getField(dynamicDesc.findFieldByName("pii_map"))).stream().map(o -> {
            DynamicMessage msg = (DynamicMessage)o;
            DynamicMessage msg2 = (DynamicMessage)msg.getField(msg.getDescriptorForType().findFieldByName("value"));
            return msg2.getField(msg2.getDescriptorForType().findFieldByName("pii")).toString();
        }).collect(Collectors.toList());
        Assert.assertEquals((String)"Returned object does not match", (Object)ImmutableList.of((Object)"345", (Object)"678"), ssnMapValues);
    }

    @Test
    public void testKafkaJsonSchemaSerializer() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name == \"alice\" && size(message.name) == 5", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerFieldTransform() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"123-suffix", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"456-suffix", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"789-suffix", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"012-suffix", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerFieldTransformExternalTag() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("smith");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        Metadata metadata = new Metadata(Collections.singletonMap("$.lastName", ImmutableSet.of((Object)"PII")), null, null);
        jsonSchema = jsonSchema.copy(metadata, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"smith-suffix", (Object)((JsonNode)obj).get("lastName").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"123-suffix", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"456-suffix", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"789-suffix", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"012-suffix", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerFieldTransformUsingMessage() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("smith");
        widget.setMyint(1);
        widget.setMylong(2L);
        widget.setMyfloat(3.0f);
        widget.setMydouble(4.0);
        widget.setMyboolean(true);
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"fullName\" ; dyn(value) == null ? message.name + \" \" + message.lastName : dyn(value)", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule3", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myint\" ; value == 1 ? 2 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule4", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mylong\" ; value == 2 ? 3 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule5", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myfloat\" ; value == 3.0 ? 4.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule6", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mydouble\" ; value == 4.0 ? 5.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule7", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myboolean\" ; value == true ? false : value", null, null, false);
        rules.add(rule);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), rules);
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice smith", (Object)((JsonNode)obj).get("fullName").textValue());
        Assert.assertEquals((String)"Returned object does not match", (long)2L, (long)((JsonNode)obj).get("myint").intValue());
        Assert.assertEquals((String)"Returned object does not match", (long)3L, (long)((JsonNode)obj).get("mylong").longValue());
        Assert.assertEquals((String)"Returned object does not match", (double)4.0, (double)((JsonNode)obj).get("myfloat").floatValue(), (double)0.1);
        Assert.assertEquals((String)"Returned object does not match", (double)5.0, (double)((JsonNode)obj).get("mydouble").doubleValue(), (double)0.1);
        Assert.assertFalse((String)"Returned object does not match", (boolean)((JsonNode)obj).get("myboolean").booleanValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"123", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"456", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"789", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"012", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerFieldTransformWithRef() throws Exception {
        String refStr = "{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}";
        this.schemaRegistry.register("OldPii.json", (ParsedSchema)new JsonSchema(refStr).copy(Integer.valueOf(1)));
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"OldPii.json\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"OldPii.json\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"]}";
        List<SchemaReference> refs = Collections.singletonList(new SchemaReference("OldPii.json", "OldPii.json", Integer.valueOf(1)));
        Map<String, String> resolvedRefs = Collections.singletonMap("OldPii.json", refStr);
        JsonSchema jsonSchema = new JsonSchema(schemaStr, refs, resolvedRefs, null);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"123-suffix", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"456-suffix", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"789-suffix", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"012-suffix", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerAnnotatedFieldTransform() throws Exception {
        AnnotatedOldWidget widget = new AnnotatedOldWidget("alice");
        widget.setSize(123);
        widget.setAnnotatedSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<AnnotatedOldPii>)ImmutableList.of((Object)new AnnotatedOldPii("789"), (Object)new AnnotatedOldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer2.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"123-suffix", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"456-suffix", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"789-suffix", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"012-suffix", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerNewMapTransform() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "{'name': 'Bob'}", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"Bob", (Object)((JsonNode)obj).get("name").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerIdentityTransform() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL", null, null, "message", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        byte[] bytes = this.jsonSchemaSerializer.serialize(this.topic, (Object)widget);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerJsonNode() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.CONDITION, RuleMode.WRITEREAD, "CEL", null, null, "message.name == \"alice\" && size(message.name) == 5", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        JsonNode jsonNode = mapper.valueToTree((Object)widget);
        ObjectNode objectNode = JsonSchemaUtils.envelope((JsonSchema)jsonSchema, (JsonNode)jsonNode);
        byte[] bytes = this.jsonSchemaSerializer3.serialize(this.topic, (Object)objectNode);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerJsonNodeFieldTransform() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", (Set)ImmutableSortedSet.of((Comparable)((Object)"PII")), null, "value + \"-suffix\"", null, null, false);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), Collections.singletonList(rule));
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        JsonNode jsonNode = mapper.valueToTree((Object)widget);
        ObjectNode objectNode = JsonSchemaUtils.envelope((JsonSchema)jsonSchema, (JsonNode)jsonNode);
        byte[] bytes = this.jsonSchemaSerializer3.serialize(this.topic, (Object)objectNode);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice-suffix", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"123-suffix", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"456-suffix", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"789-suffix", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"012-suffix", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    @Test
    public void testKafkaJsonSchemaSerializerJsonNodeFieldTransformUsingMessage() throws Exception {
        OldWidget widget = new OldWidget("alice");
        widget.setLastName("smith");
        widget.setMyint(1);
        widget.setMylong(2L);
        widget.setMyfloat(3.0f);
        widget.setMydouble(4.0);
        widget.setMyboolean(true);
        widget.setSize(123);
        widget.setSsn((List<String>)ImmutableList.of((Object)"123", (Object)"456"));
        widget.setPiiArray((List<OldPii>)ImmutableList.of((Object)new OldPii("789"), (Object)new OldPii("012")));
        String schemaStr = "{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Old Widget\",\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\n\"name\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]},\"lastName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"fullName\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}]},\"myint\":{\"type\":\"integer\"},\"mylong\":{\"type\":\"integer\"},\"myfloat\":{\"type\":\"number\"},\"mydouble\":{\"type\":\"number\"},\"myboolean\":{\"type\":\"boolean\"},\"ssn\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"type\":\"string\"}}],\"confluent:tags\": [ \"PII\" ]},\"piiArray\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"piiMap\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"object\",\"additionalProperties\":{\"$ref\":\"#/definitions/OldPii\"}}]},\"size\":{\"type\":\"integer\"},\"version\":{\"type\":\"integer\"}},\"required\":[\"size\",\"version\"],\"definitions\":{\"OldPii\":{\"type\":\"object\",\"additionalProperties\":false,\"properties\":{\"pii\":{\"oneOf\":[{\"type\":\"null\",\"title\":\"Not included\"},{\"type\":\"string\"}],\"confluent:tags\": [ \"PII\" ]}}}}}";
        JsonSchema jsonSchema = new JsonSchema(schemaStr);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = new Rule("myRule", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"fullName\" ; dyn(value) == null ? message.name + \" \" + message.lastName : dyn(value)", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule3", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myint\" ; value == 1 ? 2 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule4", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mylong\" ; value == 2 ? 3 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule5", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myfloat\" ; value == 3.0 ? 4.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule6", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"mydouble\" ; value == 4.0 ? 5.0 : value", null, null, false);
        rules.add(rule);
        rule = new Rule("myRule7", null, RuleKind.TRANSFORM, RuleMode.WRITE, "CEL_FIELD", null, null, "name == \"myboolean\" ; value == true ? false : value", null, null, false);
        rules.add(rule);
        RuleSet ruleSet = new RuleSet(Collections.emptyList(), rules);
        jsonSchema = jsonSchema.copy(null, ruleSet);
        this.schemaRegistry.register(this.topic + "-value", (ParsedSchema)jsonSchema);
        JsonNode jsonNode = mapper.valueToTree((Object)widget);
        ObjectNode objectNode = JsonSchemaUtils.envelope((JsonSchema)jsonSchema, (JsonNode)jsonNode);
        byte[] bytes = this.jsonSchemaSerializer3.serialize(this.topic, (Object)objectNode);
        Object obj = this.jsonSchemaDeserializer.deserialize(this.topic, bytes);
        Assert.assertTrue((String)"Returned object does not match", (boolean)JsonNode.class.isInstance(obj));
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice", (Object)((JsonNode)obj).get("name").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"alice smith", (Object)((JsonNode)obj).get("fullName").textValue());
        Assert.assertEquals((String)"Returned object does not match", (long)2L, (long)((JsonNode)obj).get("myint").intValue());
        Assert.assertEquals((String)"Returned object does not match", (long)3L, (long)((JsonNode)obj).get("mylong").longValue());
        Assert.assertEquals((String)"Returned object does not match", (double)4.0, (double)((JsonNode)obj).get("myfloat").floatValue(), (double)0.1);
        Assert.assertEquals((String)"Returned object does not match", (double)5.0, (double)((JsonNode)obj).get("mydouble").doubleValue(), (double)0.1);
        Assert.assertFalse((String)"Returned object does not match", (boolean)((JsonNode)obj).get("myboolean").booleanValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"123", (Object)((JsonNode)obj).get("ssn").get(0).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"456", (Object)((JsonNode)obj).get("ssn").get(1).textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"789", (Object)((JsonNode)obj).get("piiArray").get(0).get("pii").textValue());
        Assert.assertEquals((String)"Returned object does not match", (Object)"012", (Object)((JsonNode)obj).get("piiArray").get(1).get("pii").textValue());
    }

    public static class AnnotatedOldPii {
        @JsonProperty(value="pii")
        private String annotatedPii;

        public AnnotatedOldPii() {
        }

        public AnnotatedOldPii(String annotatedPii) {
            this.annotatedPii = annotatedPii;
        }

        public String getAnnotatedPii() {
            return this.annotatedPii;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotatedOldPii pii1 = (AnnotatedOldPii)o;
            return Objects.equals(this.annotatedPii, pii1.annotatedPii);
        }

        public int hashCode() {
            return Objects.hash(this.annotatedPii);
        }
    }

    public static class AnnotatedOldWidget {
        private String annotatedName;
        private List<String> annotatedSsn = new ArrayList<String>();
        private List<AnnotatedOldPii> piiArray = new ArrayList<AnnotatedOldPii>();
        private Map<String, AnnotatedOldPii> piiMap = new HashMap<String, AnnotatedOldPii>();
        private int size;
        private int version;

        public AnnotatedOldWidget() {
        }

        public AnnotatedOldWidget(String annotatedName) {
            this.annotatedName = annotatedName;
        }

        @JsonProperty(value="name")
        public String getAnnotatedName() {
            return this.annotatedName;
        }

        @JsonProperty(value="name")
        public void setAnnotatedName(String name) {
            this.annotatedName = name;
        }

        @JsonProperty(value="ssn")
        public List<String> getAnnotatedSsn() {
            return this.annotatedSsn;
        }

        @JsonProperty(value="ssn")
        public void setAnnotatedSsn(List<String> ssn) {
            this.annotatedSsn = ssn;
        }

        public List<AnnotatedOldPii> getPiiArray() {
            return this.piiArray;
        }

        public void setPiiArray(List<AnnotatedOldPii> pii) {
            this.piiArray = pii;
        }

        public Map<String, AnnotatedOldPii> getPiiMap() {
            return this.piiMap;
        }

        public void setPiiMap(Map<String, AnnotatedOldPii> pii) {
            this.piiMap = pii;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldWidget widget = (OldWidget)o;
            return this.annotatedName.equals(widget.name) && Objects.equals(this.annotatedSsn, widget.ssn) && Objects.equals(this.piiArray, widget.piiArray) && Objects.equals(this.piiMap, widget.piiMap) && this.size == widget.size && this.version == widget.version;
        }

        public int hashCode() {
            return Objects.hash(this.annotatedName, this.annotatedSsn, this.piiArray, this.piiMap, this.size, this.version);
        }
    }

    public static class OldPii {
        private String pii;

        public OldPii() {
        }

        public OldPii(String pii) {
            this.pii = pii;
        }

        public String getPii() {
            return this.pii;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldPii pii1 = (OldPii)o;
            return Objects.equals(this.pii, pii1.pii);
        }

        public int hashCode() {
            return Objects.hash(this.pii);
        }
    }

    public static class OldWidget {
        private String name;
        private String lastName;
        private String fullName;
        private int myint;
        private long mylong;
        private float myfloat;
        private double mydouble;
        private boolean myboolean;
        private List<String> ssn = new ArrayList<String>();
        private List<OldPii> piiArray = new ArrayList<OldPii>();
        private Map<String, OldPii> piiMap = new HashMap<String, OldPii>();
        private int size;
        private int version;

        public OldWidget() {
        }

        public OldWidget(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public int getMyint() {
            return this.myint;
        }

        public void setMyint(int myint) {
            this.myint = myint;
        }

        public long getMylong() {
            return this.mylong;
        }

        public void setMylong(long mylong) {
            this.mylong = mylong;
        }

        public float getMyfloat() {
            return this.myfloat;
        }

        public void setMyfloat(float myfloat) {
            this.myfloat = myfloat;
        }

        public double getMydouble() {
            return this.mydouble;
        }

        public void setMydouble(double mydouble) {
            this.mydouble = mydouble;
        }

        public boolean isMyboolean() {
            return this.myboolean;
        }

        public void setMyboolean(boolean myboolean) {
            this.myboolean = myboolean;
        }

        public List<String> getSsn() {
            return this.ssn;
        }

        public void setSsn(List<String> ssn) {
            this.ssn = ssn;
        }

        public List<OldPii> getPiiArray() {
            return this.piiArray;
        }

        public void setPiiArray(List<OldPii> pii) {
            this.piiArray = pii;
        }

        public Map<String, OldPii> getPiiMap() {
            return this.piiMap;
        }

        public void setPiiMap(Map<String, OldPii> pii) {
            this.piiMap = pii;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldWidget widget = (OldWidget)o;
            return this.name.equals(widget.name) && Objects.equals(this.ssn, widget.ssn) && Objects.equals(this.piiArray, widget.piiArray) && Objects.equals(this.piiMap, widget.piiMap) && this.size == widget.size && this.version == widget.version;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.ssn, this.piiArray, this.piiMap, this.size, this.version);
        }
    }
}

