/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules.cel.avro;

import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import example.avro.Kind;
import example.avro.User;
import io.confluent.kafka.schemaregistry.rules.cel.avro.AvroRegistry;
import java.util.Collections;
import org.apache.avro.generic.GenericData;
import org.junit.Assert;
import org.junit.Test;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.tools.Script;
import org.projectnessie.cel.tools.ScriptHost;

public class AvroScriptHostTest {
    @Test
    public void testSimple() throws Exception {
        ScriptHost scriptHost = ScriptHost.newBuilder().registry(AvroRegistry.newRegistry()).build();
        Script script = scriptHost.buildScript("user.name == 'foobar' && user.kind == \"TWO\"").withDeclarations(new Decl[]{Decls.newVar((String)"user", (Type)Decls.newObjectType((String)User.SCHEMA$.getFullName()))}).withTypes(new Object[]{User.SCHEMA$}).build();
        User userMatch = new User("foobar", Collections.emptyList(), Kind.TWO);
        User userNoMatch = new User("foobaz", Collections.emptyList(), Kind.THREE);
        Assert.assertTrue((boolean)((Boolean)script.execute(Boolean.class, Collections.singletonMap("user", userMatch))));
        Assert.assertFalse((boolean)((Boolean)script.execute(Boolean.class, Collections.singletonMap("user", userNoMatch))));
        GenericData.Record userMatch2 = new GenericData.Record(User.SCHEMA$);
        userMatch2.put("name", (Object)"foobar");
        userMatch2.put("kind", (Object)new GenericData.EnumSymbol(Kind.SCHEMA$, "TWO"));
        GenericData.Record userNoMatch2 = new GenericData.Record(User.SCHEMA$);
        userNoMatch2.put("name", (Object)"foobaz");
        userNoMatch2.put("kind", (Object)new GenericData.EnumSymbol(Kind.SCHEMA$, "THREE"));
        Assert.assertTrue((boolean)((Boolean)script.execute(Boolean.class, Collections.singletonMap("user", userMatch2))));
        Assert.assertFalse((boolean)((Boolean)script.execute(Boolean.class, Collections.singletonMap("user", userNoMatch2))));
    }

    @Test
    public void testComplexInput() throws Exception {
        ScriptHost scriptHost = ScriptHost.newBuilder().registry(AvroRegistry.newRegistry()).build();
        Script script = scriptHost.buildScript("user.friends[0].kind == \"TWO\"").withDeclarations(new Decl[]{Decls.newVar((String)"user", (Type)Decls.newObjectType((String)User.SCHEMA$.getFullName()))}).withTypes(new Object[]{User.SCHEMA$}).build();
        User friend = new User("friend", Collections.emptyList(), Kind.TWO);
        User user = new User("foobar", Collections.singletonList(friend), Kind.ONE);
        Assert.assertTrue((boolean)((Boolean)script.execute(Boolean.class, Collections.singletonMap("user", user))));
        GenericData.Record friend2 = new GenericData.Record(User.SCHEMA$);
        friend2.put("name", (Object)"friend");
        friend2.put("kind", (Object)new GenericData.EnumSymbol(Kind.SCHEMA$, "TWO"));
        GenericData.Record user2 = new GenericData.Record(User.SCHEMA$);
        user2.put("name", (Object)"foobar");
        user2.put("kind", (Object)new GenericData.EnumSymbol(Kind.SCHEMA$, "ONE"));
        user2.put("friends", Collections.singletonList(friend));
        Assert.assertTrue((boolean)((Boolean)script.execute(Boolean.class, Collections.singletonMap("user", user2))));
        script = scriptHost.buildScript("user.friends[0].kind").withDeclarations(new Decl[]{Decls.newVar((String)"user", (Type)Decls.newObjectType((String)User.SCHEMA$.getFullName()))}).withTypes(new Object[]{User.SCHEMA$}).build();
        Assert.assertEquals((Object)script.execute(String.class, Collections.singletonMap("user", user)), (Object)"TWO");
        Assert.assertEquals((Object)script.execute(String.class, Collections.singletonMap("user", user2)), (Object)"TWO");
    }
}

