/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rules.RuleBase;
import io.confluent.kafka.schemaregistry.rules.cel.CelExecutor;
import io.confluent.kafka.schemaregistry.rules.cel.CelFieldExecutor;
import io.confluent.kafka.schemaregistry.rules.jsonata.JsonataExecutor;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.modules.junit4.PowerMockRunner;

@PowerMockIgnore(value={"javax.management.*", "javax.xml.*", "org.apache.xerces.*", "org.w3c.*", "javax.security.*", "javax.net.ssl.*"})
@PrepareForTest(value={UserGroupInformation.class})
@RunWith(value=PowerMockRunner.class)
@SuppressStaticInitializationFor(value={"com.mapr.baseutils.JVMProperties"})
public class RuleServiceLoaderTest {
    private SchemaRegistryClient schemaRegistry;
    private KafkaAvroSerializer avroSerializer;
    private String topic;

    @Before
    public void setup() throws IOException {
        this.topic = "test";
        this.schemaRegistry = new MockSchemaRegistryClient((List)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()));
        HashMap<String, String> defaultConfig = new HashMap<String, String>();
        defaultConfig.put("schema.registry.url", "bogus");
        defaultConfig.put("auto.register.schemas", "false");
        defaultConfig.put("use.latest.version", "true");
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, defaultConfig);
    }

    @Test
    public void testSuccess() {
        this.assertInstance((RuleBase)((Map)this.avroSerializer.getRuleExecutors().get("CEL")).get("_default_"), CelExecutor.class);
        this.assertInstance((RuleBase)((Map)this.avroSerializer.getRuleExecutors().get("CEL_FIELD")).get("_default_"), CelFieldExecutor.class);
        this.assertInstance((RuleBase)((Map)this.avroSerializer.getRuleExecutors().get("JSONATA")).get("_default_"), JsonataExecutor.class);
    }

    public void assertInstance(RuleBase instance, Class<? extends RuleBase> klass) {
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(klass, instance.getClass());
    }
}

