/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.LookupCache;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.Comparator;

public class SubjectKeyComparator<K>
implements Comparator<K> {
    private final LookupCache<K, ?> lookupCache;

    public SubjectKeyComparator() {
        this.lookupCache = null;
    }

    public SubjectKeyComparator(LookupCache<K, ?> lookupCache) {
        this.lookupCache = lookupCache;
    }

    @Override
    public int compare(K o1, K o2) {
        if (o1 instanceof SubjectKey && o2 instanceof SubjectKey) {
            SubjectKey s1 = (SubjectKey)o1;
            SubjectKey s2 = (SubjectKey)o2;
            int cmp = s1.keyType.compareTo(s2.keyType);
            if (cmp != 0) {
                return cmp;
            }
            String tenant = this.lookupCache != null ? this.lookupCache.tenant() : null;
            QualifiedSubject qs1 = QualifiedSubject.create((String)tenant, (String)s1.getSubject());
            QualifiedSubject qs2 = QualifiedSubject.create((String)tenant, (String)s2.getSubject());
            if (qs1 == null && qs2 == null) {
                return 0;
            }
            if (qs1 == null) {
                return -1;
            }
            if (qs2 == null) {
                return 1;
            }
            cmp = qs1.compareTo(qs2);
            if (cmp != 0) {
                return cmp;
            }
            if (s1 instanceof SchemaKey && s2 instanceof SchemaKey) {
                SchemaKey sk1 = (SchemaKey)o1;
                SchemaKey sk2 = (SchemaKey)o2;
                return sk1.getVersion() - sk2.getVersion();
            }
            return 0;
        }
        return ((Comparable)o1).compareTo(o2);
    }
}

