/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.Store;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import java.util.Map;
import java.util.Set;

public interface LookupCache<K, V>
extends Store<K, V> {
    public SchemaIdAndSubjects schemaIdAndSubjects(Schema var1) throws StoreException;

    public boolean containsSchema(Schema var1) throws StoreException;

    public Set<Integer> referencesSchema(SchemaKey var1) throws StoreException;

    public SchemaKey schemaKeyById(Integer var1, String var2) throws StoreException;

    public void schemaRegistered(SchemaKey var1, SchemaValue var2, SchemaValue var3);

    public void schemaDeleted(SchemaKey var1, SchemaValue var2, SchemaValue var3);

    public void schemaTombstoned(SchemaKey var1, SchemaValue var2);

    default public CompatibilityLevel compatibilityLevel(String subject, boolean returnTopLevelIfNotFound, CompatibilityLevel defaultForTopLevel) throws StoreException {
        Config config = this.config(subject, returnTopLevelIfNotFound, new Config(defaultForTopLevel.name));
        return CompatibilityLevel.forName((String)config.getCompatibilityLevel());
    }

    public Config config(String var1, boolean var2, Config var3) throws StoreException;

    public Mode mode(String var1, boolean var2, Mode var3) throws StoreException;

    public Set<String> subjects(String var1, boolean var2) throws StoreException;

    public boolean hasSubjects(String var1, boolean var2) throws StoreException;

    public Map<String, Integer> clearSubjects(String var1) throws StoreException;

    default public String tenant() {
        return "default";
    }

    default public void setTenant(String tenant) {
    }
}

