/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.filter.AuthorizationFilterProvider;
import io.confluent.kafka.schemaregistry.rest.JsonErrorHandler;
import io.confluent.kafka.schemaregistry.rest.RequestIdHandler;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.rest.filters.AliasFilter;
import io.confluent.kafka.schemaregistry.rest.filters.ContextFilter;
import io.confluent.kafka.schemaregistry.rest.filters.RestCallMetricFilter;
import io.confluent.kafka.schemaregistry.rest.resources.CompatibilityResource;
import io.confluent.kafka.schemaregistry.rest.resources.ConfigResource;
import io.confluent.kafka.schemaregistry.rest.resources.ContextsResource;
import io.confluent.kafka.schemaregistry.rest.resources.ModeResource;
import io.confluent.kafka.schemaregistry.rest.resources.RootResource;
import io.confluent.kafka.schemaregistry.rest.resources.SchemasResource;
import io.confluent.kafka.schemaregistry.rest.resources.ServerMetadataResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectVersionsResource;
import io.confluent.kafka.schemaregistry.rest.resources.SubjectsResource;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.kafka.schemaregistry.util.MaprFSUtils;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryRestApplication
extends Application<SchemaRegistryConfig> {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryRestApplication.class);
    private KafkaSchemaRegistry schemaRegistry = null;

    public SchemaRegistryRestApplication(Properties props) throws RestConfigException {
        this(new SchemaRegistryConfig(props));
    }

    protected void configurePreResourceHandling(ServletContextHandler context) {
        super.configurePreResourceHandling(context);
        context.setErrorHandler((ErrorHandler)new JsonErrorHandler());
        context.insertHandler((HandlerWrapper)new RequestIdHandler());
    }

    public SchemaRegistryRestApplication(SchemaRegistryConfig config) {
        super((RestConfig)config);
        MaprFSUtils.createKafkaStoreInternalStreamIfNotExist(config);
    }

    protected KafkaSchemaRegistry initSchemaRegistry(SchemaRegistryConfig config) {
        KafkaSchemaRegistry kafkaSchemaRegistry = null;
        try {
            kafkaSchemaRegistry = new KafkaSchemaRegistry(config, new SchemaRegistrySerializer());
            kafkaSchemaRegistry.init();
        }
        catch (SchemaRegistryException e) {
            log.error("Error starting the schema registry", (Throwable)e);
            this.onShutdown();
            System.exit(1);
        }
        return kafkaSchemaRegistry;
    }

    public void postServerStart() {
        try {
            this.schemaRegistry.postInit();
        }
        catch (SchemaRegistryException e) {
            log.error("Error starting the schema registry", (Throwable)e);
            System.exit(1);
        }
    }

    public void configureBaseApplication(Configurable<?> config, Map<String, String> metricTags) {
        super.configureBaseApplication(config, metricTags);
        SchemaRegistryConfig schemaRegistryConfig = (SchemaRegistryConfig)this.getConfiguration();
        this.registerInitResourceExtensions(config, schemaRegistryConfig);
        this.schemaRegistry = this.initSchemaRegistry(schemaRegistryConfig);
    }

    public void setupResources(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig) {
        config.register(RootResource.class);
        config.register((Object)new ConfigResource(this.schemaRegistry));
        config.register((Object)new ContextsResource(this.schemaRegistry));
        config.register((Object)new SubjectsResource(this.schemaRegistry));
        config.register((Object)new SchemasResource(this.schemaRegistry));
        config.register((Object)new SubjectVersionsResource(this.schemaRegistry));
        config.register((Object)new CompatibilityResource(this.schemaRegistry));
        config.register((Object)new ModeResource(this.schemaRegistry));
        config.register((Object)new ServerMetadataResource(this.schemaRegistry));
        config.register((Object)new ContextFilter());
        config.register((Object)new AliasFilter(this.schemaRegistry));
        config.register((Object)new RestCallMetricFilter(this.schemaRegistry.getMetricsContainer().getApiCallsSuccess(), this.schemaRegistry.getMetricsContainer().getApiCallsFailure()));
        List<SchemaRegistryResourceExtension> schemaRegistryResourceExtensions = this.schemaRegistry.getResourceExtensions();
        if (schemaRegistryConfig.getBoolean("authorization.enable").booleanValue()) {
            if (schemaRegistryConfig.getBoolean("authentication.enable").booleanValue()) {
                config.register((Object)AuthorizationFilterProvider.configure(schemaRegistryConfig));
            } else {
                log.error("Error starting the schema registry: Authorization is not allowed without authentication. Configure {}=true", (Object)"authentication.enable");
                System.exit(1);
            }
        }
        if (schemaRegistryConfig.getBoolean("impersonation.enable").booleanValue() && !schemaRegistryConfig.getBoolean("authentication.enable").booleanValue()) {
            log.error("Error starting the schema registry: Impersonation is not allowed without authentication. Configure {}=true", (Object)"authentication.enable");
            System.exit(1);
        }
        if (schemaRegistryResourceExtensions != null) {
            try {
                for (SchemaRegistryResourceExtension schemaRegistryResourceExtension : schemaRegistryResourceExtensions) {
                    schemaRegistryResourceExtension.register(config, schemaRegistryConfig, this.schemaRegistry);
                }
            }
            catch (SchemaRegistryException e) {
                log.error("Error starting the schema registry", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public void registerInitResourceExtensions(Configurable<?> config, SchemaRegistryConfig schemaRegistryConfig) {
        List preInitResourceExtensions = schemaRegistryConfig.getConfiguredInstances("init.resource.extension.class", SchemaRegistryResourceExtension.class);
        boolean fipsExtensionProvided = false;
        String fipsResourceExtensionClassName = "io.confluent.kafka.schemaregistry.security.SchemaRegistryFipsResourceExtension";
        if (preInitResourceExtensions != null) {
            try {
                for (SchemaRegistryResourceExtension schemaRegistryResourceExtension : preInitResourceExtensions) {
                    schemaRegistryResourceExtension.register(config, schemaRegistryConfig, this.schemaRegistry);
                    if (!"io.confluent.kafka.schemaregistry.security.SchemaRegistryFipsResourceExtension".equals(schemaRegistryResourceExtension.getClass().getCanonicalName())) continue;
                    fipsExtensionProvided = true;
                }
            }
            catch (SchemaRegistryException e) {
                log.error("Error starting the schema registry resource extension", (Throwable)e);
                System.exit(1);
            }
        }
        if (schemaRegistryConfig.getBoolean("enable.fips").booleanValue() && !fipsExtensionProvided) {
            log.error("Error enabling the FIPS resource extension: `enable.fips` is set to true but the `init.resource.extension.class` config is either not configured or does not contain \"io.confluent.kafka.schemaregistry.security.SchemaRegistryFipsResourceExtension\"");
            System.exit(1);
        }
    }

    protected ResourceCollection getStaticResources() {
        List<String> locations = ((SchemaRegistryConfig)this.config).getStaticLocations();
        if (locations != null && !locations.isEmpty()) {
            Resource[] resources = (Resource[])locations.stream().map(Resource::newClassPathResource).toArray(Resource[]::new);
            return new ResourceCollection(resources);
        }
        return super.getStaticResources();
    }

    public void onShutdown() {
        if (this.schemaRegistry == null) {
            return;
        }
        try {
            this.schemaRegistry.close();
        }
        catch (IOException e) {
            log.error("Error closing schema registry", (Throwable)e);
        }
        List<SchemaRegistryResourceExtension> schemaRegistryResourceExtensions = this.schemaRegistry.getResourceExtensions();
        if (schemaRegistryResourceExtensions != null) {
            for (SchemaRegistryResourceExtension schemaRegistryResourceExtension : schemaRegistryResourceExtensions) {
                try {
                    schemaRegistryResourceExtension.close();
                }
                catch (IOException e) {
                    log.error("Error closing the extension resource", (Throwable)e);
                }
            }
        }
    }

    public KafkaSchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }
}

