/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.leaderelector.kafka;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.GenericSRCoordinator;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryProtocol;
import io.confluent.kafka.schemaregistry.leaderelector.kafka.SchemaRegistryRebalanceListener;
import io.confluent.kafka.schemaregistry.metrics.SchemaRegistryMetric;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryIdentity;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.internals.AbstractCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SchemaRegistryCoordinator
extends AbstractCoordinator
implements Closeable,
GenericSRCoordinator {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryCoordinator.class);
    public static final String SR_SUBPROTOCOL_V0 = "v0";
    private final SchemaRegistryIdentity identity;
    private SchemaRegistryProtocol.Assignment assignmentSnapshot;
    private final SchemaRegistryRebalanceListener listener;
    private final SchemaRegistryMetric nodeCountMetric;
    private final boolean stickyLeaderElection;

    public SchemaRegistryCoordinator(LogContext logContext, ConsumerNetworkClient client, String groupId, int rebalanceTimeoutMs, int sessionTimeoutMs, int heartbeatIntervalMs, Metrics metrics, String metricGrpPrefix, Time time, long retryBackoffMs, SchemaRegistryIdentity identity, SchemaRegistryRebalanceListener listener, SchemaRegistryMetric nodeCountMetric, boolean stickyLeaderElection) {
        super(new GroupRebalanceConfig(sessionTimeoutMs, rebalanceTimeoutMs, heartbeatIntervalMs, groupId, Optional.empty(), retryBackoffMs, true), logContext, client, metrics, metricGrpPrefix, time);
        this.identity = identity;
        this.assignmentSnapshot = null;
        this.listener = listener;
        this.nodeCountMetric = nodeCountMetric;
        this.stickyLeaderElection = stickyLeaderElection;
    }

    public String protocolType() {
        return "sr";
    }

    @Override
    public void poll(long timeout) {
        long elapsed;
        long remaining;
        long start;
        long now = start = this.time.milliseconds();
        do {
            if (this.coordinatorUnknown()) {
                this.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
                now = this.time.milliseconds();
            }
            if (this.rejoinNeededOrPending()) {
                this.ensureActiveGroup();
                now = this.time.milliseconds();
            }
            this.pollHeartbeat(now);
            elapsed = now - start;
            remaining = timeout - elapsed;
            this.client.poll(this.time.timer(Math.min(Math.max(0L, remaining), this.timeToNextHeartbeat(now))));
        } while ((remaining = timeout - (elapsed = (now = this.time.milliseconds()) - start)) > 0L);
    }

    @Override
    public void wakeup() {
        this.client.wakeup();
    }

    public JoinGroupRequestData.JoinGroupRequestProtocolCollection metadata() {
        log.info("Updating metadata");
        ByteBuffer metadata = SchemaRegistryProtocol.serializeMetadata(this.identity);
        return new JoinGroupRequestData.JoinGroupRequestProtocolCollection(Collections.singletonList(new JoinGroupRequestData.JoinGroupRequestProtocol().setName(SR_SUBPROTOCOL_V0).setMetadata(metadata.array())).iterator());
    }

    @VisibleForTesting
    public void setAssignmentSnapshot(SchemaRegistryProtocol.Assignment assignment) {
        this.assignmentSnapshot = assignment;
    }

    @VisibleForTesting
    public SchemaRegistryIdentity getIdentity() {
        return this.identity;
    }

    protected void onJoinComplete(int generation, String memberId, String protocol, ByteBuffer memberAssignment) {
        this.assignmentSnapshot = SchemaRegistryProtocol.deserializeAssignment(memberAssignment);
        if (this.stickyLeaderElection && this.assignmentSnapshot != null && this.assignmentSnapshot.leaderIdentity() != null) {
            log.info("assignmentLeaderIdentity: {}, myIdentity: {}", (Object)this.assignmentSnapshot.leaderIdentity(), (Object)this.identity);
            this.identity.setLeader(this.assignmentSnapshot.leaderIdentity().equals(this.identity));
        }
        this.listener.onAssigned(this.assignmentSnapshot, generation);
    }

    protected Map<String, ByteBuffer> onLeaderElected(String leaderElector, String protocol, List<JoinGroupResponseData.JoinGroupResponseMember> allMemberMetadata, boolean skipAssignment) {
        log.info("Performing assignment");
        HashMap<String, SchemaRegistryIdentity> memberConfigs = new HashMap<String, SchemaRegistryIdentity>();
        for (JoinGroupResponseData.JoinGroupResponseMember entry : allMemberMetadata) {
            SchemaRegistryIdentity identity = SchemaRegistryProtocol.deserializeMetadata(ByteBuffer.wrap(entry.metadata()));
            memberConfigs.put(entry.memberId(), identity);
        }
        log.info("Member information: {}", memberConfigs);
        if (this.nodeCountMetric != null) {
            this.nodeCountMetric.record(memberConfigs.size());
        }
        SchemaRegistryIdentity leaderIdentity = null;
        String leaderKafkaId = null;
        SchemaRegistryIdentity existingLeaderIdentity = null;
        String existingLeaderKafkaId = null;
        boolean multipleLeadersFound = false;
        HashSet<String> urls = new HashSet<String>();
        for (Map.Entry entry : memberConfigs.entrySet()) {
            boolean smallerIdentity;
            String kafkaMemberId = (String)entry.getKey();
            SchemaRegistryIdentity memberIdentity = (SchemaRegistryIdentity)entry.getValue();
            urls.add(memberIdentity.getUrl());
            boolean eligible = memberIdentity.getLeaderEligibility();
            boolean bl = smallerIdentity = leaderIdentity == null || memberIdentity.getUrl().compareTo(leaderIdentity.getUrl()) < 0;
            if (eligible && smallerIdentity) {
                leaderKafkaId = kafkaMemberId;
                leaderIdentity = memberIdentity;
            }
            if (!this.stickyLeaderElection || !eligible || !memberIdentity.isLeader().booleanValue() || multipleLeadersFound) continue;
            if (existingLeaderIdentity != null) {
                log.warn("Multiple leaders found in group [{}, {}].", (Object)existingLeaderIdentity, (Object)memberIdentity);
                multipleLeadersFound = true;
                existingLeaderKafkaId = null;
                existingLeaderIdentity = null;
                continue;
            }
            existingLeaderKafkaId = kafkaMemberId;
            existingLeaderIdentity = memberIdentity;
        }
        short error = 0;
        if (urls.size() != memberConfigs.size()) {
            log.error("Found duplicate URLs for schema registry group members. This indicates a misconfiguration and is common when executing in containers. Use the host.name configuration to set each instance's advertised host name to a value that is routable from all other schema registry instances.");
            error = 1;
        }
        HashMap<String, ByteBuffer> groupAssignment = new HashMap<String, ByteBuffer>();
        if (this.stickyLeaderElection && existingLeaderKafkaId != null && existingLeaderIdentity != null) {
            leaderKafkaId = existingLeaderKafkaId;
            leaderIdentity = existingLeaderIdentity;
            if (!this.identity.equals(leaderIdentity) && this.identity.isLeader().booleanValue()) {
                this.identity.setLeader(false);
            }
        }
        SchemaRegistryProtocol.Assignment assignment = new SchemaRegistryProtocol.Assignment(error, leaderKafkaId, leaderIdentity);
        log.info("Assignment: {}", (Object)assignment);
        for (String member : memberConfigs.keySet()) {
            groupAssignment.put(member, SchemaRegistryProtocol.serializeAssignment(assignment));
        }
        return groupAssignment;
    }

    protected boolean onJoinPrepare(Timer timer, int generation, String memberId) {
        if (this.assignmentSnapshot != null) {
            this.listener.onRevoked();
        }
        return true;
    }

    protected synchronized boolean ensureCoordinatorReady(Timer timer) {
        return super.ensureCoordinatorReady(timer);
    }

    protected boolean rejoinNeededOrPending() {
        return super.rejoinNeededOrPending() || this.assignmentSnapshot == null;
    }
}

