/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.utils;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import junitparams.converters.Nullable;
import org.apache.hadoop.security.UserGroupInformation;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.powermock.api.easymock.PowerMock;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.mockpolicies.MockPolicyClassLoadingSettings;
import org.powermock.mockpolicies.MockPolicyInterceptionSettings;

public class UserGroupInformationMockPolicy
implements PowerMockPolicy {
    private static final String USER_NAME = System.getProperty("user.name");
    private static AtomicReference<UserGroupInformation> currentUser = new AtomicReference();

    public void applyClassLoadingPolicy(MockPolicyClassLoadingSettings mockPolicyClassLoadingSettings) {
        mockPolicyClassLoadingSettings.addFullyQualifiedNamesOfClassesToLoadByMockClassloader(UserGroupInformation.class.getName(), new String[0]);
    }

    public void applyInterceptionPolicy(MockPolicyInterceptionSettings mockPolicyInterceptionSettings) {
        PowerMock.mockStatic(UserGroupInformation.class);
        try {
            this.stubRethrowing();
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        PowerMock.replay((Object[])new Object[]{UserGroupInformation.class});
    }

    private void stubRethrowing() throws Exception {
        UserGroupInformation loginUser = UserGroupInformationMockPolicy.stubUser(USER_NAME, null);
        EasyMock.expect((Object)UserGroupInformation.getLoginUser()).andStubReturn((Object)loginUser);
        currentUser.set(loginUser);
        EasyMock.expect((Object)UserGroupInformation.getCurrentUser()).andStubAnswer(currentUser::get);
        Capture proxyNameCapture = EasyMock.newCapture();
        Capture realCapture = EasyMock.newCapture();
        EasyMock.expect((Object)UserGroupInformation.createProxyUser((String)((String)EasyMock.capture((Capture)proxyNameCapture)), (UserGroupInformation)((UserGroupInformation)EasyMock.capture((Capture)realCapture)))).andStubAnswer(() -> UserGroupInformationMockPolicy.stubUser((String)proxyNameCapture.getValue(), (UserGroupInformation)realCapture.getValue()));
        Capture remoteNameCapture = EasyMock.newCapture();
        EasyMock.expect((Object)UserGroupInformation.createRemoteUser((String)((String)EasyMock.capture((Capture)remoteNameCapture)))).andStubAnswer(() -> UserGroupInformationMockPolicy.stubUser((String)remoteNameCapture.getValue(), null));
    }

    private static UserGroupInformation stubUser(String name, @Nullable UserGroupInformation realUser) throws IOException, InterruptedException {
        Objects.requireNonNull(name, "Null user");
        UserGroupInformation mock = (UserGroupInformation)EasyMock.mock(UserGroupInformation.class);
        EasyMock.expect((Object)mock.getUserName()).andStubReturn((Object)name);
        EasyMock.expect((Object)mock.getRealUser()).andStubReturn((Object)(realUser == null ? mock : realUser));
        Capture actionCapture = EasyMock.newCapture();
        EasyMock.expect((Object)mock.doAs((PrivilegedAction)EasyMock.capture((Capture)actionCapture))).andStubAnswer(UserGroupInformationMockPolicy.runAsUser(mock, () -> ((PrivilegedAction)actionCapture.getValue()).run()));
        Capture actionWithExceptionCapture = EasyMock.newCapture();
        EasyMock.expect((Object)mock.doAs((PrivilegedExceptionAction)EasyMock.capture((Capture)actionWithExceptionCapture))).andStubAnswer(UserGroupInformationMockPolicy.runAsUser(mock, () -> ((PrivilegedExceptionAction)actionWithExceptionCapture.getValue()).run()));
        EasyMock.replay((Object[])new Object[]{mock});
        return mock;
    }

    private static IAnswer<Object> runAsUser(UserGroupInformation mock, Callable<Object> action) {
        return () -> {
            UserGroupInformation previous = currentUser.getAndSet(mock);
            try {
                Object v = action.call();
                return v;
            }
            finally {
                currentUser.set(previous);
            }
        };
    }
}

