/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.utils.AppInfoParser;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import ns.MyRecord;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.junit.Assert;
import org.junit.Test;

public class RestApiTest
extends ClusterTestHarness {
    public RestApiTest() {
        super(1, true);
    }

    @Test
    public void testBasic() throws Exception {
        int i;
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = TestUtils.getRandomCanonicalAvroString(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = TestUtils.getRandomCanonicalAvroString(schemasInSubject2);
        ArrayList<String> allSubjects = new ArrayList<String>();
        try {
            this.restApp.restClient.getAllVersions(subject1);
            Assert.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should return default context", Collections.singletonList("."), (Object)this.restApp.restClient.getAllContexts());
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        allSubjects.add(subject1);
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, subject1);
            Assert.assertEquals((String)"Re-registering an existing schema should return the existing version", (long)expectedId, (long)foundId);
        }
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        allSubjects.add(subject2);
        Assert.assertEquals((String)"Getting all versions from subject1 should match all registered versions", allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1));
        Assert.assertEquals((String)"Getting all versions from subject2 should match all registered versions", allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2));
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        List latestSchemas = this.restApp.restClient.getSchemas(null, false, true);
        Assert.assertEquals((String)"Getting latest schemas should return two schemas", (long)2L, (long)latestSchemas.size());
        Assert.assertEquals((Object)10, (Object)((Schema)latestSchemas.get(0)).getVersion());
        Assert.assertEquals((Object)5, (Object)((Schema)latestSchemas.get(1)).getVersion());
    }

    @Test
    public void testRegisterSameSchemaOnDifferentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        int id1 = this.restApp.restClient.registerSchema(schema, "subject1");
        int id2 = this.restApp.restClient.registerSchema(schema, "subject2");
        Assert.assertEquals((String)"Registering the same schema under different subjects should return the same id", (long)id1, (long)id2);
    }

    @Test
    public void testRegisterBadDefault() throws Exception {
        String subject = "testSubject";
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"default\":null,\"name\":\"f\"}]}";
        String schema = AvroUtils.parseSchema((String)schemaString).canonicalString();
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "latest");
            Assert.fail((String)"Testing compatibility for schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.registerSchema(schema, subject);
            Assert.fail((String)"Registering schema with invalid default should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testRegisterInvalidSchemaBadType() throws Exception {
        String subject = "testSubject";
        String badSchemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"str\",\"name\":\"field1\"}]}";
        String expectedErrorMessage = null;
        try {
            new Schema.Parser().parse(badSchemaString);
            Assert.fail((String)"Parsing invalid schema string should fail with SchemaParseException");
        }
        catch (SchemaParseException spe) {
            expectedErrorMessage = spe.getMessage();
        }
        try {
            this.restApp.restClient.registerSchema(badSchemaString, subject);
            Assert.fail((String)"Registering schema with invalid field type should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
            Assert.assertTrue((String)"Verify error message verbosity", (boolean)rce.getMessage().contains(expectedErrorMessage));
        }
    }

    @Test
    public void testRegisterInvalidSchemaBadReference() throws Exception {
        String subject = "testSubject";
        SchemaReference invalidReference = new SchemaReference("invalid.schema", "badSubject", Integer.valueOf(1));
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"}]}";
        try {
            this.restApp.restClient.registerSchema(schemaString, "AVRO", Collections.singletonList(invalidReference), subject);
            Assert.fail((String)"Registering schema with invalid reference should fail with 42201 (invalid schema)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testRegisterDiffSchemaType() throws Exception {
        String subject = "testSubject";
        String avroSchema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String jsonSchema = io.confluent.kafka.schemaregistry.rest.json.RestApiTest.getRandomJsonSchemas(1).get(0);
        String protobufSchema = io.confluent.kafka.schemaregistry.rest.protobuf.RestApiTest.getRandomProtobufSchemas(1).get(0);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        int id1 = this.restApp.restClient.registerSchema(avroSchema, subject);
        Assert.assertEquals((String)"1st schema registered globally should have id 1", (long)1L, (long)id1);
        boolean isCompatible = this.restApp.restClient.testCompatibility(jsonSchema, "JSON", null, subject, "latest", false).isEmpty();
        Assert.assertTrue((String)"Different schema type is allowed when compatibility is NONE", (boolean)isCompatible);
        int id2 = this.restApp.restClient.registerSchema(jsonSchema, "JSON", null, subject).getId();
        Assert.assertEquals((String)"2nd schema registered globally should have id 2", (long)2L, (long)id2);
        isCompatible = this.restApp.restClient.testCompatibility(protobufSchema, "PROTOBUF", null, subject, "latest", false).isEmpty();
        Assert.assertTrue((String)"Different schema type is allowed when compatibility is NONE", (boolean)isCompatible);
        int id3 = this.restApp.restClient.registerSchema(protobufSchema, "PROTOBUF", null, subject).getId();
        Assert.assertEquals((String)"3rd schema registered globally should have id 3", (long)3L, (long)id3);
    }

    @Test
    public void testRegisterDiffContext() throws Exception {
        List<String> avroSchemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "testSubject";
        String avroSchema = avroSchemas.get(0);
        int id1 = this.restApp.restClient.registerSchema(avroSchema, subject);
        Assert.assertEquals((String)"1st schema registered in first context should have id 1", (long)1L, (long)id1);
        String subject2 = ":.ctx:testSubject";
        String avroSchema2 = avroSchemas.get(1);
        int id2 = this.restApp.restClient.registerSchema(avroSchema2, subject2);
        Assert.assertEquals((String)"2nd schema registered in second context should have id 1", (long)1L, (long)id2);
        List subjects = this.restApp.restClient.getAllSubjects("", false);
        Assert.assertEquals(Collections.singletonList(subject), (Object)subjects);
        List schemas = this.restApp.restClient.getSchemas(null, false, false);
        Assert.assertEquals((Object)avroSchema, (Object)((Schema)schemas.get(0)).getSchema());
        List subjects2 = this.restApp.restClient.getAllSubjects(":.ctx:", false);
        Assert.assertEquals(Collections.singletonList(subject2), (Object)subjects2);
        List schemas2 = this.restApp.restClient.getSchemas(":.ctx:", false, false);
        Assert.assertEquals((Object)avroSchema2, (Object)((Schema)schemas2.get(0)).getSchema());
    }

    @Test
    public void testImportDifferentSchemaOnSameID() throws Exception {
        int id2;
        int id1;
        String schema1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"}]}";
        String schema2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"field1\"},{\"type\":\"int\",\"name\":\"field2\",\"default\":0}]}";
        this.restApp.restClient.setMode("IMPORT");
        try {
            id1 = this.restApp.restClient.registerSchema(schema1, "subject1", 1, 1);
            Assert.assertEquals((long)1L, (long)id1);
            id2 = this.restApp.restClient.registerSchema(schema2, "subject1", 2, 1);
            Assert.fail((String)String.format("Schema2 is registered with id %s, should receive error here", id2));
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Overwrite schema for the same ID is not permitted.", (long)42205L, (long)e.getErrorCode());
        }
        try {
            id1 = this.restApp.restClient.registerSchema(schema1, "subject1", 1, 1);
            Assert.assertEquals((long)1L, (long)id1);
            id2 = this.restApp.restClient.registerSchema(schema2, "subject2", 1, 1);
            Assert.fail((String)String.format("Schema2 is registered with id %s, should receive error here", id2));
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Overwrite schema for the same ID is not permitted.", (long)42205L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testCompatibleSchemaLookupBySubject() throws Exception {
        String subject = "testSubject";
        int numRegisteredSchemas = 0;
        int numSchemas = 10;
        List<String> allSchemas = TestUtils.getRandomCanonicalAvroString(numSchemas);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        this.restApp.restClient.registerSchema(allSchemas.get(0), subject);
        ++numRegisteredSchemas;
        String schema1 = allSchemas.get(0);
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema1, subject, "latest").isEmpty();
        Assert.assertTrue((String)"First schema registered should be compatible", (boolean)isCompatible);
        for (int i = 0; i < numSchemas; ++i) {
            String schema = allSchemas.get(i);
            isCompatible = this.restApp.restClient.testCompatibility(schema, subject, "latest").isEmpty();
            TestUtils.checkNumberOfVersions(this.restApp.restClient, numRegisteredSchemas, subject);
        }
    }

    @Test
    public void testIncompatibleSchemaLookupBySubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"f\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        int versionOfRegisteredSchema = this.restApp.restClient.lookUpSubjectVersion(schema1, subject).getVersion();
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema2, subject, String.valueOf(versionOfRegisteredSchema)).isEmpty();
        Assert.assertFalse((String)"Schema should be incompatible with specified version", (boolean)isCompatible);
    }

    @Test
    public void testIncompatibleSchemaBySubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"},{\"type\":\"string\",\"name\":\"f2\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        String schema3String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"},{\"type\":\"string\",\"name\":\"f3\"}]}";
        String schema3 = AvroUtils.parseSchema((String)schema3String).canonicalString();
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD_TRANSITIVE.name, subject);
        boolean isCompatible = this.restApp.restClient.testCompatibility(schema3, subject, "latest").isEmpty();
        Assert.assertTrue((String)"Schema is compatible with the latest version", (boolean)isCompatible);
        isCompatible = this.restApp.restClient.testCompatibility(schema3, subject, null).isEmpty();
        Assert.assertFalse((String)"Schema should be incompatible with FORWARD_TRANSITIVE setting", (boolean)isCompatible);
        try {
            this.restApp.restClient.registerSchema(schema3String, subject);
            Assert.fail((String)"Schema register should fail since schema is incompatible");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Schema register should fail since schema is incompatible", (long)Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE, (long)e.getErrorCode());
            Assert.assertFalse((boolean)e.getMessage().isEmpty());
            Assert.assertTrue((boolean)e.getMessage().contains("oldSchemaVersion:"));
            Assert.assertTrue((boolean)e.getMessage().contains("oldSchema:"));
            Assert.assertTrue((boolean)e.getMessage().contains("compatibility:"));
        }
    }

    @Test
    public void testSchemaRegistrationUnderDiffSubjects() throws Exception {
        String subject1 = "testSubject1";
        String subject2 = "testSubject2";
        String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schemaString1).canonicalString();
        String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"foo\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schemaString2).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject1);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject2);
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(schema1, subject1);
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(schema1, subject1).getVersion();
        Assert.assertEquals((String)"1st schema under subject1 should have version 1", (long)1L, (long)versionOfRegisteredSchema1Subject1);
        Assert.assertEquals((String)"1st schema registered globally should have id 1", (long)1L, (long)idOfRegisteredSchema1Subject1);
        int idOfRegisteredSchema2Subject1 = this.restApp.restClient.registerSchema(schema2, subject1);
        int versionOfRegisteredSchema2Subject1 = this.restApp.restClient.lookUpSubjectVersion(schema2, subject1).getVersion();
        Assert.assertEquals((String)"2nd schema under subject1 should have version 2", (long)2L, (long)versionOfRegisteredSchema2Subject1);
        Assert.assertEquals((String)"2nd schema registered globally should have id 2", (long)2L, (long)idOfRegisteredSchema2Subject1);
        int idOfRegisteredSchema2Subject2 = this.restApp.restClient.registerSchema(schema2, subject2);
        int versionOfRegisteredSchema2Subject2 = this.restApp.restClient.lookUpSubjectVersion(schema2, subject2).getVersion();
        Assert.assertEquals((String)"2nd schema under subject1 should still have version 1 as the first schema under subject2", (long)1L, (long)versionOfRegisteredSchema2Subject2);
        Assert.assertEquals((String)"Since schema is globally registered but not under subject2, id should not change", (long)2L, (long)idOfRegisteredSchema2Subject2);
    }

    @Test
    public void testConfigDefaults() throws Exception {
        Assert.assertEquals((String)"Default compatibility level should be none for this test instance", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null);
        Assert.assertEquals((String)"New compatibility level should be forward for this test instance", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testNonExistentSubjectConfigChange() throws Exception {
        String subject = "testSubject";
        try {
            this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, subject);
        }
        catch (RestClientException e) {
            Assert.fail((String)"Changing config for an invalid subject should succeed");
        }
        Assert.assertEquals((String)"New compatibility level for this subject should be forward", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel());
    }

    @Test
    public void testSubjectConfigChange() throws Exception {
        String subject = "testSubject";
        Assert.assertEquals((String)"Default compatibility level should be none for this test instance", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, subject);
        Assert.assertEquals((String)"Global compatibility level should remain none for this test instance", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        Assert.assertEquals((String)"New compatibility level for this subject should be forward", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel());
        this.restApp.restClient.deleteConfig(subject);
        Assert.assertEquals((String)"Compatibility level for this subject should be reverted to none", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true).getCompatibilityLevel());
    }

    @Test
    public void testGlobalConfigChange() throws Exception {
        Assert.assertEquals((String)"Default compatibility level should be none for this test instance", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FORWARD.name, null);
        Assert.assertEquals((String)"New Global compatibility level should be forward", (Object)CompatibilityLevel.FORWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, null);
        Assert.assertEquals((String)"New Global compatibility level should be backward", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.deleteConfig(null);
        Assert.assertEquals((String)"Global compatibility level should be reverted to none", (Object)CompatibilityLevel.NONE.name, (Object)this.restApp.restClient.getConfig(RestService.DEFAULT_REQUEST_PROPERTIES, null, true).getCompatibilityLevel());
    }

    @Test
    public void testGetSchemaNonExistingId() throws Exception {
        try {
            this.restApp.restClient.getId(100);
            Assert.fail((String)"Schema lookup by missing id should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing id", (long)40403L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetSchemaWithFetchMaxId() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(3);
        int latestId = 0;
        for (String schema : schemas) {
            latestId = this.restApp.restClient.registerSchema(schema, "subject");
        }
        Assert.assertNull((Object)this.restApp.restClient.getId(1).getMaxId());
        Assert.assertEquals((Object)latestId, (Object)this.restApp.restClient.getId(1, null, true).getMaxId());
    }

    @Test
    public void testGetSchemaTypes() throws Exception {
        Assert.assertEquals(new HashSet<String>(Arrays.asList("AVRO", "JSON", "PROTOBUF")), new HashSet(this.restApp.restClient.getSchemaTypes()));
    }

    @Test
    public void testListVersionsNonExistingSubject() throws Exception {
        try {
            this.restApp.restClient.getAllVersions("Invalid");
            Assert.fail((String)"Getting all versions of missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetVersionNonExistentSubject() throws Exception {
        try {
            this.restApp.restClient.getVersion("non-existing-subject", 1);
            Assert.fail((String)"Getting version of missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Unregistered subject shouldn't be found in getVersion()", (long)40401L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testGetNonExistingVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.getVersion(subject, 200);
            Assert.fail((String)"Getting unregistered version should fail with 40402 (version not found)");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Unregistered version shouldn't be found", (long)40402L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testGetInvalidVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.getVersion(subject, 0);
            Assert.fail((String)"Getting invalid version should fail with 42202 (invalid version)");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Invalid version shouldn't be found", (long)42202L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testRegisterInvalidSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "\rbad\nsubject\t";
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
            Assert.fail((String)"Registering invalid subject should fail with 42208 (invalid subject)");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Invalid subject shouldn't be registered", (long)42208L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testGetVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Version 1 schema should match", (Object)schemas.get(0), (Object)this.restApp.restClient.getVersion(subject, 1).getSchema());
        Assert.assertEquals((String)"Version 2 schema should match", (Object)schemas.get(1), (Object)this.restApp.restClient.getVersion(subject, 2).getSchema());
        Assert.assertEquals((String)"Latest schema should be the same as version 2", (Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema());
    }

    @Test
    public void testGetOnlySchemaById() throws Exception {
        String schema = String.valueOf(TestUtils.getRandomCanonicalAvroString(1));
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        Assert.assertEquals((String)"Schema with ID 1 should match.", (Object)schema, (Object)this.restApp.restClient.getOnlySchemaById(1));
    }

    @Test
    public void testGetLatestVersionSchemaOnly() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Latest schema should be the same as version 2", (Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersionSchemaOnly(subject));
    }

    @Test
    public void testGetVersionSchemaOnly() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(1);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        Assert.assertEquals((String)"Retrieved schema should be the same as version 1", (Object)schemas.get(0), (Object)this.restApp.restClient.getVersionSchemaOnly(subject, 1));
    }

    @Test
    public void testSchemaReferences() throws Exception {
        this.testSchemaReferencesInContext("", "", 2);
    }

    @Test
    public void testSchemaReferencesSameContext() throws Exception {
        this.testSchemaReferencesInContext(":.ctx:", ":.ctx:", 2);
    }

    @Test
    public void testSchemaReferencesDifferentContext() throws Exception {
        this.testSchemaReferencesInContext("", ":.ctx:", 1);
    }

    private void testSchemaReferencesInContext(String context, String refContext, int parentId) throws Exception {
        List<String> schemas = TestUtils.getAvroSchemaWithReferences();
        String unqualifiedSubject = "my_reference";
        String subject = refContext + unqualifiedSubject;
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get(1));
        SchemaReference ref = new SchemaReference("otherns.Subrecord", subject, Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        String subject2 = context + "my_referrer";
        int registeredId = this.restApp.restClient.registerSchema(request, subject2, false).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)parentId, (long)registeredId);
        SchemaString schemaString = this.restApp.restClient.getId(parentId, subject2);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemas.get(1), (Object)schemaString.getSchemaString());
        Assert.assertEquals((String)"Schema references should be found", Collections.singletonList(ref), (Object)schemaString.getReferences());
        List refs = this.restApp.restClient.getReferencedBy(subject, 1);
        Assert.assertEquals((long)parentId, (long)((Integer)refs.get(0)).intValue());
        MyRecord myrecord = new MyRecord();
        AvroSchema schema = new AvroSchema(AvroSchemaUtils.getSchema((Object)((Object)myrecord)));
        Schema registeredSchema = this.restApp.restClient.lookUpSubjectVersion(schema.canonicalString(), "AVRO", Collections.emptyList(), subject2, false);
        Assert.assertEquals((String)"Registered schema should be found", (long)parentId, (long)registeredSchema.getId().intValue());
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, String.valueOf(1));
            Assert.fail((String)"Deleting reference should fail with 42206");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Reference found", (long)42206L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"));
        refs = this.restApp.restClient.getReferencedBy(subject, 1);
        Assert.assertTrue((boolean)refs.isEmpty());
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"));
    }

    @Test
    public void testSchemaReferencesMultipleLevels() throws Exception {
        String root = "[\"myavro.BudgetDecreased\",\"myavro.BudgetUpdated\"]";
        String ref1 = "{\n  \"type\" : \"record\",\n  \"name\" : \"BudgetDecreased\",\n  \"namespace\" : \"myavro\",\n  \"fields\" : [ {\n    \"name\" : \"buyerId\",\n    \"type\" : \"long\"\n  }, {\n    \"name\" : \"currency\",\n    \"type\" : {\n      \"type\" : \"myavro.currencies.Currency\"    }\n  }, {\n    \"name\" : \"amount\",\n    \"type\" : \"double\"\n  } ]\n}";
        String ref2 = "{\n  \"type\" : \"record\",\n  \"name\" : \"BudgetUpdated\",\n  \"namespace\" : \"myavro\",\n  \"fields\" : [ {\n    \"name\" : \"buyerId\",\n    \"type\" : \"long\"\n  }, {\n    \"name\" : \"currency\",\n    \"type\" : {\n      \"type\" : \"myavro.currencies.Currency\"    }\n  }, {\n    \"name\" : \"updatedValue\",\n    \"type\" : \"double\"\n  } ]\n}";
        String sharedRef = "{\n      \"type\" : \"enum\",\n      \"name\" : \"Currency\",\n      \"namespace\" : \"myavro.currencies\",\n      \"symbols\" : [ \"EUR\", \"USD\" ]\n    }\n";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, new AvroSchema(sharedRef).canonicalString(), 1, "shared");
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(ref1);
        SchemaReference ref = new SchemaReference("myavro.currencies.Currency", "shared", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        int registeredId = this.restApp.restClient.registerSchema(request, "ref1", false).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)2L, (long)registeredId);
        request = new RegisterSchemaRequest();
        request.setSchema(ref2);
        ref = new SchemaReference("myavro.currencies.Currency", "shared", Integer.valueOf(1));
        request.setReferences(Collections.singletonList(ref));
        registeredId = this.restApp.restClient.registerSchema(request, "ref2", false).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)3L, (long)registeredId);
        request = new RegisterSchemaRequest();
        request.setSchema(root);
        SchemaReference r1 = new SchemaReference("myavro.BudgetDecreased", "ref1", Integer.valueOf(1));
        SchemaReference r2 = new SchemaReference("myavro.BudgetUpdated", "ref2", Integer.valueOf(1));
        request.setReferences(Arrays.asList(r1, r2));
        registeredId = this.restApp.restClient.registerSchema(request, "root", false).getId();
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)4L, (long)registeredId);
        SchemaString schemaString = this.restApp.restClient.getId(4);
        Assert.assertEquals((String)"Registered schema should be found", (Object)root, (Object)schemaString.getSchemaString());
        Assert.assertEquals((String)"Schema references should be found", Arrays.asList(r1, r2), (Object)schemaString.getReferences());
    }

    @Test(expected=RestClientException.class)
    public void testSchemaMissingReferences() throws Exception {
        List<String> schemas = TestUtils.getAvroSchemaWithReferences();
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemas.get(1));
        request.setReferences(Collections.emptyList());
        this.restApp.restClient.registerSchema(request, "referrer", false);
    }

    @Test
    public void testSchemaNormalization() throws Exception {
        String subject1 = "testSubject1";
        String reference1 = "{\"type\":\"record\",\"name\":\"Subrecord1\",\"namespace\":\"otherns\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, reference1, 1, "ref1");
        String reference2 = "{\"type\":\"record\",\"name\":\"Subrecord2\",\"namespace\":\"otherns\",\"fields\":[{\"name\":\"field2\",\"type\":\"string\"}]}";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, reference2, 2, "ref2");
        SchemaReference ref1 = new SchemaReference("otherns.Subrecord1", "ref1", Integer.valueOf(1));
        SchemaReference ref2 = new SchemaReference("otherns.Subrecord2", "ref2", Integer.valueOf(1));
        String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":{\"type\":\"int\"},\"name\":\"field0\"},{\"name\":\"field1\",\"type\":\"otherns.Subrecord1\"},{\"name\":\"field2\",\"type\":\"otherns.Subrecord2\"}],\"extraMetadata\": {\"a\": 1, \"b\": 2}}";
        String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"int\",\"name\":\"field0\"},{\"name\":\"field1\",\"type\":\"otherns.Subrecord1\"},{\"name\":\"field2\",\"type\":\"otherns.Subrecord2\"}],\"extraMetadata\": {\"b\": 2, \"a\": 1}}";
        RegisterSchemaRequest registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(schemaString1);
        registerRequest.setReferences(Arrays.asList(ref1, ref2));
        int idOfRegisteredSchema1Subject1 = this.restApp.restClient.registerSchema(registerRequest, subject1, true).getId();
        RegisterSchemaRequest lookUpRequest = new RegisterSchemaRequest();
        lookUpRequest.setSchema(schemaString2);
        lookUpRequest.setReferences(Arrays.asList(ref2, ref1));
        int versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assert.assertEquals((String)"1st schema under subject1 should have version 1", (long)1L, (long)versionOfRegisteredSchema1Subject1);
        Assert.assertEquals((String)"1st schema registered globally should have id 3", (long)3L, (long)idOfRegisteredSchema1Subject1);
        lookUpRequest = new RegisterSchemaRequest();
        Schema.Parser parser = new Schema.Parser();
        parser.parse(reference1);
        parser.parse(reference2);
        AvroSchema resolvedSchema = new AvroSchema(parser.parse(schemaString2));
        lookUpRequest.setSchema(resolvedSchema.canonicalString());
        versionOfRegisteredSchema1Subject1 = this.restApp.restClient.lookUpSubjectVersion(lookUpRequest, subject1, true, false).getVersion();
        Assert.assertEquals((String)"1st schema under subject1 should have version 1", (long)1L, (long)versionOfRegisteredSchema1Subject1);
        String recordInvalidDefaultSchema = "{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": null}\n]\n}";
        registerRequest = new RegisterSchemaRequest();
        registerRequest.setSchema(recordInvalidDefaultSchema);
        try {
            this.restApp.restClient.registerSchema(registerRequest, subject1, true);
            Assert.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        List messages = this.restApp.restClient.testCompatibility(registerRequest, subject1, null, true, true);
        Assert.assertTrue((!messages.isEmpty() && ((String)messages.get(0)).contains("Invalid schema") ? 1 : 0) != 0);
    }

    @Test
    public void testBad() throws Exception {
        String subject1 = "testTopic1";
        ArrayList allSubjects = new ArrayList();
        Assert.assertEquals((String)"Getting all subjects should return empty", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, TestUtils.getBadSchema(), 1, subject1);
            Assert.fail((String)"Registering bad schema should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        try {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, TestUtils.getRandomCanonicalAvroString(1).get(0), (List<SchemaReference>)ImmutableList.of((Object)new SchemaReference("bad", "bad", Integer.valueOf(100))), 1, subject1);
            Assert.fail((String)"Registering bad reference should fail with 42201");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Invalid schema", (long)42201L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", allSubjects, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testLookUpSchemaUnderNonExistentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        try {
            this.restApp.restClient.lookUpSubjectVersion(schema, "non-existent-subject");
            Assert.fail((String)"Looking up schema under missing subject should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject not found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testLookUpNonExistentSchemaUnderSubject() throws Exception {
        String subject = "test";
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.NONE.name, subject);
        try {
            this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject);
            Assert.fail((String)"Looking up missing schema under subject should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetSubjectsAssociatedWithSchemaId() throws Exception {
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject2);
        List associatedSubjects = this.restApp.restClient.getAllSubjectsById(1);
        Assert.assertEquals((long)associatedSubjects.size(), (long)2L);
        Assert.assertEquals(Arrays.asList(subject1, subject2), (Object)associatedSubjects);
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"));
        associatedSubjects = this.restApp.restClient.getAllSubjectsById(1);
        Assert.assertEquals((long)associatedSubjects.size(), (long)1L);
        Assert.assertEquals(Collections.singletonList(subject1), (Object)associatedSubjects);
        associatedSubjects = this.restApp.restClient.getAllSubjectsById(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, true);
        Assert.assertEquals((long)associatedSubjects.size(), (long)2L);
        Assert.assertEquals(Arrays.asList(subject1, subject2), (Object)associatedSubjects);
    }

    @Test
    public void testGetSubjectsAssociatedWithNotFoundSchemaId() throws Exception {
        try {
            this.restApp.restClient.getAllSubjectsById(1);
            Assert.fail((String)"Getting all subjects associated with id 1 should fail with 40403 (schema not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing schema", (long)40403L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetVersionsAssociatedWithSchemaId() throws Exception {
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject2);
        List associatedSubjects = this.restApp.restClient.getAllVersionsById(1);
        Assert.assertEquals((long)associatedSubjects.size(), (long)2L);
        Assert.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject1, Integer.valueOf(1))));
        Assert.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject2, Integer.valueOf(1))));
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"));
        associatedSubjects = this.restApp.restClient.getAllVersionsById(1);
        Assert.assertEquals((long)associatedSubjects.size(), (long)1L);
        Assert.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject1, Integer.valueOf(1))));
        associatedSubjects = this.restApp.restClient.getAllVersionsById(RestService.DEFAULT_REQUEST_PROPERTIES, 1, null, true);
        Assert.assertEquals((long)associatedSubjects.size(), (long)2L);
        Assert.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject1, Integer.valueOf(1))));
        Assert.assertTrue((boolean)associatedSubjects.contains(new SubjectVersion(subject2, Integer.valueOf(1))));
    }

    @Test
    public void testCompatibilityNonExistentSubject() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        boolean result = this.restApp.restClient.testCompatibility(schema, "non-existent-subject", "latest").isEmpty();
        Assert.assertTrue((String)"Compatibility succeeds", (boolean)result);
        result = this.restApp.restClient.testCompatibility(schema, "non-existent-subject", null).isEmpty();
        Assert.assertTrue((String)"Compatibility succeeds", (boolean)result);
    }

    @Test
    public void testCompatibilityNonExistentVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "100");
            Assert.fail((String)"Testing compatibility for missing version should fail with 40402 (version not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testCompatibilityInvalidVersion() throws Exception {
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.testCompatibility(schema, subject, "earliest");
            Assert.fail((String)"Testing compatibility for invalid version should fail with 42202 (version not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)42202L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetConfigNonExistentSubject() throws Exception {
        try {
            this.restApp.restClient.getConfig("non-existent-subject");
            Assert.fail((String)"Getting the configuration of a missing subject should fail with 40401 error code (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject not found", (long)40408L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testCanonicalization() throws Exception {
        String schema = "{   \"type\":   \"string\"}";
        String subject = "test";
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)1L, (long)this.restApp.restClient.registerSchema(schema, subject));
        Assert.assertEquals((String)"Registering the same schema should get back the same id", (long)1L, (long)this.restApp.restClient.registerSchema(schema, subject));
        Assert.assertEquals((String)"Lookup the same schema should get back the same id", (long)1L, (long)this.restApp.restClient.lookUpSubjectVersion(schema, subject).getId().intValue());
    }

    @Test
    public void testDeleteSchemaVersionBasic() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2"));
        Assert.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getAllVersions(subject));
        try {
            this.restApp.restClient.getVersion(subject, 2);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get(1));
            this.restApp.restClient.lookUpSubjectVersion(RestService.DEFAULT_REQUEST_PROPERTIES, request, subject, false, false);
            Assert.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        try {
            List versions = this.restApp.restClient.getAllVersions(subject);
            Assert.fail((String)("Getting all versions from non-existing subject1 should fail with 40401 (subject not found). Got " + versions));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        for (int i = 0; i < 2; ++i) {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
            Assert.assertEquals(Collections.singletonList(3), (Object)this.restApp.restClient.getAllVersions(subject));
        }
    }

    @Test
    public void testDeleteSchemaVersionPermanent() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true);
            Assert.fail((String)"Permanent deleting first time should throw schemaVersionNotSoftDeletedException");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema version must be soft deleted first", (long)40407L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2"));
        Assert.assertEquals(Collections.singletonList(1), (Object)this.restApp.restClient.getAllVersions(subject));
        Assert.assertEquals(Arrays.asList(1, 2), (Object)this.restApp.restClient.getAllVersions(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true));
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
            Assert.fail((String)"Soft deleting second time should throw schemaVersionSoftDeletedException");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema version already soft deleted", (long)40406L, (long)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.getVersion(subject, 2);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        Schema schema = this.restApp.restClient.getVersion(subject, 2, true);
        Assert.assertEquals((String)"Lookup Version Match", (Object)2, (Object)schema.getVersion());
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemas.get(1));
            this.restApp.restClient.lookUpSubjectVersion(RestService.DEFAULT_REQUEST_PROPERTIES, request, subject, false, false);
            Assert.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true));
        try {
            this.restApp.restClient.getVersion(subject, 2, true);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2", true);
            Assert.fail((String)String.format("Getting Version %s for subject %s should fail with %s", "2", subject, 40402));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        try {
            List versions = this.restApp.restClient.getAllVersions(subject);
            Assert.fail((String)("Getting all versions from non-existing subject1 should fail with 40401 (subject not found). Got " + versions));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        for (int i = 0; i < 2; ++i) {
            TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
            Assert.assertEquals(Collections.singletonList(2), (Object)this.restApp.restClient.getAllVersions(subject));
        }
    }

    @Test
    public void testDeleteSchemaVersionInvalidSubject() throws Exception {
        try {
            String subject = "test";
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
            Assert.fail((String)"Deleting a non existent subject version should fail with 40401 error code (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject not found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteLatestVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(3);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)2, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        Schema schema = this.restApp.restClient.getLatestVersion(subject);
        Assert.assertEquals((String)"Latest Version Schema", (Object)schemas.get(0), (Object)schema.getSchema());
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest"));
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assert.fail((String)"Getting latest versions from non-existing subject should fail with 40401 (subject not found).");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(2), 3, subject);
        Assert.assertEquals((String)"Latest version available after subject re-registration", (Object)schemas.get(2), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema());
    }

    @Test
    public void testGetLatestVersionNonExistentSubject() throws Exception {
        String subject = "non_existent_subject";
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assert.fail((String)"Getting latest versions from non-existing subject should fail with 40401 (subject not found).");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testGetLatestVersionDeleteOlder() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Latest Version Schema", (Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema());
        Assert.assertEquals((String)"Deleting Schema Older Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"));
        Assert.assertEquals((String)"Latest Version Schema Still Same", (Object)schemas.get(1), (Object)this.restApp.restClient.getLatestVersion(subject).getSchema());
    }

    @Test
    public void testDeleteInvalidVersion() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(1);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        try {
            this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject version", (long)40402L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteWithLookup() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Deleting Schema Version Success", (Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1"));
        try {
            this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
            Assert.fail((String)String.format("Lookup Subject Version %s for subject %s should fail with %s", "2", subject, 40403));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Schema not found", (long)40403L, (long)rce.getErrorCode());
        }
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((String)"Lookup Version Match", (Object)1, (Object)schema.getVersion());
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((String)"Lookup Version Match", (Object)3, (Object)schema.getVersion());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
        Assert.assertEquals((String)"Lookup Version Match", (Object)3, (Object)schema.getVersion());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject);
        Assert.assertEquals((String)"Lookup Version Match", (Object)3, (Object)schema.getVersion());
    }

    @Test
    public void testIncompatibleSchemaLookupBySubjectAfterDelete() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String wrongSchema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String wrongSchema2 = AvroUtils.parseSchema((String)wrongSchema2String).canonicalString();
        String correctSchema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"int\",\"name\":\"g\" , \"default\":0}]}";
        String correctSchema2 = AvroUtils.parseSchema((String)correctSchema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        boolean isCompatible = this.restApp.restClient.testCompatibility(wrongSchema2, subject, "latest").isEmpty();
        Assert.assertTrue((String)"Schema should be compatible with specified version", (boolean)isCompatible);
        this.restApp.restClient.registerSchema(wrongSchema2, subject);
        isCompatible = this.restApp.restClient.testCompatibility(correctSchema2, subject, "latest").isEmpty();
        Assert.assertFalse((String)"Schema should be incompatible with specified version", (boolean)isCompatible);
        try {
            this.restApp.restClient.registerSchema(correctSchema2, subject);
            Assert.fail((String)"Schema should be Incompatible");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Incompatible Schema", (long)Errors.INCOMPATIBLE_SCHEMA_ERROR_CODE, (long)rce.getErrorCode());
        }
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "latest");
        isCompatible = this.restApp.restClient.testCompatibility(correctSchema2, subject, "latest").isEmpty();
        Assert.assertTrue((String)"Schema should be compatible with specified version", (boolean)isCompatible);
        this.restApp.restClient.registerSchema(correctSchema2, subject);
        Assert.assertEquals((String)"Version is same", (Object)3, (Object)this.restApp.restClient.lookUpSubjectVersion(correctSchema2String, subject).getVersion());
    }

    @Test
    public void testSubjectCompatibilityAfterDeletingAllVersions() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, null);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "1");
        Assert.assertEquals((String)"Compatibility Level Exists", (Object)CompatibilityLevel.BACKWARD.name, (Object)this.restApp.restClient.getConfig(subject).getCompatibilityLevel());
        Assert.assertEquals((String)"Top Compatibility Level Exists", (Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
        this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject, "2");
        try {
            this.restApp.restClient.getConfig(subject);
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Compatibility Level doesn't exist", (long)40408L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Top Compatibility Level Exists", (Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testListSubjects() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject1 = "test1";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject1);
        String subject2 = "test2";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject2);
        ArrayList<String> expectedResponse = new ArrayList<String>();
        expectedResponse.add(subject1);
        expectedResponse.add(subject2);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects());
        ArrayList<Integer> deletedResponse = new ArrayList<Integer>();
        deletedResponse.add(1);
        Assert.assertEquals((String)"Versions Deleted Match", deletedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject2));
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects());
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        expectedResponse.add(subject2);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects(true));
        Assert.assertEquals((String)"Versions Deleted Match", deletedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, true));
        expectedResponse = new ArrayList();
        expectedResponse.add(subject1);
        Assert.assertEquals((String)"Current Subjects", expectedResponse, (Object)this.restApp.restClient.getAllSubjects());
    }

    @Test
    public void testListSoftDeletedSubjectsAndSchemas() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(3);
        String subject1 = "test1";
        String subject2 = "test2";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject1);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(2), 3, subject2);
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject1, "1"));
        Assert.assertEquals((Object)1, (Object)this.restApp.restClient.deleteSchemaVersion(RestService.DEFAULT_REQUEST_PROPERTIES, subject2, "1"));
        Assert.assertEquals((String)"List All Versions Match", Collections.singletonList(2), (Object)this.restApp.restClient.getAllVersions(subject1));
        Assert.assertEquals((String)"List All Versions Include deleted Match", Arrays.asList(1, 2), (Object)this.restApp.restClient.getAllVersions(RestService.DEFAULT_REQUEST_PROPERTIES, subject1, true));
        Assert.assertEquals((String)"List Deleted Versions Match", Collections.singletonList(1), (Object)this.restApp.restClient.getDeletedOnlyVersions(subject1));
        Assert.assertEquals((String)"List All Subjects Match", Collections.singletonList(subject1), (Object)this.restApp.restClient.getAllSubjects());
        Assert.assertEquals((String)"List All Subjects Include deleted Match", Arrays.asList(subject1, subject2), (Object)this.restApp.restClient.getAllSubjects(true));
        Assert.assertEquals((String)"List Deleted Only Subjects Match", Collections.singletonList(subject2), (Object)this.restApp.restClient.getDeletedOnlySubjects(null));
    }

    @Test
    public void testDeleteSubjectBasic() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject));
        try {
            this.restApp.restClient.getLatestVersion(subject);
            Assert.fail((String)String.format("Subject %s should not be found", subject));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject Not Found", (long)40401L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteSubjectException() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject));
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((long)1L, (long)schema.getVersion().intValue());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject, true);
        Assert.assertEquals((long)2L, (long)schema.getVersion().intValue());
        try {
            this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
            Assert.fail((String)String.format("Subject %s should not be found", subject));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject exists in soft deleted format.", (long)40404L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testDeleteSubjectPermanent() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        ArrayList<Integer> expectedResponse = new ArrayList<Integer>();
        expectedResponse.add(1);
        expectedResponse.add(2);
        try {
            this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true);
            Assert.fail((String)"Delete permanent should not succeed");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject '%s' was not deleted first before permanent delete", (long)40405L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject));
        Schema schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, true);
        Assert.assertEquals((long)1L, (long)schema.getVersion().intValue());
        schema = this.restApp.restClient.lookUpSubjectVersion(schemas.get(1), subject, true);
        Assert.assertEquals((long)2L, (long)schema.getVersion().intValue());
        Assert.assertEquals((String)"Versions Deleted Match", expectedResponse, (Object)this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject, true));
        for (Integer i : expectedResponse) {
            try {
                this.restApp.restClient.lookUpSubjectVersion(schemas.get(0), subject, false);
                Assert.fail((String)String.format("Subject %s should not be found", subject));
            }
            catch (RestClientException rce) {
                Assert.assertEquals((String)"Subject Not Found", (long)40401L, (long)rce.getErrorCode());
            }
            try {
                this.restApp.restClient.lookUpSubjectVersion(schemas.get(i - 1), subject, true);
                Assert.fail((String)String.format("Subject %s should not be found", subject));
            }
            catch (RestClientException rce) {
                Assert.assertEquals((String)"Subject Not Found", (long)40401L, (long)rce.getErrorCode());
            }
        }
    }

    @Test
    public void testDeleteSubjectAndRegister() throws Exception {
        List<String> schemas = TestUtils.getRandomCanonicalAvroString(2);
        String subject = "test";
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(0), 1, subject);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schemas.get(1), 2, subject);
        Assert.assertEquals((String)"Versions match", Arrays.asList(3, 4), (Object)this.restApp.restClient.getAllVersions(subject));
        try {
            this.restApp.restClient.getVersion(subject, 1);
            Assert.fail((String)"Version 1 should not be found");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Version not found", (long)40402L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testSubjectCompatibilityAfterDeletingSubject() throws Exception {
        String subject = "testSubject";
        String schema1String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"}]}";
        String schema1 = AvroUtils.parseSchema((String)schema1String).canonicalString();
        String schema2String = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}";
        String schema2 = AvroUtils.parseSchema((String)schema2String).canonicalString();
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.FULL.name, null);
        this.restApp.restClient.updateCompatibility(CompatibilityLevel.BACKWARD.name, subject);
        this.restApp.restClient.registerSchema(schema1, subject);
        this.restApp.restClient.registerSchema(schema2, subject);
        this.restApp.restClient.deleteSubject(RestService.DEFAULT_REQUEST_PROPERTIES, subject);
        try {
            this.restApp.restClient.getConfig(subject);
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Compatibility Level doesn't exist", (long)40408L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Top Compatibility Level Exists", (Object)CompatibilityLevel.FULL.name, (Object)this.restApp.restClient.getConfig(null).getCompatibilityLevel());
    }

    @Test
    public void testGetClusterId() throws Exception {
        try {
            ServerClusterId serverClusterId = this.restApp.restClient.getClusterId();
            Assert.assertEquals((Object)"", (Object)serverClusterId.getId());
            Assert.assertEquals(Collections.emptyList(), serverClusterId.getScope().get("path"));
            Assert.assertNotNull(serverClusterId.getScope().get("clusters"));
        }
        catch (RestClientException rce) {
            Assert.fail((String)"The operation shouldn't have failed");
        }
    }

    @Test
    public void testGetSchemaRegistryServerVersion() throws Exception {
        SchemaRegistryServerVersion srVersion = this.restApp.restClient.getSchemaRegistryServerVersion();
        Assert.assertEquals((Object)AppInfoParser.getVersion(), (Object)srVersion.getVersion());
        Assert.assertEquals((Object)AppInfoParser.getCommitId(), (Object)srVersion.getCommitId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpResponseHeaders() throws Exception {
        String baseUrl = this.restApp.restClient.getBaseUrls().current();
        String requestUrl = this.buildRequestUrl(baseUrl, "/v1/metadata/id");
        HttpURLConnection connection = null;
        try {
            URL url = new URL(requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            Map<String, List<String>> httpResponseHeaders = connection.getHeaderFields();
            Assert.assertNotNull((Object)this.matchHeaderValue(httpResponseHeaders, "X-XSS-Protection", "1; mode=block"));
            Assert.assertNotNull((Object)this.matchHeaderValue(httpResponseHeaders, "Cache-Control", "no-cache, no-store, must-revalidate"));
            Assert.assertNull((Object)this.matchHeaderValue(httpResponseHeaders, "Strict-Transport-Security", "max-age=31536000"));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Test
    public void testGlobalMode() throws Exception {
        Assert.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode().getMode());
        String subject = "testSubject";
        String schema = TestUtils.getRandomCanonicalAvroString(1).get(0);
        TestUtils.registerAndVerifySchema(this.restApp.restClient, schema, 1, subject);
        try {
            this.restApp.restClient.getMode(subject).getMode();
            Assert.fail((String)String.format("Subject %s should not be found when there's no mode override", subject));
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)String.format("No mode override for subject %s, get mode should return not configured", subject), (long)40409L, (long)e.getErrorCode());
        }
        Assert.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode(subject, true).getMode());
        this.restApp.restClient.setMode("READONLY", null);
        this.restApp.restClient.setMode("READWRITE", subject);
        Assert.assertEquals((Object)"READWRITE", (Object)this.restApp.restClient.getMode(subject).getMode());
        this.restApp.restClient.deleteSubjectMode(subject);
        Assert.assertEquals((Object)"READONLY", (Object)this.restApp.restClient.getMode(subject, true).getMode());
        this.restApp.restClient.setMode("READONLY_OVERRIDE", null);
        Assert.assertEquals((Object)"READONLY_OVERRIDE", (Object)this.restApp.restClient.getMode(subject).getMode());
        try {
            this.restApp.restClient.registerSchema(schema, "testSubject2");
            Assert.fail((String)String.format("Subject %s is in read-only mode", "testSubject2"));
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Subject is in read-only mode", (long)42205L, (long)rce.getErrorCode());
        }
    }

    @Test
    public void testRegisterWithAndWithoutMetadata() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Map<String, String> properties = Collections.singletonMap("application.version", "2");
        Metadata metadata = new Metadata(null, properties, null);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setMetadata(metadata);
        int id = this.restApp.restClient.registerSchema(request1, subject, false).getId();
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)schema1);
        int id2 = this.restApp.restClient.registerSchema(request2, subject, false).getId();
        Assert.assertEquals((long)id, (long)id2);
    }

    @Test
    public void testRegisterDropsRuleSet() throws Exception {
        String subject = "testSubject";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
        Rule r1 = new Rule("foo", null, null, RuleMode.READ, "ENCRYPT", null, null, null, null, null, false);
        List<Rule> rules = Collections.singletonList(r1);
        RuleSet ruleSet = new RuleSet(null, rules);
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)schema1);
        request1.setRuleSet(ruleSet);
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(request1, subject, false).getId());
        SchemaString schemaString = this.restApp.restClient.getId(expectedIdSchema1, subject);
        Assert.assertNull((Object)schemaString.getRuleSet());
    }

    @Test
    public void testRegisterSchemaWithReservedFields() throws RestClientException, IOException {
        String subject0 = "testSubject0";
        AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f\"},{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}");
        RegisterSchemaRequest request1 = new RegisterSchemaRequest((ParsedSchema)Objects.requireNonNull(schema1));
        request1.setMetadata(new Metadata(Collections.emptyMap(), Collections.singletonMap("confluent:reserved", "f"), Collections.emptySet()));
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest();
        configUpdateRequest.setCompatibilityLevel(CompatibilityLevel.BACKWARD.name());
        configUpdateRequest.setValidateFields(Boolean.valueOf(true));
        Assert.assertEquals((String)"Updating config should succeed", (Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null));
        Assert.assertThrows((String)"Fail registering subject0 because of global validateFields", RestClientException.class, () -> this.restApp.restClient.registerSchema(request1, subject0, false));
        configUpdateRequest.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Updating config should succeed", (Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null));
        Assert.assertEquals((String)"Should register despite reserved fields", (long)1L, (long)this.restApp.restClient.registerSchema(request1, subject0, false).getId());
        String subject1 = "testSubject1";
        configUpdateRequest.setValidateFields(Boolean.valueOf(true));
        Assert.assertEquals((String)"Updating config should succeed", (Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, subject1));
        Assert.assertThrows((String)"Fail registering subject1 because of subject1 validateFields", RestClientException.class, () -> this.restApp.restClient.registerSchema(request1, subject1, false));
        String subject2 = "testSubject2";
        Assert.assertEquals((String)"Should register despite reserved fields", (long)1L, (long)this.restApp.restClient.registerSchema(request1, subject2, false).getId());
        configUpdateRequest.setValidateFields(Boolean.valueOf(true));
        Assert.assertEquals((String)"Updating config should succeed", (Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, null));
        configUpdateRequest.setValidateFields(Boolean.valueOf(false));
        Assert.assertEquals((String)"Updating config should succeed", (Object)configUpdateRequest, (Object)this.restApp.restClient.updateConfig(configUpdateRequest, subject1));
        Assert.assertEquals((String)"Should register despite reserved fields", (long)1L, (long)this.restApp.restClient.registerSchema(request1, subject1, false).getId());
        String subject3 = "testSubject3";
        Assert.assertThrows((String)"Fail registering because of subject3 validateFields", RestClientException.class, () -> this.restApp.restClient.registerSchema(request1, subject3, false));
        request1.setMetadata(new Metadata(Collections.emptyMap(), Collections.singletonMap("confluent:reserved", "g"), Collections.emptySet()));
        Assert.assertEquals((String)"Should register despite removal of reserved fields", (long)2L, (long)this.restApp.restClient.registerSchema(request1, subject1, false).getId());
        schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"g\" , \"default\":\"d\"}]}");
        RegisterSchemaRequest request2 = new RegisterSchemaRequest((ParsedSchema)Objects.requireNonNull(schema1));
        request2.setMetadata(new Metadata(Collections.emptyMap(), Collections.singletonMap("confluent:reserved", "g"), Collections.emptySet()));
        Assert.assertThrows((String)"Fail registering because of removal of reserved fields", RestClientException.class, () -> this.restApp.restClient.registerSchema(request2, subject0, false));
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Properties schemaRegistryProps = new Properties();
        schemaRegistryProps.put("response.http.headers.config", "add X-XSS-Protection: 1; mode=block, \"add Cache-Control: no-cache, no-store, must-revalidate\"");
        schemaRegistryProps.put("schema.providers.avro.validate.defaults", "true");
        return schemaRegistryProps;
    }

    private String matchHeaderValue(Map<String, List<String>> responseHeaders, String headerName, String expectedHeaderValue) {
        if (responseHeaders.isEmpty() || responseHeaders.get(headerName) == null) {
            return null;
        }
        return responseHeaders.get(headerName).stream().filter(value -> expectedHeaderValue.equals(value.trim())).findAny().orElse(null);
    }

    private String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }
}

