/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import io.confluent.kafka.schemaregistry.CompatibilityChecker;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class AvroCompatibilityTest {
    private final String schemaString1 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}";
    private final AvroSchema schema1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}");
    private final String schemaString2 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}";
    private final AvroSchema schema2 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}]}");
    private final String schemaString3 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}";
    private final AvroSchema schema3 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\"}]}");
    private final String schemaString4 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1_new\", \"aliases\": [\"f1\"]}]}";
    private final AvroSchema schema4 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1_new\", \"aliases\": [\"f1\"]}]}");
    private final String schemaString6 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
    private final AvroSchema schema6 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}");
    private final String schemaString7 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\", \"int\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}";
    private final AvroSchema schema7 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\", \"int\"],\"name\":\"f1\", \"doc\":\"doc of f1\"}]}");
    private final String schemaString8 = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}";
    private final AvroSchema schema8 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}");
    private final String badDefaultNullString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"default\": \"null\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}";

    @Test
    public void testBadDefaultNull() {
        Assert.assertNotNull((Object)AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":[\"null\", \"string\"],\"name\":\"f1\", \"default\": \"null\"}, {\"type\":\"string\",\"name\":\"f2\", \"default\": \"foo\"}, {\"type\":\"string\",\"name\":\"f3\", \"default\": \"bar\"}]}"));
    }

    @Test
    public void testBasicBackwardsCompatibility() {
        CompatibilityChecker checker = CompatibilityChecker.BACKWARD_CHECKER;
        Assert.assertTrue((String)"adding a field with default is a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertFalse((String)"adding a field w/o default is not a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertTrue((String)"changing field name with alias is a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema4, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertTrue((String)"evolving a field type to a union is a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema6, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertFalse((String)"removing a type from a union is not a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Collections.singletonList(this.schema6)).isEmpty());
        Assert.assertTrue((String)"adding a new type in union is a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema7, Collections.singletonList(this.schema6)).isEmpty());
        Assert.assertFalse((String)"removing a type from a union is not a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema6, Collections.singletonList(this.schema7)).isEmpty());
        Assert.assertTrue((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Arrays.asList(this.schema1, this.schema2)).isEmpty());
    }

    @Test
    public void testBasicBackwardsTransitiveCompatibility() {
        CompatibilityChecker checker = CompatibilityChecker.BACKWARD_TRANSITIVE_CHECKER;
        Assert.assertTrue((String)"iteratively adding fields with defaults is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema8, Arrays.asList(this.schema1, this.schema2)).isEmpty());
        Assert.assertTrue((String)"adding a field with default is a backward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertTrue((String)"removing a default is a compatible change, but not transitively", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Arrays.asList(this.schema2)).isEmpty());
        Assert.assertFalse((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Arrays.asList(this.schema2, this.schema1)).isEmpty());
    }

    @Test
    public void testBasicForwardsCompatibility() {
        CompatibilityChecker checker = CompatibilityChecker.FORWARD_CHECKER;
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Collections.singletonList(this.schema2)).isEmpty());
        Assert.assertTrue((String)"adding a field is a forward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema3)).isEmpty());
        Assert.assertTrue((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema3, this.schema2)).isEmpty());
    }

    @Test
    public void testBasicForwardsTransitiveCompatibility() {
        CompatibilityChecker checker = CompatibilityChecker.FORWARD_TRANSITIVE_CHECKER;
        Assert.assertTrue((String)"iteratively removing fields with defaults is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema8, this.schema2)).isEmpty());
        Assert.assertTrue((String)"adding default to a field is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema3)).isEmpty());
        Assert.assertTrue((String)"removing a field with a default is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema2)).isEmpty());
        Assert.assertFalse((String)"removing a default is not a transitively compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema2, this.schema3)).isEmpty());
    }

    @Test
    public void testBasicFullCompatibility() {
        CompatibilityChecker checker = CompatibilityChecker.FULL_CHECKER;
        Assert.assertTrue((String)"adding a field with default is a backward and a forward compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertTrue((String)"transitively adding a field without a default is not a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Arrays.asList(this.schema1, this.schema2)).isEmpty());
        Assert.assertTrue((String)"transitively removing a field without a default is not a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema3, this.schema2)).isEmpty());
    }

    @Test
    public void testBasicFullTransitiveCompatibility() {
        CompatibilityChecker checker = CompatibilityChecker.FULL_TRANSITIVE_CHECKER;
        Assert.assertTrue((String)"iteratively adding fields with defaults is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema8, Arrays.asList(this.schema1, this.schema2)).isEmpty());
        Assert.assertTrue((String)"iteratively removing fields with defaults is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema8, this.schema2)).isEmpty());
        Assert.assertTrue((String)"adding default to a field is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema3)).isEmpty());
        Assert.assertTrue((String)"removing a field with a default is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema2)).isEmpty());
        Assert.assertTrue((String)"adding a field with default is a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema2, Collections.singletonList(this.schema1)).isEmpty());
        Assert.assertTrue((String)"removing a default from a field compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Arrays.asList(this.schema2)).isEmpty());
        Assert.assertFalse((String)"transitively adding a field without a default is not a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema3, Arrays.asList(this.schema2, this.schema1)).isEmpty());
        Assert.assertFalse((String)"transitively removing a field without a default is not a compatible change", (boolean)checker.isCompatible((ParsedSchema)this.schema1, Arrays.asList(this.schema2, this.schema3)).isEmpty());
    }
}

