/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.util;

import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.util.KafkaClientSupplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class ByteProducerPool {
    private final Map<Integer, Producer<byte[], byte[]>> producers = new ConcurrentHashMap<Integer, Producer<byte[], byte[]>>();
    private final Function<Integer, Producer<byte[], byte[]>> factory = uid -> clientSupplier.getProducer(config);
    private final IdMappingServiceProvider uidMapper;

    public ByteProducerPool(Map<String, Object> config, KafkaClientSupplier clientSupplier, IdMappingServiceProvider uidMapper) {
        this.uidMapper = uidMapper;
    }

    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
        try {
            String userName = UserGroupInformation.getCurrentUser().getUserName();
            return this.producers.computeIfAbsent(this.uidMapper.getUid(userName), this.factory).send(record);
        }
        catch (Exception e) {
            throw Errors.serverLoginException(e);
        }
    }

    public void close() {
        for (Producer<byte[], byte[]> producer : this.producers.values()) {
            producer.close();
        }
    }
}

