/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.util;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.util.KafkaClientSupplier;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;

public class ByteConsumerPool {
    private final ThreadLocal<Map<Integer, Consumer<byte[], byte[]>>> consumers = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private final Map<String, Object> config;
    private final IdMappingServiceProvider idMapper;
    private final KafkaClientSupplier clientSupplier;

    public ByteConsumerPool(Map<String, Object> config, KafkaClientSupplier clientSupplier, IdMappingServiceProvider idMapper) {
        this.config = config;
        this.idMapper = idMapper;
        this.clientSupplier = clientSupplier;
    }

    public ConsumerRecords<byte[], byte[]> poll(String topic) {
        try {
            String userName = UserGroupInformation.getCurrentUser().getUserName();
            int userUid = this.idMapper.getUid(userName);
            Consumer consumer = this.consumers.get().computeIfAbsent(userUid, this::createConsumerWithGroup);
            List<TopicPartition> partitions = Collections.singletonList(new TopicPartition(topic, 0));
            consumer.assign(partitions);
            consumer.seekToBeginning(partitions);
            return consumer.poll(Duration.ofMillis(1000L));
        }
        catch (Exception e) {
            throw Errors.serverLoginException(e);
        }
    }

    private Consumer<byte[], byte[]> createConsumerWithGroup(int userId) {
        long threadId = Thread.currentThread().getId();
        String groupId = String.format("t_%d_u%d", threadId, userId);
        return this.clientSupplier.getConsumer((Map<String, Object>)ImmutableMap.builder().putAll(this.config).put((Object)"group.id", (Object)groupId).build());
    }
}

