/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.handlers;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.TagSchemaRequest;
import io.confluent.kafka.schemaregistry.rest.handlers.UpdateRequestHandler;
import java.util.List;

public class CompositeUpdateRequestHandler
implements UpdateRequestHandler {
    private List<UpdateRequestHandler> handlers;

    public CompositeUpdateRequestHandler(List<UpdateRequestHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(ConfigUpdateRequest request) {
        for (UpdateRequestHandler handler : this.handlers) {
            handler.handle(request);
        }
    }

    @Override
    public void handle(String subject, ConfigUpdateRequest request) {
        for (UpdateRequestHandler handler : this.handlers) {
            handler.handle(subject, request);
        }
    }

    @Override
    public void handle(String subject, boolean normalize, RegisterSchemaRequest request) {
        for (UpdateRequestHandler handler : this.handlers) {
            handler.handle(subject, normalize, request);
        }
    }

    @Override
    public void handle(Schema schema, TagSchemaRequest request) {
        for (UpdateRequestHandler handler : this.handlers) {
            handler.handle(schema, request);
        }
    }
}

