/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.filter;

import io.confluent.kafka.schemaregistry.filter.AuthorizationFilter;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.util.ByteConsumerPool;
import io.confluent.kafka.schemaregistry.util.ByteProducerPool;
import io.confluent.kafka.schemaregistry.util.KafkaClientSupplier;
import io.confluent.kafka.schemaregistry.util.UnixUserIdUtils;
import java.util.HashMap;
import org.apache.hadoop.security.IdMappingServiceProvider;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class AuthorizationFilterProvider {
    private static final String INTERNAL_TOPIC = "schema-registry-authorization-auxiliary-topic";

    public static AuthorizationFilter configure(SchemaRegistryConfig schemaRegistryConfig) {
        KafkaClientSupplier clientSupplier = new KafkaClientSupplier();
        IdMappingServiceProvider idMapper = UnixUserIdUtils.getUnixIdMapper();
        ByteConsumerPool consumerPool = AuthorizationFilterProvider.createConsumerPool(clientSupplier, idMapper);
        ByteProducerPool producerPool = AuthorizationFilterProvider.createProducerPool(clientSupplier, idMapper);
        String internalTopic = AuthorizationFilterProvider.getConfiguredAuxiliaryTopic(schemaRegistryConfig);
        AuthorizationFilter filter = new AuthorizationFilter(consumerPool, producerPool, internalTopic);
        filter.initialize();
        return filter;
    }

    private static String getConfiguredAuxiliaryTopic(SchemaRegistryConfig schemaRegistryConfig) {
        String kafkaStoreStream = schemaRegistryConfig.getKafkaStoreStream();
        return String.format("%s:%s", kafkaStoreStream, INTERNAL_TOPIC);
    }

    private static ByteProducerPool createProducerPool(KafkaClientSupplier clientSupplier, IdMappingServiceProvider idMapper) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("acks", "-1");
        properties.put("key.serializer", ByteArraySerializer.class);
        properties.put("value.serializer", ByteArraySerializer.class);
        properties.put("retries", 0);
        properties.put("enable.idempotence", false);
        properties.put("streams.buffer.max.time.ms", "0");
        return new ByteProducerPool(properties, clientSupplier, idMapper);
    }

    private static ByteConsumerPool createConsumerPool(KafkaClientSupplier clientSupplier, IdMappingServiceProvider idMapper) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("auto.offset.reset", "earliest");
        properties.put("enable.auto.commit", "false");
        properties.put("key.deserializer", ByteArrayDeserializer.class);
        properties.put("value.deserializer", ByteArrayDeserializer.class);
        return new ByteConsumerPool(properties, clientSupplier, idMapper);
    }
}

