/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.CloseableIterator;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.InMemoryCache;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.SubjectKey;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class SchemaRegistryKeysTest {
    @Test
    public void testSchemaKeySerdeForMagicByte0() {
        String subject = "foo";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(0);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        byte[] serializedKey = null;
        try {
            serializedKey = serializer.serializeKey((Object)key);
        }
        catch (SerializationException e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)serializedKey);
        try {
            SchemaRegistryKey deserializedKey = (SchemaRegistryKey)serializer.deserializeKey(serializedKey);
            Assert.assertEquals((String)"Deserialized key should be equal to original key", (Object)key, (Object)deserializedKey);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSchemaKeySerdeForMagicByte1() {
        String subject = "foo";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        byte[] serializedKey = null;
        try {
            serializedKey = serializer.serializeKey((Object)key);
        }
        catch (SerializationException e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)serializedKey);
        try {
            SchemaRegistryKey deserializedKey = (SchemaRegistryKey)serializer.deserializeKey(serializedKey);
            Assert.assertEquals((String)"Deserialized key should be equal to original key", (Object)key, (Object)deserializedKey);
        }
        catch (SerializationException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSchemaKeySerdeForUnSupportedMagicByte() {
        String subject = "foo";
        int version = 1;
        SchemaKey key = new SchemaKey(subject, version);
        key.setMagicByte(2);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        byte[] serializedKey = null;
        try {
            serializedKey = serializer.serializeKey((Object)key);
        }
        catch (SerializationException e) {
            Assert.fail();
        }
        Assert.assertNotNull((Object)serializedKey);
        try {
            serializer.deserializeKey(serializedKey);
            Assert.fail((String)"Deserialization shouldn't be supported");
        }
        catch (SerializationException e) {
            Assert.assertEquals((Object)"Can't deserialize schema for the magic byte 2", (Object)e.getMessage());
        }
    }

    @Test
    public void testSchemaKeyComparator() throws Exception {
        String subject = "foo";
        SchemaKey key1 = new SchemaKey(subject, 1);
        SchemaKey key2 = new SchemaKey(subject, Integer.MAX_VALUE);
        Assert.assertTrue((String)"key 1 should be less than key2", (key1.compareTo((SchemaRegistryKey)key2) < 0 ? 1 : 0) != 0);
        SchemaKey key1Dup = new SchemaKey(subject, 1);
        Assert.assertEquals((String)"key 1 should be equal to key1Dup", (Object)key1, (Object)key1Dup);
        String subject4 = "bar";
        SchemaKey key4 = new SchemaKey(subject4, 1);
        Assert.assertTrue((String)"key1 should be greater than key4", (key1.compareTo((SchemaRegistryKey)key4) > 0 ? 1 : 0) != 0);
        String subject5 = "fo";
        SchemaKey key5 = new SchemaKey(subject5, 1);
        Assert.assertTrue((String)"key5 should be less than key1", (key1.compareTo((SchemaRegistryKey)key5) > 0 ? 1 : 0) != 0);
        SchemaRegistryKey[] expectedOrder = new SchemaRegistryKey[]{key4, key5, key1, key2};
        this.testStoreKeyOrder(expectedOrder);
    }

    @Test
    public void testConfigKeySerde() {
        String subject = "foo";
        ConfigKey key1 = new ConfigKey(null);
        ConfigKey key2 = new ConfigKey(subject);
        SchemaRegistrySerializer serializer = new SchemaRegistrySerializer();
        byte[] serializedKey1 = null;
        byte[] serializedKey2 = null;
        try {
            serializedKey1 = serializer.serializeKey((Object)key1);
            serializedKey2 = serializer.serializeKey((Object)key2);
        }
        catch (SerializationException e) {
            Assert.fail();
        }
        try {
            SchemaRegistryKey deserializedKey1 = (SchemaRegistryKey)serializer.deserializeKey(serializedKey1);
            SchemaRegistryKey deserializedKey2 = (SchemaRegistryKey)serializer.deserializeKey(serializedKey2);
            Assert.assertEquals((String)"Deserialized key should be equal to original key", (Object)key1, (Object)deserializedKey1);
            Assert.assertEquals((String)"Deserialized key should be equal to original key", (Object)key2, (Object)deserializedKey2);
        }
        catch (SerializationException e) {
            Assert.fail();
        }
    }

    @Test
    public void testConfigKeyComparator() throws Exception {
        ConfigKey key1 = new ConfigKey(null);
        ConfigKey key2 = new ConfigKey(null);
        Assert.assertEquals((String)"Top level config keys should be equal", (Object)key1, (Object)key2);
        String subject = "foo";
        ConfigKey key3 = new ConfigKey(subject);
        Assert.assertTrue((String)"Top level config should be less than subject level config", (key1.compareTo((SchemaRegistryKey)key3) < 0 ? 1 : 0) != 0);
        String subject4 = "bar";
        ConfigKey key4 = new ConfigKey(subject4);
        Assert.assertTrue((String)"key3 should be greater than key4", (key3.compareTo((SchemaRegistryKey)key4) > 0 ? 1 : 0) != 0);
        SchemaRegistryKey[] expectedOrder = new SchemaRegistryKey[]{key1, key4, key3};
        this.testStoreKeyOrder(expectedOrder);
    }

    @Test
    public void testKeyComparator() throws Exception {
        String subject = "foo";
        ConfigKey topLevelConfigKey = new ConfigKey(null);
        ConfigKey subjectLevelConfigKey = new ConfigKey(subject);
        SchemaKey schemaKey = new SchemaKey(subject, 1);
        SchemaKey schemaKeyWithHigherVersion = new SchemaKey(subject, 2);
        SchemaRegistryKey[] expectedOrder = new SchemaRegistryKey[]{topLevelConfigKey, subjectLevelConfigKey, schemaKey, schemaKeyWithHigherVersion};
        this.testStoreKeyOrder(expectedOrder);
    }

    private void testStoreKeyOrder(SchemaRegistryKey[] orderedKeys) throws StoreInitializationException {
        int numKeys = orderedKeys.length;
        InMemoryCache store = new InMemoryCache((Serializer)new SchemaRegistrySerializer());
        store.init();
        while (--numKeys >= 0) {
            try {
                store.put((Object)orderedKeys[numKeys], (Object)SchemaRegistryKeysTest.toValue(orderedKeys[numKeys]));
            }
            catch (StoreException e) {
                Assert.fail((String)("Error writing key " + orderedKeys[numKeys].toString() + " to the in memory store"));
            }
        }
        try (CloseableIterator keys = store.getAllKeys();){
            Object[] retrievedKeyOrder = new SchemaRegistryKey[orderedKeys.length];
            int keyIndex = 0;
            while (keys.hasNext()) {
                retrievedKeyOrder[keyIndex++] = (SchemaRegistryKey)keys.next();
            }
            Assert.assertArrayEquals((Object[])orderedKeys, (Object[])retrievedKeyOrder);
        }
        catch (StoreException e) {
            Assert.fail();
        }
    }

    private static SchemaValue toValue(SchemaRegistryKey key) {
        if (key instanceof SubjectKey) {
            SubjectKey subjectKey = (SubjectKey)key;
            return new SchemaValue(subjectKey.getSubject(), Integer.valueOf(1), Integer.valueOf(0), "dummy", false);
        }
        return new SchemaValue("dummy", Integer.valueOf(1), Integer.valueOf(0), "dummy", false);
    }
}

