/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProviderFactory;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class SchemaRegistryErrorHandlerTest
extends ClusterTestHarness {
    Properties props = new Properties();
    private final String schemaString1 = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();
    private final String subject = "testSubject";

    public SchemaRegistryErrorHandlerTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testIncorrectPassword() throws Exception {
        this.setupBasicAuthClient("pkey", "incorrect");
        try {
            this.restApp.restClient.registerSchema(this.schemaString1, "testSubject");
            Assert.fail((String)"Should fail for incorrect password");
        }
        catch (RestClientException ex) {
            Assert.assertEquals((long)401L, (long)ex.getStatus());
            Assert.assertEquals((Object)"Unauthorized; error code: 401", (Object)ex.getMessage());
        }
    }

    private void setupBasicAuthClient(String user, String password) {
        String restUrl = new StringBuilder(this.restApp.restConnect).insert(this.getSchemaRegistryProtocol().length() + 3, user + ":" + password + "@").toString();
        this.restApp.restClient = new RestService(restUrl);
        BasicAuthCredentialProvider basicAuthCredentialProvider = BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider((String)"URL", new HashMap());
        this.restApp.restClient.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
    }

    @Override
    protected Properties getSchemaRegistryProperties() {
        Configuration.setConfiguration(null);
        this.props.put("authorization.enable", (Object)false);
        this.props.put("authentication.realm", "SchemaRegistry");
        this.props.put("authentication.roles", "ccloud");
        try {
            File jaasConfigFile = File.createTempFile("ks-jaas-", ".conf");
            jaasConfigFile.deleteOnExit();
            File userPropsFile = new File(SchemaRegistryErrorHandlerTest.class.getResource("/testauth.properties").getFile());
            System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("SchemaRegistry { org.eclipse.jetty.jaas.spi.PropertyFileLoginModule required file=\"" + userPropsFile.getAbsolutePath() + "\";};");
            Files.write(jaasConfigFile.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.props;
    }

    @Override
    protected String getSchemaRegistryProtocol() {
        return "http";
    }
}

