/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.RequestIdHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.MDC;

@RunWith(value=MockitoJUnitRunner.class)
public class RequestIdHandlerTest {
    RequestIdHandler requestIdHandler = new RequestIdHandler();
    @Mock
    Request baseRequest;
    @Mock
    HttpServletRequest request;
    @Mock
    HttpServletResponse response;

    @Before
    public void setup() {
        Mockito.reset((Object[])new Object[]{this.baseRequest, this.request, this.response});
        MDC.clear();
    }

    @Test
    public void testRequestHandlerWith1RequestId() throws IOException, ServletException {
        RequestIdHandler requestIdHandlerSpy = (RequestIdHandler)Mockito.spy((Object)new RequestIdHandler());
        Enumeration<String> headers = Collections.enumeration(Collections.singletonList("request-ID-4329"));
        Mockito.when((Object)this.baseRequest.getHeaders("X-Request-ID")).thenReturn(headers);
        requestIdHandlerSpy.handle("/subjects/subject-2/versions", this.baseRequest, this.request, this.response);
        ((RequestIdHandler)Mockito.verify((Object)requestIdHandlerSpy, (VerificationMode)Mockito.times((int)1))).getRequestId(Collections.singletonList("request-ID-4329"));
        ((Request)Mockito.verify((Object)this.baseRequest, (VerificationMode)Mockito.times((int)1))).getHeaders("X-Request-ID");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader("X-Request-ID", "request-ID-4329");
        Assert.assertEquals((Object)"request-ID-4329", (Object)MDC.get((String)"requestId"));
    }

    @Test
    public void testRequestHandlerWithoutRequestId() throws IOException, ServletException {
        ArgumentCaptor requestIdCaptor = ArgumentCaptor.forClass(String.class);
        RequestIdHandler requestIdHandlerSpy = (RequestIdHandler)Mockito.spy((Object)new RequestIdHandler());
        Enumeration headers = Collections.enumeration(Collections.emptyList());
        Mockito.when((Object)this.baseRequest.getHeaders("X-Request-ID")).thenReturn(headers);
        requestIdHandlerSpy.handle("/subjects/subject-2/versions", this.baseRequest, this.request, this.response);
        ((RequestIdHandler)Mockito.verify((Object)requestIdHandlerSpy, (VerificationMode)Mockito.times((int)1))).getRequestId(Collections.emptyList());
        ((Request)Mockito.verify((Object)this.baseRequest, (VerificationMode)Mockito.times((int)1))).getHeaders("X-Request-ID");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader((String)ArgumentMatchers.eq((Object)"X-Request-ID"), (String)requestIdCaptor.capture());
        String generatedRequestId = (String)requestIdCaptor.getValue();
        Assert.assertEquals((Object)generatedRequestId, (Object)MDC.get((String)"requestId"));
        this.validateUuid(generatedRequestId);
    }

    @Test
    public void testRequestHandlerWithMultipleRequestId() throws IOException, ServletException {
        ArgumentCaptor requestIdCaptor = ArgumentCaptor.forClass(String.class);
        RequestIdHandler requestIdHandlerSpy = (RequestIdHandler)Mockito.spy((Object)new RequestIdHandler());
        Enumeration<String> headers = Collections.enumeration(Arrays.asList("request-ID6", "request-ID4"));
        Mockito.when((Object)this.baseRequest.getHeaders("X-Request-ID")).thenReturn(headers);
        requestIdHandlerSpy.handle("/subjects/subject-2/versions", this.baseRequest, this.request, this.response);
        ((RequestIdHandler)Mockito.verify((Object)requestIdHandlerSpy, (VerificationMode)Mockito.times((int)1))).getRequestId(Arrays.asList("request-ID6", "request-ID4"));
        ((Request)Mockito.verify((Object)this.baseRequest, (VerificationMode)Mockito.times((int)1))).getHeaders("X-Request-ID");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader((String)ArgumentMatchers.eq((Object)"X-Request-ID"), (String)requestIdCaptor.capture());
        String generatedRequestId = (String)requestIdCaptor.getValue();
        Assert.assertEquals((Object)generatedRequestId, (Object)MDC.get((String)"requestId"));
        this.validateUuid(generatedRequestId);
    }

    @Test
    public void testGetRequestIdWith1RequestId() {
        String requestId = this.requestIdHandler.getRequestId(Collections.singletonList("request-ID-1234"));
        Assert.assertEquals((String)"Request ID must not change", (Object)"request-ID-1234", (Object)requestId);
    }

    @Test
    public void testGetRequestIdWithoutRequestId() {
        String requestId = this.requestIdHandler.getRequestId(Collections.emptyList());
        this.validateUuid(requestId);
    }

    @Test
    public void testGetRequestIdWithMultipleRequestId() {
        String requestId = this.requestIdHandler.getRequestId(Arrays.asList("request-ID1", "request-ID2"));
        this.validateUuid(requestId);
    }

    @Test
    public void testGetRequestIdWithBlankRequestId() {
        String requestId = this.requestIdHandler.getRequestId(Collections.singletonList("   "));
        this.validateUuid(requestId);
    }

    private void validateUuid(String requestId) {
        Assert.assertEquals((String)"Request ID is not a valid UUID", (Object)UUID.fromString(requestId).toString(), (Object)requestId);
    }
}

