/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.InvalidSchemaException;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.ReferenceExistsException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryTimeoutException;
import io.confluent.kafka.schemaregistry.exceptions.SubjectNotSoftDeletedException;
import io.confluent.kafka.schemaregistry.filter.Permission;
import io.confluent.kafka.schemaregistry.filter.RequirePermission;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.impersonation.ImpersonationUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/subjects")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SubjectsResource {
    public static final String apiTag = "Subjects (v1)";
    private static final Logger log = LoggerFactory.getLogger(SubjectsResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public SubjectsResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @POST
    @DocumentedName(value="lookUpSchemaUnderSubject")
    @Path(value="/{subject: .+}")
    @Operation(summary="Lookup schema under subject", description="Check if a schema has already been registered under the specified subject. If so, this returns the schema string along with its globally unique identifier, its version under this subject and the subject name.", responses={@ApiResponse(responseCode="200", description="The schema.", content={@Content(schema=@Schema(implementation=io.confluent.kafka.schemaregistry.client.rest.entities.Schema.class))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found. Error code 40403 indicates schema not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Subjects (v1)")})
    @PerformanceMetric(value="subjects.get-schema")
    @RequirePermission(value=Permission.READ)
    public void lookUpSchemaUnderSubject(@Context HttpServletRequest httpServletRequest, @Suspended AsyncResponse asyncResponse, @Parameter(description="Subject under which the schema will be registered", required=true) @PathParam(value="subject") String subject, @Parameter(description="Whether to normalize the given schema") @QueryParam(value="normalize") boolean normalize, @Parameter(description="Whether to lookup deleted schemas") @QueryParam(value="deleted") boolean lookupDeletedSchema, @Parameter(description="Schema", required=true) @NotNull RegisterSchemaRequest request) {
        ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> {
            this.lookUpSchemaUnderSubject(asyncResponse, subject, normalize, lookupDeletedSchema, request);
            return null;
        }, (String)httpServletRequest.getRemoteUser());
    }

    private void lookUpSchemaUnderSubject(AsyncResponse asyncResponse, String subject, boolean normalize, boolean lookupDeletedSchema, RegisterSchemaRequest request) {
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema matchingSchema;
        log.debug("Schema lookup under subject {}, deleted {}, type {}", new Object[]{subject, lookupDeletedSchema, request.getSchemaType()});
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema schema = new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(subject, request);
        try {
            if (!normalize) {
                normalize = Boolean.TRUE.equals(this.schemaRegistry.getConfigInScope(subject).isNormalize());
            }
            if ((matchingSchema = this.schemaRegistry.lookUpSchemaUnderSubjectUsingContexts(subject, schema, normalize, lookupDeletedSchema)) == null) {
                if (!this.schemaRegistry.hasSubjects(subject, lookupDeletedSchema)) {
                    throw Errors.subjectNotFoundException(subject);
                }
                throw Errors.schemaNotFoundException();
            }
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while looking up schema under subject " + subject, e);
        }
        asyncResponse.resume((Object)matchingSchema);
    }

    @GET
    @DocumentedName(value="getLatestWithMetadata")
    @Path(value="/{subject}/metadata")
    @Operation(summary="Retrieve the latest version with the given metadata.", description="Retrieve the latest version with the given metadata.", responses={@ApiResponse(responseCode="200", description="The schema", content={@Content(schema=@Schema(implementation=io.confluent.kafka.schemaregistry.client.rest.entities.Schema.class))}), @ApiResponse(responseCode="404", description="Error code 40401 -- Subject not found\nError code 40403 -- Schema not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @PerformanceMetric(value="subjects.get-latest-with-metadata")
    public void getLatestWithMetadata(@Suspended AsyncResponse asyncResponse, @Parameter(description="Subject under which the schema will be registered", required=true) @PathParam(value="subject") String subject, @Parameter(description="The metadata key") @QueryParam(value="key") List<String> keys, @Parameter(description="The metadata value") @QueryParam(value="value") List<String> values, @Parameter(description="Whether to lookup deleted schemas") @QueryParam(value="deleted") boolean lookupDeletedSchema) {
        io.confluent.kafka.schemaregistry.client.rest.entities.Schema matchingSchema;
        log.info("Latest with metadata under subject {}, keys {}, values {}, deleted {}", new Object[]{subject, keys, values, lookupDeletedSchema});
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < Math.min(keys.size(), values.size()); ++i) {
            metadata.put(keys.get(i), values.get(i));
        }
        try {
            matchingSchema = this.schemaRegistry.getLatestWithMetadata(subject, metadata, lookupDeletedSchema);
            if (matchingSchema == null) {
                if (!this.schemaRegistry.hasSubjects(subject, lookupDeletedSchema)) {
                    throw Errors.subjectNotFoundException(subject);
                }
                throw Errors.schemaNotFoundException();
            }
        }
        catch (InvalidSchemaException e) {
            throw Errors.invalidSchemaException(e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while looking up schema under subject " + subject, e);
        }
        asyncResponse.resume((Object)matchingSchema);
    }

    @GET
    @DocumentedName(value="getAllSubjects")
    @Valid
    @Operation(summary="List subjects", description="Retrieves a list of registered subjects matching specified parameters.", responses={@ApiResponse(responseCode="200", description="List of subjects matching the specified parameters.", content={@Content(array=@ArraySchema(schema=@Schema(example="User")))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Subjects (v1)")})
    @PerformanceMetric(value="subjects.list")
    @RequirePermission(value=Permission.READ)
    public Set<String> list(@Context HttpServletRequest httpServletRequest, @DefaultValue(value=":*:") @Parameter(description="Subject name prefix") @QueryParam(value="subjectPrefix") String subjectPrefix, @Parameter(description="Whether to look up deleted subjects") @QueryParam(value="deleted") boolean lookupDeletedSubjects, @Parameter(description="Whether to return deleted subjects only") @QueryParam(value="deletedOnly") boolean lookupDeletedOnlySubjects) {
        return (Set)ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> this.list(subjectPrefix, lookupDeletedSubjects, lookupDeletedOnlySubjects), (String)httpServletRequest.getRemoteUser());
    }

    private Set<String> list(@QueryParam(value="subjectPrefix") String subjectPrefix, @QueryParam(value="deleted") boolean lookupDeletedSubjects, @QueryParam(value="deletedOnly") boolean lookupDeletedOnlySubjects) {
        LookupFilter filter = LookupFilter.DEFAULT;
        if (lookupDeletedOnlySubjects) {
            filter = LookupFilter.DELETED_ONLY;
        } else if (lookupDeletedSubjects) {
            filter = LookupFilter.INCLUDE_DELETED;
        }
        try {
            return this.schemaRegistry.listSubjectsWithPrefix(subjectPrefix != null ? subjectPrefix : ":*:", filter);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while listing subjects", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while listing subjects", e);
        }
    }

    @DELETE
    @DocumentedName(value="deleteSubject")
    @Path(value="/{subject: .+}")
    @Operation(summary="Delete subject", description="Deletes the specified subject and its associated compatibility level if registered. It is recommended to use this API only when a topic needs to be recycled or in development environment.", responses={@ApiResponse(responseCode="200", description="Operation succeeded. Returns list of schema versions deleted", content={@Content(array=@ArraySchema(schema=@Schema(type="integer", format="int32", example="1")))}), @ApiResponse(responseCode="404", description="Not Found. Error code 40401 indicates subject not found.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store.", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Subjects (v1)")})
    @PerformanceMetric(value="subjects.delete-subject")
    @RequirePermission(value=Permission.MODIFY)
    public void deleteSubject(@Context HttpServletRequest httpServletRequest, @Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the subject", required=true) @PathParam(value="subject") String subject, @Parameter(description="Whether to perform a permanent delete") @QueryParam(value="permanent") boolean permanentDelete) {
        ImpersonationUtils.runAsUserIfImpersonationEnabled(() -> {
            this.deleteSubject(asyncResponse, headers, subject, permanentDelete);
            return null;
        }, (String)httpServletRequest.getRemoteUser());
    }

    private void deleteSubject(AsyncResponse asyncResponse, HttpHeaders headers, String subject, boolean permanentDelete) {
        List<Integer> deletedVersions;
        log.debug("Deleting subject {}", (Object)subject);
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            if (!this.schemaRegistry.hasSubjects(subject, true)) {
                throw Errors.subjectNotFoundException(subject);
            }
            if (!permanentDelete && !this.schemaRegistry.hasSubjects(subject, false)) {
                throw Errors.subjectSoftDeletedException(subject);
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            deletedVersions = this.schemaRegistry.deleteSubjectOrForward(headerProperties, subject, permanentDelete);
        }
        catch (ReferenceExistsException e) {
            throw Errors.referenceExistsException(e.getMessage());
        }
        catch (SubjectNotSoftDeletedException e) {
            throw Errors.subjectNotSoftDeletedException(subject);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Delete subject operation timed out", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while deleting the subject " + subject, e);
        }
        asyncResponse.resume(deletedVersions);
    }
}

